/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"operation", "value"})
public class BrandVariantsRestriction {
    public static final String JSON_PROPERTY_OPERATION = "operation";
    private String operation;
    public static final String JSON_PROPERTY_VALUE = "value";
    private List<String> value = null;

    public BrandVariantsRestriction operation(String operation) {
        this.operation = operation;
        return this;
    }

    @ApiModelProperty(required=true, value="Defines how the condition must be evaluated.")
    @JsonProperty(value="operation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOperation() {
        return this.operation;
    }

    @JsonProperty(value="operation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOperation(String operation) {
        this.operation = operation;
    }

    public BrandVariantsRestriction value(List<String> value) {
        this.value = value;
        return this;
    }

    public BrandVariantsRestriction addValueItem(String valueItem) {
        if (this.value == null) {
            this.value = new ArrayList<String>();
        }
        this.value.add(valueItem);
        return this;
    }

    @ApiModelProperty(value="List of card brand variants.  Possible values:   - **mc**, **mccredit**, **mccommercialcredit_b2b**, **mcdebit**, **mcbusinessdebit**, **mcbusinessworlddebit**, **mcprepaid**, **mcmaestro**   - **visa**, **visacredit**, **visadebit**, **visaprepaid**.  You can specify a rule for a generic variant. For example, to create a rule for all Mastercard payment instruments, use **mc**. The rule is applied to all payment instruments under **mc**, such as **mcbusinessdebit** and **mcdebit**.  ")
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValue(List<String> value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrandVariantsRestriction brandVariantsRestriction = (BrandVariantsRestriction)o;
        return Objects.equals(this.operation, brandVariantsRestriction.operation) && Objects.equals(this.value, brandVariantsRestriction.value);
    }

    public int hashCode() {
        return Objects.hash(this.operation, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BrandVariantsRestriction {\n");
        sb.append("    operation: ").append(this.toIndentedString(this.operation)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static BrandVariantsRestriction fromJson(String jsonString) throws JsonProcessingException {
        return (BrandVariantsRestriction)JSON.getMapper().readValue(jsonString, BrandVariantsRestriction.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

