/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"description", "issuingCountryCode", "issuingCountryCodes", "onlyForCrossBalancePlatform", "paymentInstrumentType", "type"})
public class PaymentInstrumentRequirement {
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_ISSUING_COUNTRY_CODE = "issuingCountryCode";
    private String issuingCountryCode;
    public static final String JSON_PROPERTY_ISSUING_COUNTRY_CODES = "issuingCountryCodes";
    private List<String> issuingCountryCodes = null;
    public static final String JSON_PROPERTY_ONLY_FOR_CROSS_BALANCE_PLATFORM = "onlyForCrossBalancePlatform";
    private Boolean onlyForCrossBalancePlatform;
    public static final String JSON_PROPERTY_PAYMENT_INSTRUMENT_TYPE = "paymentInstrumentType";
    private PaymentInstrumentTypeEnum paymentInstrumentType;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public PaymentInstrumentRequirement description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Specifies the requirements for the payment instrument that need to be included in the request for a particular route.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public PaymentInstrumentRequirement issuingCountryCode(String issuingCountryCode) {
        this.issuingCountryCode = issuingCountryCode;
        return this;
    }

    @ApiModelProperty(value="The two-character [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code where the payment instrument is issued. For example, **NL** or **US**.")
    @JsonProperty(value="issuingCountryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIssuingCountryCode() {
        return this.issuingCountryCode;
    }

    @JsonProperty(value="issuingCountryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIssuingCountryCode(String issuingCountryCode) {
        this.issuingCountryCode = issuingCountryCode;
    }

    public PaymentInstrumentRequirement issuingCountryCodes(List<String> issuingCountryCodes) {
        this.issuingCountryCodes = issuingCountryCodes;
        return this;
    }

    public PaymentInstrumentRequirement addIssuingCountryCodesItem(String issuingCountryCodesItem) {
        if (this.issuingCountryCodes == null) {
            this.issuingCountryCodes = new ArrayList<String>();
        }
        this.issuingCountryCodes.add(issuingCountryCodesItem);
        return this;
    }

    @ApiModelProperty(value="The two-character ISO-3166-1 alpha-2 country code list for payment instruments.")
    @JsonProperty(value="issuingCountryCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getIssuingCountryCodes() {
        return this.issuingCountryCodes;
    }

    @JsonProperty(value="issuingCountryCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIssuingCountryCodes(List<String> issuingCountryCodes) {
        this.issuingCountryCodes = issuingCountryCodes;
    }

    public PaymentInstrumentRequirement onlyForCrossBalancePlatform(Boolean onlyForCrossBalancePlatform) {
        this.onlyForCrossBalancePlatform = onlyForCrossBalancePlatform;
        return this;
    }

    @ApiModelProperty(value="Specifies if the requirement only applies to transfers to another balance platform.")
    @JsonProperty(value="onlyForCrossBalancePlatform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getOnlyForCrossBalancePlatform() {
        return this.onlyForCrossBalancePlatform;
    }

    @JsonProperty(value="onlyForCrossBalancePlatform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOnlyForCrossBalancePlatform(Boolean onlyForCrossBalancePlatform) {
        this.onlyForCrossBalancePlatform = onlyForCrossBalancePlatform;
    }

    public PaymentInstrumentRequirement paymentInstrumentType(PaymentInstrumentTypeEnum paymentInstrumentType) {
        this.paymentInstrumentType = paymentInstrumentType;
        return this;
    }

    @ApiModelProperty(value="The type of the payment instrument. For example, \"BankAccount\" or \"Card\".")
    @JsonProperty(value="paymentInstrumentType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PaymentInstrumentTypeEnum getPaymentInstrumentType() {
        return this.paymentInstrumentType;
    }

    @JsonProperty(value="paymentInstrumentType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentInstrumentType(PaymentInstrumentTypeEnum paymentInstrumentType) {
        this.paymentInstrumentType = paymentInstrumentType;
    }

    public PaymentInstrumentRequirement type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="**paymentInstrumentRequirement**")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentInstrumentRequirement paymentInstrumentRequirement = (PaymentInstrumentRequirement)o;
        return Objects.equals(this.description, paymentInstrumentRequirement.description) && Objects.equals(this.issuingCountryCode, paymentInstrumentRequirement.issuingCountryCode) && Objects.equals(this.issuingCountryCodes, paymentInstrumentRequirement.issuingCountryCodes) && Objects.equals(this.onlyForCrossBalancePlatform, paymentInstrumentRequirement.onlyForCrossBalancePlatform) && Objects.equals((Object)this.paymentInstrumentType, (Object)paymentInstrumentRequirement.paymentInstrumentType) && Objects.equals((Object)this.type, (Object)paymentInstrumentRequirement.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.description, this.issuingCountryCode, this.issuingCountryCodes, this.onlyForCrossBalancePlatform, this.paymentInstrumentType, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentInstrumentRequirement {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    issuingCountryCode: ").append(this.toIndentedString(this.issuingCountryCode)).append("\n");
        sb.append("    issuingCountryCodes: ").append(this.toIndentedString(this.issuingCountryCodes)).append("\n");
        sb.append("    onlyForCrossBalancePlatform: ").append(this.toIndentedString(this.onlyForCrossBalancePlatform)).append("\n");
        sb.append("    paymentInstrumentType: ").append(this.toIndentedString((Object)this.paymentInstrumentType)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PaymentInstrumentRequirement fromJson(String jsonString) throws JsonProcessingException {
        return (PaymentInstrumentRequirement)JSON.getMapper().readValue(jsonString, PaymentInstrumentRequirement.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        PAYMENTINSTRUMENTREQUIREMENT("paymentInstrumentRequirement");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PaymentInstrumentTypeEnum {
        BANKACCOUNT("BankAccount"),
        CARD("Card");

        private String value;

        private PaymentInstrumentTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PaymentInstrumentTypeEnum fromValue(String value) {
            for (PaymentInstrumentTypeEnum b : PaymentInstrumentTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

