/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"ratepay.installmentAmount", "ratepay.interestRate", "ratepay.lastInstallmentAmount", "ratepay.paymentFirstday", "ratepaydata.deliveryDate", "ratepaydata.dueDate", "ratepaydata.invoiceDate", "ratepaydata.invoiceId"})
public class AdditionalDataRatepay {
    public static final String JSON_PROPERTY_RATEPAY_INSTALLMENT_AMOUNT = "ratepay.installmentAmount";
    private String ratepayInstallmentAmount;
    public static final String JSON_PROPERTY_RATEPAY_INTEREST_RATE = "ratepay.interestRate";
    private String ratepayInterestRate;
    public static final String JSON_PROPERTY_RATEPAY_LAST_INSTALLMENT_AMOUNT = "ratepay.lastInstallmentAmount";
    private String ratepayLastInstallmentAmount;
    public static final String JSON_PROPERTY_RATEPAY_PAYMENT_FIRSTDAY = "ratepay.paymentFirstday";
    private String ratepayPaymentFirstday;
    public static final String JSON_PROPERTY_RATEPAYDATA_DELIVERY_DATE = "ratepaydata.deliveryDate";
    private String ratepaydataDeliveryDate;
    public static final String JSON_PROPERTY_RATEPAYDATA_DUE_DATE = "ratepaydata.dueDate";
    private String ratepaydataDueDate;
    public static final String JSON_PROPERTY_RATEPAYDATA_INVOICE_DATE = "ratepaydata.invoiceDate";
    private String ratepaydataInvoiceDate;
    public static final String JSON_PROPERTY_RATEPAYDATA_INVOICE_ID = "ratepaydata.invoiceId";
    private String ratepaydataInvoiceId;

    public AdditionalDataRatepay ratepayInstallmentAmount(String ratepayInstallmentAmount) {
        this.ratepayInstallmentAmount = ratepayInstallmentAmount;
        return this;
    }

    @ApiModelProperty(value="Amount the customer has to pay each month.")
    @JsonProperty(value="ratepay.installmentAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRatepayInstallmentAmount() {
        return this.ratepayInstallmentAmount;
    }

    @JsonProperty(value="ratepay.installmentAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRatepayInstallmentAmount(String ratepayInstallmentAmount) {
        this.ratepayInstallmentAmount = ratepayInstallmentAmount;
    }

    public AdditionalDataRatepay ratepayInterestRate(String ratepayInterestRate) {
        this.ratepayInterestRate = ratepayInterestRate;
        return this;
    }

    @ApiModelProperty(value="Interest rate of this installment.")
    @JsonProperty(value="ratepay.interestRate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRatepayInterestRate() {
        return this.ratepayInterestRate;
    }

    @JsonProperty(value="ratepay.interestRate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRatepayInterestRate(String ratepayInterestRate) {
        this.ratepayInterestRate = ratepayInterestRate;
    }

    public AdditionalDataRatepay ratepayLastInstallmentAmount(String ratepayLastInstallmentAmount) {
        this.ratepayLastInstallmentAmount = ratepayLastInstallmentAmount;
        return this;
    }

    @ApiModelProperty(value="Amount of the last installment.")
    @JsonProperty(value="ratepay.lastInstallmentAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRatepayLastInstallmentAmount() {
        return this.ratepayLastInstallmentAmount;
    }

    @JsonProperty(value="ratepay.lastInstallmentAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRatepayLastInstallmentAmount(String ratepayLastInstallmentAmount) {
        this.ratepayLastInstallmentAmount = ratepayLastInstallmentAmount;
    }

    public AdditionalDataRatepay ratepayPaymentFirstday(String ratepayPaymentFirstday) {
        this.ratepayPaymentFirstday = ratepayPaymentFirstday;
        return this;
    }

    @ApiModelProperty(value="Calendar day of the first payment.")
    @JsonProperty(value="ratepay.paymentFirstday")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRatepayPaymentFirstday() {
        return this.ratepayPaymentFirstday;
    }

    @JsonProperty(value="ratepay.paymentFirstday")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRatepayPaymentFirstday(String ratepayPaymentFirstday) {
        this.ratepayPaymentFirstday = ratepayPaymentFirstday;
    }

    public AdditionalDataRatepay ratepaydataDeliveryDate(String ratepaydataDeliveryDate) {
        this.ratepaydataDeliveryDate = ratepaydataDeliveryDate;
        return this;
    }

    @ApiModelProperty(value="Date the merchant delivered the goods to the customer.")
    @JsonProperty(value="ratepaydata.deliveryDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRatepaydataDeliveryDate() {
        return this.ratepaydataDeliveryDate;
    }

    @JsonProperty(value="ratepaydata.deliveryDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRatepaydataDeliveryDate(String ratepaydataDeliveryDate) {
        this.ratepaydataDeliveryDate = ratepaydataDeliveryDate;
    }

    public AdditionalDataRatepay ratepaydataDueDate(String ratepaydataDueDate) {
        this.ratepaydataDueDate = ratepaydataDueDate;
        return this;
    }

    @ApiModelProperty(value="Date by which the customer must settle the payment.")
    @JsonProperty(value="ratepaydata.dueDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRatepaydataDueDate() {
        return this.ratepaydataDueDate;
    }

    @JsonProperty(value="ratepaydata.dueDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRatepaydataDueDate(String ratepaydataDueDate) {
        this.ratepaydataDueDate = ratepaydataDueDate;
    }

    public AdditionalDataRatepay ratepaydataInvoiceDate(String ratepaydataInvoiceDate) {
        this.ratepaydataInvoiceDate = ratepaydataInvoiceDate;
        return this;
    }

    @ApiModelProperty(value="Invoice date, defined by the merchant. If not included, the invoice date is set to the delivery date.")
    @JsonProperty(value="ratepaydata.invoiceDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRatepaydataInvoiceDate() {
        return this.ratepaydataInvoiceDate;
    }

    @JsonProperty(value="ratepaydata.invoiceDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRatepaydataInvoiceDate(String ratepaydataInvoiceDate) {
        this.ratepaydataInvoiceDate = ratepaydataInvoiceDate;
    }

    public AdditionalDataRatepay ratepaydataInvoiceId(String ratepaydataInvoiceId) {
        this.ratepaydataInvoiceId = ratepaydataInvoiceId;
        return this;
    }

    @ApiModelProperty(value="Identification name or number for the invoice, defined by the merchant.")
    @JsonProperty(value="ratepaydata.invoiceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRatepaydataInvoiceId() {
        return this.ratepaydataInvoiceId;
    }

    @JsonProperty(value="ratepaydata.invoiceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRatepaydataInvoiceId(String ratepaydataInvoiceId) {
        this.ratepaydataInvoiceId = ratepaydataInvoiceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdditionalDataRatepay additionalDataRatepay = (AdditionalDataRatepay)o;
        return Objects.equals(this.ratepayInstallmentAmount, additionalDataRatepay.ratepayInstallmentAmount) && Objects.equals(this.ratepayInterestRate, additionalDataRatepay.ratepayInterestRate) && Objects.equals(this.ratepayLastInstallmentAmount, additionalDataRatepay.ratepayLastInstallmentAmount) && Objects.equals(this.ratepayPaymentFirstday, additionalDataRatepay.ratepayPaymentFirstday) && Objects.equals(this.ratepaydataDeliveryDate, additionalDataRatepay.ratepaydataDeliveryDate) && Objects.equals(this.ratepaydataDueDate, additionalDataRatepay.ratepaydataDueDate) && Objects.equals(this.ratepaydataInvoiceDate, additionalDataRatepay.ratepaydataInvoiceDate) && Objects.equals(this.ratepaydataInvoiceId, additionalDataRatepay.ratepaydataInvoiceId);
    }

    public int hashCode() {
        return Objects.hash(this.ratepayInstallmentAmount, this.ratepayInterestRate, this.ratepayLastInstallmentAmount, this.ratepayPaymentFirstday, this.ratepaydataDeliveryDate, this.ratepaydataDueDate, this.ratepaydataInvoiceDate, this.ratepaydataInvoiceId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdditionalDataRatepay {\n");
        sb.append("    ratepayInstallmentAmount: ").append(this.toIndentedString(this.ratepayInstallmentAmount)).append("\n");
        sb.append("    ratepayInterestRate: ").append(this.toIndentedString(this.ratepayInterestRate)).append("\n");
        sb.append("    ratepayLastInstallmentAmount: ").append(this.toIndentedString(this.ratepayLastInstallmentAmount)).append("\n");
        sb.append("    ratepayPaymentFirstday: ").append(this.toIndentedString(this.ratepayPaymentFirstday)).append("\n");
        sb.append("    ratepaydataDeliveryDate: ").append(this.toIndentedString(this.ratepaydataDeliveryDate)).append("\n");
        sb.append("    ratepaydataDueDate: ").append(this.toIndentedString(this.ratepaydataDueDate)).append("\n");
        sb.append("    ratepaydataInvoiceDate: ").append(this.toIndentedString(this.ratepaydataInvoiceDate)).append("\n");
        sb.append("    ratepaydataInvoiceId: ").append(this.toIndentedString(this.ratepaydataInvoiceId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static AdditionalDataRatepay fromJson(String jsonString) throws JsonProcessingException {
        return (AdditionalDataRatepay)JSON.getMapper().readValue(jsonString, AdditionalDataRatepay.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

