/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"displayName", "domainName", "merchantIdentifier"})
public class ApplePaySessionRequest {
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private String displayName;
    public static final String JSON_PROPERTY_DOMAIN_NAME = "domainName";
    private String domainName;
    public static final String JSON_PROPERTY_MERCHANT_IDENTIFIER = "merchantIdentifier";
    private String merchantIdentifier;

    public ApplePaySessionRequest displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(required=true, value="This is the name that your shoppers will see in the Apple Pay interface.  The value returned as `configuration.merchantName` field from the [`/paymentMethods`](https://docs.adyen.com/api-explorer/#/CheckoutService/latest/post/paymentMethods) response.")
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ApplePaySessionRequest domainName(String domainName) {
        this.domainName = domainName;
        return this;
    }

    @ApiModelProperty(required=true, value="The domain name you provided when you added Apple Pay in your Customer Area.  This must match the `window.location.hostname` of the web shop.")
    @JsonProperty(value="domainName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDomainName() {
        return this.domainName;
    }

    @JsonProperty(value="domainName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public ApplePaySessionRequest merchantIdentifier(String merchantIdentifier) {
        this.merchantIdentifier = merchantIdentifier;
        return this;
    }

    @ApiModelProperty(required=true, value="Your merchant identifier registered with Apple Pay.  Use the value of the `configuration.merchantId` field from the [`/paymentMethods`](https://docs.adyen.com/api-explorer/#/CheckoutService/latest/post/paymentMethods) response.")
    @JsonProperty(value="merchantIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantIdentifier() {
        return this.merchantIdentifier;
    }

    @JsonProperty(value="merchantIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantIdentifier(String merchantIdentifier) {
        this.merchantIdentifier = merchantIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplePaySessionRequest applePaySessionRequest = (ApplePaySessionRequest)o;
        return Objects.equals(this.displayName, applePaySessionRequest.displayName) && Objects.equals(this.domainName, applePaySessionRequest.domainName) && Objects.equals(this.merchantIdentifier, applePaySessionRequest.merchantIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.displayName, this.domainName, this.merchantIdentifier);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplePaySessionRequest {\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    domainName: ").append(this.toIndentedString(this.domainName)).append("\n");
        sb.append("    merchantIdentifier: ").append(this.toIndentedString(this.merchantIdentifier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static ApplePaySessionRequest fromJson(String jsonString) throws JsonProcessingException {
        return (ApplePaySessionRequest)JSON.getMapper().readValue(jsonString, ApplePaySessionRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

