/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.disputes;

import com.adyen.model.disputes.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"available", "defenseDocumentTypeCode", "requirementLevel"})
public class DefenseDocumentType {
    public static final String JSON_PROPERTY_AVAILABLE = "available";
    private Boolean available;
    public static final String JSON_PROPERTY_DEFENSE_DOCUMENT_TYPE_CODE = "defenseDocumentTypeCode";
    private String defenseDocumentTypeCode;
    public static final String JSON_PROPERTY_REQUIREMENT_LEVEL = "requirementLevel";
    private String requirementLevel;

    public DefenseDocumentType available(Boolean available) {
        this.available = available;
        return this;
    }

    @ApiModelProperty(required=true, value="When **true**, you've successfully uploaded this type of defense document. When **false**, you haven't uploaded this defense document type.")
    @JsonProperty(value="available")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAvailable() {
        return this.available;
    }

    @JsonProperty(value="available")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAvailable(Boolean available) {
        this.available = available;
    }

    public DefenseDocumentType defenseDocumentTypeCode(String defenseDocumentTypeCode) {
        this.defenseDocumentTypeCode = defenseDocumentTypeCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The document type code of the defense document.")
    @JsonProperty(value="defenseDocumentTypeCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDefenseDocumentTypeCode() {
        return this.defenseDocumentTypeCode;
    }

    @JsonProperty(value="defenseDocumentTypeCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDefenseDocumentTypeCode(String defenseDocumentTypeCode) {
        this.defenseDocumentTypeCode = defenseDocumentTypeCode;
    }

    public DefenseDocumentType requirementLevel(String requirementLevel) {
        this.requirementLevel = requirementLevel;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates to what extent the defense document is required in the defense process.  Possible values:   * **Required**: You must supply the document.   * **OneOrMore**: You must supply at least one of the documents with this label.  * **Optional**: You can choose to supply the document.  * **AlternativeRequired**: You must supply a generic defense document. To enable this functionality, contact our Support Team. When enabled, you can supply a generic defense document for all schemes.")
    @JsonProperty(value="requirementLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRequirementLevel() {
        return this.requirementLevel;
    }

    @JsonProperty(value="requirementLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequirementLevel(String requirementLevel) {
        this.requirementLevel = requirementLevel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefenseDocumentType defenseDocumentType = (DefenseDocumentType)o;
        return Objects.equals(this.available, defenseDocumentType.available) && Objects.equals(this.defenseDocumentTypeCode, defenseDocumentType.defenseDocumentTypeCode) && Objects.equals(this.requirementLevel, defenseDocumentType.requirementLevel);
    }

    public int hashCode() {
        return Objects.hash(this.available, this.defenseDocumentTypeCode, this.requirementLevel);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DefenseDocumentType {\n");
        sb.append("    available: ").append(this.toIndentedString(this.available)).append("\n");
        sb.append("    defenseDocumentTypeCode: ").append(this.toIndentedString(this.defenseDocumentTypeCode)).append("\n");
        sb.append("    requirementLevel: ").append(this.toIndentedString(this.requirementLevel)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static DefenseDocumentType fromJson(String jsonString) throws JsonProcessingException {
        return (DefenseDocumentType)JSON.getMapper().readValue(jsonString, DefenseDocumentType.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

