/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"email", "firstName", "infix", "lastName", "phoneNumber"})
public class Contact {
    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;
    public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
    private String firstName;
    public static final String JSON_PROPERTY_INFIX = "infix";
    private String infix;
    public static final String JSON_PROPERTY_LAST_NAME = "lastName";
    private String lastName;
    public static final String JSON_PROPERTY_PHONE_NUMBER = "phoneNumber";
    private String phoneNumber;

    public Contact email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(value="The individual's email address.")
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmail(String email) {
        this.email = email;
    }

    public Contact firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @ApiModelProperty(value="The individual's first name.")
    @JsonProperty(value="firstName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFirstName() {
        return this.firstName;
    }

    @JsonProperty(value="firstName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public Contact infix(String infix) {
        this.infix = infix;
        return this;
    }

    @ApiModelProperty(value="The infix in the individual's name, if any.")
    @JsonProperty(value="infix")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInfix() {
        return this.infix;
    }

    @JsonProperty(value="infix")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInfix(String infix) {
        this.infix = infix;
    }

    public Contact lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @ApiModelProperty(value="The individual's last name.")
    @JsonProperty(value="lastName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLastName() {
        return this.lastName;
    }

    @JsonProperty(value="lastName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public Contact phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @ApiModelProperty(value="The individual's phone number, specified as 10-14 digits with an optional `+` prefix.")
    @JsonProperty(value="phoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonProperty(value="phoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Contact contact = (Contact)o;
        return Objects.equals(this.email, contact.email) && Objects.equals(this.firstName, contact.firstName) && Objects.equals(this.infix, contact.infix) && Objects.equals(this.lastName, contact.lastName) && Objects.equals(this.phoneNumber, contact.phoneNumber);
    }

    public int hashCode() {
        return Objects.hash(this.email, this.firstName, this.infix, this.lastName, this.phoneNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Contact {\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    infix: ").append(this.toIndentedString(this.infix)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Contact fromJson(String jsonString) throws JsonProcessingException {
        return (Contact)JSON.getMapper().readValue(jsonString, Contact.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

