/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.adyen.model.management.Name;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"accountGroups", "associatedMerchantAccounts", "email", "loginMethod", "name", "roles", "timeZoneCode", "username"})
public class CreateCompanyUserRequest {
    public static final String JSON_PROPERTY_ACCOUNT_GROUPS = "accountGroups";
    private List<String> accountGroups = null;
    public static final String JSON_PROPERTY_ASSOCIATED_MERCHANT_ACCOUNTS = "associatedMerchantAccounts";
    private List<String> associatedMerchantAccounts = null;
    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;
    public static final String JSON_PROPERTY_LOGIN_METHOD = "loginMethod";
    private String loginMethod;
    public static final String JSON_PROPERTY_NAME = "name";
    private Name name;
    public static final String JSON_PROPERTY_ROLES = "roles";
    private List<String> roles = null;
    public static final String JSON_PROPERTY_TIME_ZONE_CODE = "timeZoneCode";
    private String timeZoneCode;
    public static final String JSON_PROPERTY_USERNAME = "username";
    private String username;

    public CreateCompanyUserRequest accountGroups(List<String> accountGroups) {
        this.accountGroups = accountGroups;
        return this;
    }

    public CreateCompanyUserRequest addAccountGroupsItem(String accountGroupsItem) {
        if (this.accountGroups == null) {
            this.accountGroups = new ArrayList<String>();
        }
        this.accountGroups.add(accountGroupsItem);
        return this;
    }

    @ApiModelProperty(value="The list of [account groups](https://docs.adyen.com/account/account-structure#account-groups) associated with this user.")
    @JsonProperty(value="accountGroups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAccountGroups() {
        return this.accountGroups;
    }

    @JsonProperty(value="accountGroups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountGroups(List<String> accountGroups) {
        this.accountGroups = accountGroups;
    }

    public CreateCompanyUserRequest associatedMerchantAccounts(List<String> associatedMerchantAccounts) {
        this.associatedMerchantAccounts = associatedMerchantAccounts;
        return this;
    }

    public CreateCompanyUserRequest addAssociatedMerchantAccountsItem(String associatedMerchantAccountsItem) {
        if (this.associatedMerchantAccounts == null) {
            this.associatedMerchantAccounts = new ArrayList<String>();
        }
        this.associatedMerchantAccounts.add(associatedMerchantAccountsItem);
        return this;
    }

    @ApiModelProperty(value="The list of [merchant accounts](https://docs.adyen.com/account/account-structure#merchant-accounts) associated with this user.")
    @JsonProperty(value="associatedMerchantAccounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAssociatedMerchantAccounts() {
        return this.associatedMerchantAccounts;
    }

    @JsonProperty(value="associatedMerchantAccounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAssociatedMerchantAccounts(List<String> associatedMerchantAccounts) {
        this.associatedMerchantAccounts = associatedMerchantAccounts;
    }

    public CreateCompanyUserRequest email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(required=true, value="The email address of the user.")
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmail(String email) {
        this.email = email;
    }

    public CreateCompanyUserRequest loginMethod(String loginMethod) {
        this.loginMethod = loginMethod;
        return this;
    }

    @ApiModelProperty(value="The requested login method for the user. To use SSO, you must already have SSO configured with Adyen before creating the user.  Possible values: **Username & account**, **Email**, or **SSO** ")
    @JsonProperty(value="loginMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLoginMethod() {
        return this.loginMethod;
    }

    @JsonProperty(value="loginMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLoginMethod(String loginMethod) {
        this.loginMethod = loginMethod;
    }

    public CreateCompanyUserRequest name(Name name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Name getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(Name name) {
        this.name = name;
    }

    public CreateCompanyUserRequest roles(List<String> roles) {
        this.roles = roles;
        return this;
    }

    public CreateCompanyUserRequest addRolesItem(String rolesItem) {
        if (this.roles == null) {
            this.roles = new ArrayList<String>();
        }
        this.roles.add(rolesItem);
        return this;
    }

    @ApiModelProperty(value="The list of [roles](https://docs.adyen.com/account/user-roles) for this user.")
    @JsonProperty(value="roles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getRoles() {
        return this.roles;
    }

    @JsonProperty(value="roles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public CreateCompanyUserRequest timeZoneCode(String timeZoneCode) {
        this.timeZoneCode = timeZoneCode;
        return this;
    }

    @ApiModelProperty(value="The [tz database name](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones) of the time zone of the user. For example, **Europe/Amsterdam**.")
    @JsonProperty(value="timeZoneCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTimeZoneCode() {
        return this.timeZoneCode;
    }

    @JsonProperty(value="timeZoneCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTimeZoneCode(String timeZoneCode) {
        this.timeZoneCode = timeZoneCode;
    }

    public CreateCompanyUserRequest username(String username) {
        this.username = username;
        return this;
    }

    @ApiModelProperty(required=true, value="The user's email address that will be their username. Must be the same as the one in the `email` field.")
    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUsername(String username) {
        this.username = username;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateCompanyUserRequest createCompanyUserRequest = (CreateCompanyUserRequest)o;
        return Objects.equals(this.accountGroups, createCompanyUserRequest.accountGroups) && Objects.equals(this.associatedMerchantAccounts, createCompanyUserRequest.associatedMerchantAccounts) && Objects.equals(this.email, createCompanyUserRequest.email) && Objects.equals(this.loginMethod, createCompanyUserRequest.loginMethod) && Objects.equals(this.name, createCompanyUserRequest.name) && Objects.equals(this.roles, createCompanyUserRequest.roles) && Objects.equals(this.timeZoneCode, createCompanyUserRequest.timeZoneCode) && Objects.equals(this.username, createCompanyUserRequest.username);
    }

    public int hashCode() {
        return Objects.hash(this.accountGroups, this.associatedMerchantAccounts, this.email, this.loginMethod, this.name, this.roles, this.timeZoneCode, this.username);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateCompanyUserRequest {\n");
        sb.append("    accountGroups: ").append(this.toIndentedString(this.accountGroups)).append("\n");
        sb.append("    associatedMerchantAccounts: ").append(this.toIndentedString(this.associatedMerchantAccounts)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    loginMethod: ").append(this.toIndentedString(this.loginMethod)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("    timeZoneCode: ").append(this.toIndentedString(this.timeZoneCode)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static CreateCompanyUserRequest fromJson(String jsonString) throws JsonProcessingException {
        return (CreateCompanyUserRequest)JSON.getMapper().readValue(jsonString, CreateCompanyUserRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

