/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"displayMaximumBackLight", "resetTotalsHour", "restartHour"})
public class Hardware {
    public static final String JSON_PROPERTY_DISPLAY_MAXIMUM_BACK_LIGHT = "displayMaximumBackLight";
    private Integer displayMaximumBackLight;
    public static final String JSON_PROPERTY_RESET_TOTALS_HOUR = "resetTotalsHour";
    private Integer resetTotalsHour;
    public static final String JSON_PROPERTY_RESTART_HOUR = "restartHour";
    private Integer restartHour;

    public Hardware displayMaximumBackLight(Integer displayMaximumBackLight) {
        this.displayMaximumBackLight = displayMaximumBackLight;
        return this;
    }

    @ApiModelProperty(value="The brightness of the display when the terminal is being used, expressed as a percentage.")
    @JsonProperty(value="displayMaximumBackLight")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getDisplayMaximumBackLight() {
        return this.displayMaximumBackLight;
    }

    @JsonProperty(value="displayMaximumBackLight")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayMaximumBackLight(Integer displayMaximumBackLight) {
        this.displayMaximumBackLight = displayMaximumBackLight;
    }

    public Hardware resetTotalsHour(Integer resetTotalsHour) {
        this.resetTotalsHour = resetTotalsHour;
        return this;
    }

    @ApiModelProperty(value="The hour of the day when the terminal is set to reset the Totals report. By default, the reset hour is at 6:00 AM in the timezone of the terminal. Minimum value: 0, maximum value: 23.")
    @JsonProperty(value="resetTotalsHour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getResetTotalsHour() {
        return this.resetTotalsHour;
    }

    @JsonProperty(value="resetTotalsHour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResetTotalsHour(Integer resetTotalsHour) {
        this.resetTotalsHour = resetTotalsHour;
    }

    public Hardware restartHour(Integer restartHour) {
        this.restartHour = restartHour;
        return this;
    }

    @ApiModelProperty(value="The hour of the day when the terminal is set to reboot to apply the configuration and software updates. By default, the restart hour is at 6:00 AM in the timezone of the terminal. Minimum value: 0, maximum value: 23.")
    @JsonProperty(value="restartHour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getRestartHour() {
        return this.restartHour;
    }

    @JsonProperty(value="restartHour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRestartHour(Integer restartHour) {
        this.restartHour = restartHour;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Hardware hardware = (Hardware)o;
        return Objects.equals(this.displayMaximumBackLight, hardware.displayMaximumBackLight) && Objects.equals(this.resetTotalsHour, hardware.resetTotalsHour) && Objects.equals(this.restartHour, hardware.restartHour);
    }

    public int hashCode() {
        return Objects.hash(this.displayMaximumBackLight, this.resetTotalsHour, this.restartHour);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Hardware {\n");
        sb.append("    displayMaximumBackLight: ").append(this.toIndentedString(this.displayMaximumBackLight)).append("\n");
        sb.append("    resetTotalsHour: ").append(this.toIndentedString(this.resetTotalsHour)).append("\n");
        sb.append("    restartHour: ").append(this.toIndentedString(this.restartHour)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Hardware fromJson(String jsonString) throws JsonProcessingException {
        return (Hardware)JSON.getMapper().readValue(jsonString, Hardware.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

