/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"active", "allowedOrigins", "description", "roles"})
public class UpdateMerchantApiCredentialRequest {
    public static final String JSON_PROPERTY_ACTIVE = "active";
    private Boolean active;
    public static final String JSON_PROPERTY_ALLOWED_ORIGINS = "allowedOrigins";
    private List<String> allowedOrigins = null;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_ROLES = "roles";
    private List<String> roles = null;

    public UpdateMerchantApiCredentialRequest active(Boolean active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(value="Indicates if the API credential is enabled.")
    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getActive() {
        return this.active;
    }

    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setActive(Boolean active) {
        this.active = active;
    }

    public UpdateMerchantApiCredentialRequest allowedOrigins(List<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
        return this;
    }

    public UpdateMerchantApiCredentialRequest addAllowedOriginsItem(String allowedOriginsItem) {
        if (this.allowedOrigins == null) {
            this.allowedOrigins = new ArrayList<String>();
        }
        this.allowedOrigins.add(allowedOriginsItem);
        return this;
    }

    @ApiModelProperty(value="The new list of [allowed origins](https://docs.adyen.com/development-resources/client-side-authentication#allowed-origins) for the API credential.")
    @JsonProperty(value="allowedOrigins")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    @JsonProperty(value="allowedOrigins")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowedOrigins(List<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
    }

    public UpdateMerchantApiCredentialRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Description of the API credential.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public UpdateMerchantApiCredentialRequest roles(List<String> roles) {
        this.roles = roles;
        return this;
    }

    public UpdateMerchantApiCredentialRequest addRolesItem(String rolesItem) {
        if (this.roles == null) {
            this.roles = new ArrayList<String>();
        }
        this.roles.add(rolesItem);
        return this;
    }

    @ApiModelProperty(value="List of [roles](https://docs.adyen.com/development-resources/api-credentials#roles-1) for the API credential. Only roles assigned to 'ws@Company.<CompanyName>' can be assigned to other API credentials.")
    @JsonProperty(value="roles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getRoles() {
        return this.roles;
    }

    @JsonProperty(value="roles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateMerchantApiCredentialRequest updateMerchantApiCredentialRequest = (UpdateMerchantApiCredentialRequest)o;
        return Objects.equals(this.active, updateMerchantApiCredentialRequest.active) && Objects.equals(this.allowedOrigins, updateMerchantApiCredentialRequest.allowedOrigins) && Objects.equals(this.description, updateMerchantApiCredentialRequest.description) && Objects.equals(this.roles, updateMerchantApiCredentialRequest.roles);
    }

    public int hashCode() {
        return Objects.hash(this.active, this.allowedOrigins, this.description, this.roles);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateMerchantApiCredentialRequest {\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    allowedOrigins: ").append(this.toIndentedString(this.allowedOrigins)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static UpdateMerchantApiCredentialRequest fromJson(String jsonString) throws JsonProcessingException {
        return (UpdateMerchantApiCredentialRequest)JSON.getMapper().readValue(jsonString, UpdateMerchantApiCredentialRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

