/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.managementwebhooks;

import com.adyen.model.managementwebhooks.AccountUpdateNotificationData;
import com.adyen.model.managementwebhooks.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonPropertyOrder(value={"createdAt", "data", "environment", "type"})
public class MerchantUpdatedNotificationRequest {
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_DATA = "data";
    private AccountUpdateNotificationData data;
    public static final String JSON_PROPERTY_ENVIRONMENT = "environment";
    private String environment;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public MerchantUpdatedNotificationRequest createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(required=true, value="Timestamp for when the webhook was created.")
    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public MerchantUpdatedNotificationRequest data(AccountUpdateNotificationData data) {
        this.data = data;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AccountUpdateNotificationData getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setData(AccountUpdateNotificationData data) {
        this.data = data;
    }

    public MerchantUpdatedNotificationRequest environment(String environment) {
        this.environment = environment;
        return this;
    }

    @ApiModelProperty(required=true, value="The environment from which the webhook originated.  Possible values: **test**, **live**.")
    @JsonProperty(value="environment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEnvironment() {
        return this.environment;
    }

    @JsonProperty(value="environment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public MerchantUpdatedNotificationRequest type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="Type of notification.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MerchantUpdatedNotificationRequest merchantUpdatedNotificationRequest = (MerchantUpdatedNotificationRequest)o;
        return Objects.equals(this.createdAt, merchantUpdatedNotificationRequest.createdAt) && Objects.equals(this.data, merchantUpdatedNotificationRequest.data) && Objects.equals(this.environment, merchantUpdatedNotificationRequest.environment) && Objects.equals((Object)this.type, (Object)merchantUpdatedNotificationRequest.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.createdAt, this.data, this.environment, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MerchantUpdatedNotificationRequest {\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString(this.environment)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static MerchantUpdatedNotificationRequest fromJson(String jsonString) throws JsonProcessingException {
        return (MerchantUpdatedNotificationRequest)JSON.getMapper().readValue(jsonString, MerchantUpdatedNotificationRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        MERCHANT_UPDATED("merchant.updated");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

