/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonPropertyOrder(value={"event", "executionDate", "reason"})
public class AccountEvent {
    public static final String JSON_PROPERTY_EVENT = "event";
    private EventEnum event;
    public static final String JSON_PROPERTY_EXECUTION_DATE = "executionDate";
    private OffsetDateTime executionDate;
    public static final String JSON_PROPERTY_REASON = "reason";
    private String reason;

    public AccountEvent event(EventEnum event) {
        this.event = event;
        return this;
    }

    @ApiModelProperty(value="The event. >Permitted values: `InactivateAccount`, `RefundNotPaidOutTransfers`. For more information, refer to [Verification checks](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process).")
    @JsonProperty(value="event")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EventEnum getEvent() {
        return this.event;
    }

    @JsonProperty(value="event")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEvent(EventEnum event) {
        this.event = event;
    }

    public AccountEvent executionDate(OffsetDateTime executionDate) {
        this.executionDate = executionDate;
        return this;
    }

    @ApiModelProperty(value="The date on which the event will take place.")
    @JsonProperty(value="executionDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getExecutionDate() {
        return this.executionDate;
    }

    @JsonProperty(value="executionDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExecutionDate(OffsetDateTime executionDate) {
        this.executionDate = executionDate;
    }

    public AccountEvent reason(String reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(value="The reason why this event has been created.")
    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReason() {
        return this.reason;
    }

    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReason(String reason) {
        this.reason = reason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountEvent accountEvent = (AccountEvent)o;
        return Objects.equals((Object)this.event, (Object)accountEvent.event) && Objects.equals(this.executionDate, accountEvent.executionDate) && Objects.equals(this.reason, accountEvent.reason);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.event, this.executionDate, this.reason});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountEvent {\n");
        sb.append("    event: ").append(this.toIndentedString((Object)this.event)).append("\n");
        sb.append("    executionDate: ").append(this.toIndentedString(this.executionDate)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static AccountEvent fromJson(String jsonString) throws JsonProcessingException {
        return (AccountEvent)JSON.getMapper().readValue(jsonString, AccountEvent.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum EventEnum {
        INACTIVATEACCOUNT("InactivateAccount"),
        REFUNDNOTPAIDOUTTRANSFERS("RefundNotPaidOutTransfers");

        private String value;

        private EventEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EventEnum fromValue(String value) {
            for (EventEnum b : EventEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

