/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonPropertyOrder(value={"nextScheduledPayout", "schedule"})
public class PayoutScheduleResponse {
    public static final String JSON_PROPERTY_NEXT_SCHEDULED_PAYOUT = "nextScheduledPayout";
    private OffsetDateTime nextScheduledPayout;
    public static final String JSON_PROPERTY_SCHEDULE = "schedule";
    private ScheduleEnum schedule;

    public PayoutScheduleResponse nextScheduledPayout(OffsetDateTime nextScheduledPayout) {
        this.nextScheduledPayout = nextScheduledPayout;
        return this;
    }

    @ApiModelProperty(value="The date of the next scheduled payout.")
    @JsonProperty(value="nextScheduledPayout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getNextScheduledPayout() {
        return this.nextScheduledPayout;
    }

    @JsonProperty(value="nextScheduledPayout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNextScheduledPayout(OffsetDateTime nextScheduledPayout) {
        this.nextScheduledPayout = nextScheduledPayout;
    }

    public PayoutScheduleResponse schedule(ScheduleEnum schedule) {
        this.schedule = schedule;
        return this;
    }

    @ApiModelProperty(value="The payout schedule of the account. Permitted values: `DEFAULT`, `DAILY`, `DAILY_US`, `DAILY_EU`, `DAILY_AU`, `DAILY_SG`, `WEEKLY`, `WEEKLY_ON_TUE_FRI_MIDNIGHT`, `BIWEEKLY_ON_1ST_AND_15TH_AT_MIDNIGHT`, `MONTHLY`, `HOLD`.")
    @JsonProperty(value="schedule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ScheduleEnum getSchedule() {
        return this.schedule;
    }

    @JsonProperty(value="schedule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSchedule(ScheduleEnum schedule) {
        this.schedule = schedule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayoutScheduleResponse payoutScheduleResponse = (PayoutScheduleResponse)o;
        return Objects.equals(this.nextScheduledPayout, payoutScheduleResponse.nextScheduledPayout) && Objects.equals((Object)this.schedule, (Object)payoutScheduleResponse.schedule);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.nextScheduledPayout, this.schedule});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayoutScheduleResponse {\n");
        sb.append("    nextScheduledPayout: ").append(this.toIndentedString(this.nextScheduledPayout)).append("\n");
        sb.append("    schedule: ").append(this.toIndentedString((Object)this.schedule)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PayoutScheduleResponse fromJson(String jsonString) throws JsonProcessingException {
        return (PayoutScheduleResponse)JSON.getMapper().readValue(jsonString, PayoutScheduleResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ScheduleEnum {
        DEFAULT("DEFAULT"),
        BIWEEKLY_ON_1ST_AND_15TH_AT_MIDNIGHT("BIWEEKLY_ON_1ST_AND_15TH_AT_MIDNIGHT"),
        DAILY("DAILY"),
        DAILY_AU("DAILY_AU"),
        DAILY_EU("DAILY_EU"),
        DAILY_SG("DAILY_SG"),
        DAILY_US("DAILY_US"),
        HOLD("HOLD"),
        MONTHLY("MONTHLY"),
        WEEKLY("WEEKLY"),
        WEEKLY_MON_TO_FRI_AU("WEEKLY_MON_TO_FRI_AU"),
        WEEKLY_MON_TO_FRI_EU("WEEKLY_MON_TO_FRI_EU"),
        WEEKLY_MON_TO_FRI_US("WEEKLY_MON_TO_FRI_US"),
        WEEKLY_ON_TUE_FRI_MIDNIGHT("WEEKLY_ON_TUE_FRI_MIDNIGHT"),
        WEEKLY_SUN_TO_THU_AU("WEEKLY_SUN_TO_THU_AU"),
        WEEKLY_SUN_TO_THU_US("WEEKLY_SUN_TO_THU_US");

        private String value;

        private ScheduleEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ScheduleEnum fromValue(String value) {
            for (ScheduleEnum b : ScheduleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

