/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayconfiguration;

import com.adyen.model.marketpayconfiguration.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"eventType", "includeMode"})
public class NotificationEventConfiguration {
    public static final String JSON_PROPERTY_EVENT_TYPE = "eventType";
    private EventTypeEnum eventType;
    public static final String JSON_PROPERTY_INCLUDE_MODE = "includeMode";
    private IncludeModeEnum includeMode;

    public NotificationEventConfiguration eventType(EventTypeEnum eventType) {
        this.eventType = eventType;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of event.  Possible values: **ACCOUNT_CLOSED**, **ACCOUNT_CREATED**, **ACCOUNT_FUNDS_BELOW_THRESHOLD**, **ACCOUNT_HOLDER_CREATED**, **ACCOUNT_HOLDER_LIMIT_REACHED**, **ACCOUNT_HOLDER_PAYOUT**, **ACCOUNT_HOLDER_STATUS_CHANGE**, **ACCOUNT_HOLDER_STORE_STATUS_CHANGE**, **ACCOUNT_HOLDER_UPCOMING_DEADLINE**, **ACCOUNT_HOLDER_UPDATED**, **ACCOUNT_HOLDER_VERIFICATION**, **ACCOUNT_UPDATED**, **BENEFICIARY_SETUP**, **COMPENSATE_NEGATIVE_BALANCE**, **DIRECT_DEBIT_INITIATED**, **PAYMENT_FAILURE**, **REFUND_FUNDS_TRANSFER**, **REPORT_AVAILABLE**, **SCHEDULED_REFUNDS**, **TRANSFER_FUNDS**.")
    @JsonProperty(value="eventType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EventTypeEnum getEventType() {
        return this.eventType;
    }

    @JsonProperty(value="eventType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEventType(EventTypeEnum eventType) {
        this.eventType = eventType;
    }

    public NotificationEventConfiguration includeMode(IncludeModeEnum includeMode) {
        this.includeMode = includeMode;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether the specified `eventType` is sent to your webhook endpoint. Possible values: * **INCLUDE**: Send the specified `eventType`. * **EXCLUDE**: Send all event types except the specified `eventType` and other event types with the `includeMode` set to **EXCLUDE**.")
    @JsonProperty(value="includeMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IncludeModeEnum getIncludeMode() {
        return this.includeMode;
    }

    @JsonProperty(value="includeMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeMode(IncludeModeEnum includeMode) {
        this.includeMode = includeMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationEventConfiguration notificationEventConfiguration = (NotificationEventConfiguration)o;
        return Objects.equals((Object)this.eventType, (Object)notificationEventConfiguration.eventType) && Objects.equals((Object)this.includeMode, (Object)notificationEventConfiguration.includeMode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.eventType, this.includeMode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NotificationEventConfiguration {\n");
        sb.append("    eventType: ").append(this.toIndentedString((Object)this.eventType)).append("\n");
        sb.append("    includeMode: ").append(this.toIndentedString((Object)this.includeMode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static NotificationEventConfiguration fromJson(String jsonString) throws JsonProcessingException {
        return (NotificationEventConfiguration)JSON.getMapper().readValue(jsonString, NotificationEventConfiguration.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum IncludeModeEnum {
        EXCLUDE("EXCLUDE"),
        INCLUDE("INCLUDE");

        private String value;

        private IncludeModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static IncludeModeEnum fromValue(String value) {
            for (IncludeModeEnum b : IncludeModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum EventTypeEnum {
        ACCOUNT_CLOSED("ACCOUNT_CLOSED"),
        ACCOUNT_CREATED("ACCOUNT_CREATED"),
        ACCOUNT_FUNDS_BELOW_THRESHOLD("ACCOUNT_FUNDS_BELOW_THRESHOLD"),
        ACCOUNT_HOLDER_CREATED("ACCOUNT_HOLDER_CREATED"),
        ACCOUNT_HOLDER_LIMIT_REACHED("ACCOUNT_HOLDER_LIMIT_REACHED"),
        ACCOUNT_HOLDER_MIGRATED("ACCOUNT_HOLDER_MIGRATED"),
        ACCOUNT_HOLDER_PAYOUT("ACCOUNT_HOLDER_PAYOUT"),
        ACCOUNT_HOLDER_STATUS_CHANGE("ACCOUNT_HOLDER_STATUS_CHANGE"),
        ACCOUNT_HOLDER_STORE_STATUS_CHANGE("ACCOUNT_HOLDER_STORE_STATUS_CHANGE"),
        ACCOUNT_HOLDER_UPCOMING_DEADLINE("ACCOUNT_HOLDER_UPCOMING_DEADLINE"),
        ACCOUNT_HOLDER_UPDATED("ACCOUNT_HOLDER_UPDATED"),
        ACCOUNT_HOLDER_VERIFICATION("ACCOUNT_HOLDER_VERIFICATION"),
        ACCOUNT_UPDATED("ACCOUNT_UPDATED"),
        BENEFICIARY_SETUP("BENEFICIARY_SETUP"),
        COMPENSATE_NEGATIVE_BALANCE("COMPENSATE_NEGATIVE_BALANCE"),
        DIRECT_DEBIT_INITIATED("DIRECT_DEBIT_INITIATED"),
        FUNDS_MIGRATED("FUNDS_MIGRATED"),
        PAYMENT_FAILURE("PAYMENT_FAILURE"),
        PENDING_CREDIT("PENDING_CREDIT"),
        REFUND_FUNDS_TRANSFER("REFUND_FUNDS_TRANSFER"),
        REPORT_AVAILABLE("REPORT_AVAILABLE"),
        SCHEDULED_REFUNDS("SCHEDULED_REFUNDS"),
        SCORE_SIGNAL_TRIGGERED("SCORE_SIGNAL_TRIGGERED"),
        TRANSFER_FUNDS("TRANSFER_FUNDS"),
        TRANSFER_NOT_PAIDOUT_TRANSFERS("TRANSFER_NOT_PAIDOUT_TRANSFERS");

        private String value;

        private EventTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EventTypeEnum fromValue(String value) {
            for (EventTypeEnum b : EventTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

