/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpaywebhooks;

import com.adyen.model.marketpaywebhooks.DirectDebitInitiatedNotificationContent;
import com.adyen.model.marketpaywebhooks.JSON;
import com.adyen.model.marketpaywebhooks.NotificationErrorContainer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonPropertyOrder(value={"content", "error", "eventDate", "eventType", "executingUserKey", "live", "pspReference"})
public class DirectDebitInitiatedNotification {
    public static final String JSON_PROPERTY_CONTENT = "content";
    private DirectDebitInitiatedNotificationContent content;
    public static final String JSON_PROPERTY_ERROR = "error";
    private NotificationErrorContainer error;
    public static final String JSON_PROPERTY_EVENT_DATE = "eventDate";
    private OffsetDateTime eventDate;
    public static final String JSON_PROPERTY_EVENT_TYPE = "eventType";
    private String eventType;
    public static final String JSON_PROPERTY_EXECUTING_USER_KEY = "executingUserKey";
    private String executingUserKey;
    public static final String JSON_PROPERTY_LIVE = "live";
    private Boolean live;
    public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
    private String pspReference;

    public DirectDebitInitiatedNotification content(DirectDebitInitiatedNotificationContent content) {
        this.content = content;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="content")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DirectDebitInitiatedNotificationContent getContent() {
        return this.content;
    }

    @JsonProperty(value="content")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContent(DirectDebitInitiatedNotificationContent content) {
        this.content = content;
    }

    public DirectDebitInitiatedNotification error(NotificationErrorContainer error) {
        this.error = error;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public NotificationErrorContainer getError() {
        return this.error;
    }

    @JsonProperty(value="error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setError(NotificationErrorContainer error) {
        this.error = error;
    }

    public DirectDebitInitiatedNotification eventDate(OffsetDateTime eventDate) {
        this.eventDate = eventDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The date and time when an event has been completed.")
    @JsonProperty(value="eventDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getEventDate() {
        return this.eventDate;
    }

    @JsonProperty(value="eventDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEventDate(OffsetDateTime eventDate) {
        this.eventDate = eventDate;
    }

    public DirectDebitInitiatedNotification eventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    @ApiModelProperty(required=true, value="The event type of the notification.")
    @JsonProperty(value="eventType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEventType() {
        return this.eventType;
    }

    @JsonProperty(value="eventType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public DirectDebitInitiatedNotification executingUserKey(String executingUserKey) {
        this.executingUserKey = executingUserKey;
        return this;
    }

    @ApiModelProperty(required=true, value="The user or process that has triggered the notification.")
    @JsonProperty(value="executingUserKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExecutingUserKey() {
        return this.executingUserKey;
    }

    @JsonProperty(value="executingUserKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExecutingUserKey(String executingUserKey) {
        this.executingUserKey = executingUserKey;
    }

    public DirectDebitInitiatedNotification live(Boolean live) {
        this.live = live;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether the notification originated from the live environment or the test environment. If true, the notification originated from the live environment. If false, the notification originated from the test environment.")
    @JsonProperty(value="live")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getLive() {
        return this.live;
    }

    @JsonProperty(value="live")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLive(Boolean live) {
        this.live = live;
    }

    public DirectDebitInitiatedNotification pspReference(String pspReference) {
        this.pspReference = pspReference;
        return this;
    }

    @ApiModelProperty(required=true, value="The PSP reference of the request from which the notification originates.")
    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPspReference() {
        return this.pspReference;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirectDebitInitiatedNotification directDebitInitiatedNotification = (DirectDebitInitiatedNotification)o;
        return Objects.equals(this.content, directDebitInitiatedNotification.content) && Objects.equals(this.error, directDebitInitiatedNotification.error) && Objects.equals(this.eventDate, directDebitInitiatedNotification.eventDate) && Objects.equals(this.eventType, directDebitInitiatedNotification.eventType) && Objects.equals(this.executingUserKey, directDebitInitiatedNotification.executingUserKey) && Objects.equals(this.live, directDebitInitiatedNotification.live) && Objects.equals(this.pspReference, directDebitInitiatedNotification.pspReference);
    }

    public int hashCode() {
        return Objects.hash(this.content, this.error, this.eventDate, this.eventType, this.executingUserKey, this.live, this.pspReference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DirectDebitInitiatedNotification {\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    eventDate: ").append(this.toIndentedString(this.eventDate)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString(this.eventType)).append("\n");
        sb.append("    executingUserKey: ").append(this.toIndentedString(this.executingUserKey)).append("\n");
        sb.append("    live: ").append(this.toIndentedString(this.live)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static DirectDebitInitiatedNotification fromJson(String jsonString) throws JsonProcessingException {
        return (DirectDebitInitiatedNotification)JSON.getMapper().readValue(jsonString, DirectDebitInitiatedNotification.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

