/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpaywebhooks;

import com.adyen.model.marketpaywebhooks.JSON;
import com.adyen.model.marketpaywebhooks.KYCCheckSummary;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"requiredFields", "status", "summary", "type"})
public class KYCCheckStatusData {
    public static final String JSON_PROPERTY_REQUIRED_FIELDS = "requiredFields";
    private List<String> requiredFields = null;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_SUMMARY = "summary";
    private KYCCheckSummary summary;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public KYCCheckStatusData requiredFields(List<String> requiredFields) {
        this.requiredFields = requiredFields;
        return this;
    }

    public KYCCheckStatusData addRequiredFieldsItem(String requiredFieldsItem) {
        if (this.requiredFields == null) {
            this.requiredFields = new ArrayList<String>();
        }
        this.requiredFields.add(requiredFieldsItem);
        return this;
    }

    @ApiModelProperty(value="A list of the fields required for execution of the check.")
    @JsonProperty(value="requiredFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getRequiredFields() {
        return this.requiredFields;
    }

    @JsonProperty(value="requiredFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequiredFields(List<String> requiredFields) {
        this.requiredFields = requiredFields;
    }

    public KYCCheckStatusData status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="The status of the check.  Possible values: **AWAITING_DATA** , **DATA_PROVIDED**, **FAILED**, **INVALID_DATA**, **PASSED**, **PENDING**, **RETRY_LIMIT_REACHED**.")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public KYCCheckStatusData summary(KYCCheckSummary summary) {
        this.summary = summary;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="summary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public KYCCheckSummary getSummary() {
        return this.summary;
    }

    @JsonProperty(value="summary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSummary(KYCCheckSummary summary) {
        this.summary = summary;
    }

    public KYCCheckStatusData type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of check.  Possible values:   * **BANK_ACCOUNT_VERIFICATION**: Used in v5 and earlier. Replaced by **PAYOUT_METHOD_VERIFICATION** in v6 and later.   * **COMPANY_VERIFICATION**    * **CARD_VERIFICATION**  * **IDENTITY_VERIFICATION**  * **LEGAL_ARRANGEMENT_VERIFICATION**  * **NONPROFIT_VERIFICATION**   * **PASSPORT_VERIFICATION**  * **PAYOUT_METHOD_VERIFICATION**: Used in v6 and later.  * **PCI_VERIFICATION**")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KYCCheckStatusData kyCCheckStatusData = (KYCCheckStatusData)o;
        return Objects.equals(this.requiredFields, kyCCheckStatusData.requiredFields) && Objects.equals((Object)this.status, (Object)kyCCheckStatusData.status) && Objects.equals(this.summary, kyCCheckStatusData.summary) && Objects.equals((Object)this.type, (Object)kyCCheckStatusData.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.requiredFields, this.status, this.summary, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KYCCheckStatusData {\n");
        sb.append("    requiredFields: ").append(this.toIndentedString(this.requiredFields)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    summary: ").append(this.toIndentedString(this.summary)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static KYCCheckStatusData fromJson(String jsonString) throws JsonProcessingException {
        return (KYCCheckStatusData)JSON.getMapper().readValue(jsonString, KYCCheckStatusData.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        BANK_ACCOUNT_VERIFICATION("BANK_ACCOUNT_VERIFICATION"),
        CARD_VERIFICATION("CARD_VERIFICATION"),
        COMPANY_VERIFICATION("COMPANY_VERIFICATION"),
        IDENTITY_VERIFICATION("IDENTITY_VERIFICATION"),
        LEGAL_ARRANGEMENT_VERIFICATION("LEGAL_ARRANGEMENT_VERIFICATION"),
        NONPROFIT_VERIFICATION("NONPROFIT_VERIFICATION"),
        PASSPORT_VERIFICATION("PASSPORT_VERIFICATION"),
        PAYOUT_METHOD_VERIFICATION("PAYOUT_METHOD_VERIFICATION"),
        PCI_VERIFICATION("PCI_VERIFICATION");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StatusEnum {
        AWAITING_DATA("AWAITING_DATA"),
        DATA_PROVIDED("DATA_PROVIDED"),
        FAILED("FAILED"),
        INVALID_DATA("INVALID_DATA"),
        PASSED("PASSED"),
        PENDING("PENDING"),
        PENDING_REVIEW("PENDING_REVIEW"),
        RETRY_LIMIT_REACHED("RETRY_LIMIT_REACHED"),
        UNCHECKED("UNCHECKED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

