/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.posterminalmanagement;

import com.adyen.model.posterminalmanagement.JSON;
import com.adyen.model.posterminalmanagement.MerchantAccount;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"companyAccount", "inventoryTerminals", "merchantAccounts"})
public class GetTerminalsUnderAccountResponse {
    public static final String JSON_PROPERTY_COMPANY_ACCOUNT = "companyAccount";
    private String companyAccount;
    public static final String JSON_PROPERTY_INVENTORY_TERMINALS = "inventoryTerminals";
    private List<String> inventoryTerminals = null;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNTS = "merchantAccounts";
    private List<MerchantAccount> merchantAccounts = null;

    public GetTerminalsUnderAccountResponse companyAccount(String companyAccount) {
        this.companyAccount = companyAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="Your company account.")
    @JsonProperty(value="companyAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCompanyAccount() {
        return this.companyAccount;
    }

    @JsonProperty(value="companyAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCompanyAccount(String companyAccount) {
        this.companyAccount = companyAccount;
    }

    public GetTerminalsUnderAccountResponse inventoryTerminals(List<String> inventoryTerminals) {
        this.inventoryTerminals = inventoryTerminals;
        return this;
    }

    public GetTerminalsUnderAccountResponse addInventoryTerminalsItem(String inventoryTerminalsItem) {
        if (this.inventoryTerminals == null) {
            this.inventoryTerminals = new ArrayList<String>();
        }
        this.inventoryTerminals.add(inventoryTerminalsItem);
        return this;
    }

    @ApiModelProperty(value="Array that returns a list of all terminals that are in the inventory of the company account.")
    @JsonProperty(value="inventoryTerminals")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getInventoryTerminals() {
        return this.inventoryTerminals;
    }

    @JsonProperty(value="inventoryTerminals")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInventoryTerminals(List<String> inventoryTerminals) {
        this.inventoryTerminals = inventoryTerminals;
    }

    public GetTerminalsUnderAccountResponse merchantAccounts(List<MerchantAccount> merchantAccounts) {
        this.merchantAccounts = merchantAccounts;
        return this;
    }

    public GetTerminalsUnderAccountResponse addMerchantAccountsItem(MerchantAccount merchantAccountsItem) {
        if (this.merchantAccounts == null) {
            this.merchantAccounts = new ArrayList<MerchantAccount>();
        }
        this.merchantAccounts.add(merchantAccountsItem);
        return this;
    }

    @ApiModelProperty(value="Array that returns a list of all merchant accounts belonging to the company account.")
    @JsonProperty(value="merchantAccounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<MerchantAccount> getMerchantAccounts() {
        return this.merchantAccounts;
    }

    @JsonProperty(value="merchantAccounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccounts(List<MerchantAccount> merchantAccounts) {
        this.merchantAccounts = merchantAccounts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetTerminalsUnderAccountResponse getTerminalsUnderAccountResponse = (GetTerminalsUnderAccountResponse)o;
        return Objects.equals(this.companyAccount, getTerminalsUnderAccountResponse.companyAccount) && Objects.equals(this.inventoryTerminals, getTerminalsUnderAccountResponse.inventoryTerminals) && Objects.equals(this.merchantAccounts, getTerminalsUnderAccountResponse.merchantAccounts);
    }

    public int hashCode() {
        return Objects.hash(this.companyAccount, this.inventoryTerminals, this.merchantAccounts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetTerminalsUnderAccountResponse {\n");
        sb.append("    companyAccount: ").append(this.toIndentedString(this.companyAccount)).append("\n");
        sb.append("    inventoryTerminals: ").append(this.toIndentedString(this.inventoryTerminals)).append("\n");
        sb.append("    merchantAccounts: ").append(this.toIndentedString(this.merchantAccounts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static GetTerminalsUnderAccountResponse fromJson(String jsonString) throws JsonProcessingException {
        return (GetTerminalsUnderAccountResponse)JSON.getMapper().readValue(jsonString, GetTerminalsUnderAccountResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

