/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.recurring;

import com.adyen.model.recurring.Amount;
import com.adyen.model.recurring.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"amount", "billingDate", "billingSequenceNumber", "displayedReference", "merchantAccount", "recurringDetailReference", "reference", "shopperReference", "storedPaymentMethodId"})
public class NotifyShopperRequest {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_BILLING_DATE = "billingDate";
    private String billingDate;
    public static final String JSON_PROPERTY_BILLING_SEQUENCE_NUMBER = "billingSequenceNumber";
    private String billingSequenceNumber;
    public static final String JSON_PROPERTY_DISPLAYED_REFERENCE = "displayedReference";
    private String displayedReference;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    public static final String JSON_PROPERTY_RECURRING_DETAIL_REFERENCE = "recurringDetailReference";
    private String recurringDetailReference;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_SHOPPER_REFERENCE = "shopperReference";
    private String shopperReference;
    public static final String JSON_PROPERTY_STORED_PAYMENT_METHOD_ID = "storedPaymentMethodId";
    private String storedPaymentMethodId;

    public NotifyShopperRequest amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public NotifyShopperRequest billingDate(String billingDate) {
        this.billingDate = billingDate;
        return this;
    }

    @ApiModelProperty(value="Date on which the subscription amount will be debited from the shopper. In YYYY-MM-DD format")
    @JsonProperty(value="billingDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBillingDate() {
        return this.billingDate;
    }

    @JsonProperty(value="billingDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBillingDate(String billingDate) {
        this.billingDate = billingDate;
    }

    public NotifyShopperRequest billingSequenceNumber(String billingSequenceNumber) {
        this.billingSequenceNumber = billingSequenceNumber;
        return this;
    }

    @ApiModelProperty(value="Sequence of the debit. Depends on Frequency and Billing Attempts Rule.")
    @JsonProperty(value="billingSequenceNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBillingSequenceNumber() {
        return this.billingSequenceNumber;
    }

    @JsonProperty(value="billingSequenceNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBillingSequenceNumber(String billingSequenceNumber) {
        this.billingSequenceNumber = billingSequenceNumber;
    }

    public NotifyShopperRequest displayedReference(String displayedReference) {
        this.displayedReference = displayedReference;
        return this;
    }

    @ApiModelProperty(value="Reference of Pre-debit notification that is displayed to the shopper. Optional field. Maps to reference if missing")
    @JsonProperty(value="displayedReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayedReference() {
        return this.displayedReference;
    }

    @JsonProperty(value="displayedReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayedReference(String displayedReference) {
        this.displayedReference = displayedReference;
    }

    public NotifyShopperRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="The merchant account identifier with which you want to process the transaction.")
    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public NotifyShopperRequest recurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
        return this;
    }

    @ApiModelProperty(value="This is the `recurringDetailReference` returned in the response when you created the token.")
    @JsonProperty(value="recurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRecurringDetailReference() {
        return this.recurringDetailReference;
    }

    @JsonProperty(value="recurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
    }

    public NotifyShopperRequest reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(required=true, value="Pre-debit notification reference sent by the merchant. This is a mandatory field")
    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public NotifyShopperRequest shopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID that uniquely identifies the shopper.  This `shopperReference` must be the same as the `shopperReference` used in the initial payment.")
    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperReference() {
        return this.shopperReference;
    }

    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
    }

    public NotifyShopperRequest storedPaymentMethodId(String storedPaymentMethodId) {
        this.storedPaymentMethodId = storedPaymentMethodId;
        return this;
    }

    @ApiModelProperty(value="This is the `recurringDetailReference` returned in the response when you created the token.")
    @JsonProperty(value="storedPaymentMethodId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStoredPaymentMethodId() {
        return this.storedPaymentMethodId;
    }

    @JsonProperty(value="storedPaymentMethodId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStoredPaymentMethodId(String storedPaymentMethodId) {
        this.storedPaymentMethodId = storedPaymentMethodId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotifyShopperRequest notifyShopperRequest = (NotifyShopperRequest)o;
        return Objects.equals(this.amount, notifyShopperRequest.amount) && Objects.equals(this.billingDate, notifyShopperRequest.billingDate) && Objects.equals(this.billingSequenceNumber, notifyShopperRequest.billingSequenceNumber) && Objects.equals(this.displayedReference, notifyShopperRequest.displayedReference) && Objects.equals(this.merchantAccount, notifyShopperRequest.merchantAccount) && Objects.equals(this.recurringDetailReference, notifyShopperRequest.recurringDetailReference) && Objects.equals(this.reference, notifyShopperRequest.reference) && Objects.equals(this.shopperReference, notifyShopperRequest.shopperReference) && Objects.equals(this.storedPaymentMethodId, notifyShopperRequest.storedPaymentMethodId);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.billingDate, this.billingSequenceNumber, this.displayedReference, this.merchantAccount, this.recurringDetailReference, this.reference, this.shopperReference, this.storedPaymentMethodId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NotifyShopperRequest {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    billingDate: ").append(this.toIndentedString(this.billingDate)).append("\n");
        sb.append("    billingSequenceNumber: ").append(this.toIndentedString(this.billingSequenceNumber)).append("\n");
        sb.append("    displayedReference: ").append(this.toIndentedString(this.displayedReference)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    recurringDetailReference: ").append(this.toIndentedString(this.recurringDetailReference)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    shopperReference: ").append(this.toIndentedString(this.shopperReference)).append("\n");
        sb.append("    storedPaymentMethodId: ").append(this.toIndentedString(this.storedPaymentMethodId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static NotifyShopperRequest fromJson(String jsonString) throws JsonProcessingException {
        return (NotifyShopperRequest)JSON.getMapper().readValue(jsonString, NotifyShopperRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

