/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.storedvalue;

import com.adyen.model.storedvalue.Amount;
import com.adyen.model.storedvalue.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"authCode", "currentBalance", "pspReference", "refusalReason", "resultCode", "thirdPartyRefusalReason"})
public class StoredValueStatusChangeResponse {
    public static final String JSON_PROPERTY_AUTH_CODE = "authCode";
    private String authCode;
    public static final String JSON_PROPERTY_CURRENT_BALANCE = "currentBalance";
    private Amount currentBalance;
    public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
    private String pspReference;
    public static final String JSON_PROPERTY_REFUSAL_REASON = "refusalReason";
    private String refusalReason;
    public static final String JSON_PROPERTY_RESULT_CODE = "resultCode";
    private ResultCodeEnum resultCode;
    public static final String JSON_PROPERTY_THIRD_PARTY_REFUSAL_REASON = "thirdPartyRefusalReason";
    private String thirdPartyRefusalReason;

    public StoredValueStatusChangeResponse authCode(String authCode) {
        this.authCode = authCode;
        return this;
    }

    @ApiModelProperty(value="Authorisation code: * When the payment is authorised, this field holds the authorisation code for the payment. * When the payment is not authorised, this field is empty.")
    @JsonProperty(value="authCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthCode() {
        return this.authCode;
    }

    @JsonProperty(value="authCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    public StoredValueStatusChangeResponse currentBalance(Amount currentBalance) {
        this.currentBalance = currentBalance;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="currentBalance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getCurrentBalance() {
        return this.currentBalance;
    }

    @JsonProperty(value="currentBalance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCurrentBalance(Amount currentBalance) {
        this.currentBalance = currentBalance;
    }

    public StoredValueStatusChangeResponse pspReference(String pspReference) {
        this.pspReference = pspReference;
        return this;
    }

    @ApiModelProperty(value="Adyen's 16-character string reference associated with the transaction/request. This value is globally unique; quote it when communicating with us about this request.")
    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPspReference() {
        return this.pspReference;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public StoredValueStatusChangeResponse refusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
        return this;
    }

    @ApiModelProperty(value="If the transaction is refused or an error occurs, this field holds Adyen's mapped reason for the refusal or a description of the error.  When a transaction fails, the authorisation response includes `resultCode` and `refusalReason` values.")
    @JsonProperty(value="refusalReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRefusalReason() {
        return this.refusalReason;
    }

    @JsonProperty(value="refusalReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
    }

    public StoredValueStatusChangeResponse resultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
        return this;
    }

    @ApiModelProperty(value="The result of the payment. Possible values:  * **Success** \u2013 The operation has been completed successfully.  * **Refused** \u2013 The operation was refused. The reason is given in the `refusalReason` field.  * **Error** \u2013 There was an error when the operation was processed. The reason is given in the `refusalReason` field.  * **NotEnoughBalance** \u2013 The amount on the payment method is lower than the amount given in the request. Only applicable to balance checks.  ")
    @JsonProperty(value="resultCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResultCodeEnum getResultCode() {
        return this.resultCode;
    }

    @JsonProperty(value="resultCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
    }

    public StoredValueStatusChangeResponse thirdPartyRefusalReason(String thirdPartyRefusalReason) {
        this.thirdPartyRefusalReason = thirdPartyRefusalReason;
        return this;
    }

    @ApiModelProperty(value="Raw refusal reason received from the third party, where available")
    @JsonProperty(value="thirdPartyRefusalReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getThirdPartyRefusalReason() {
        return this.thirdPartyRefusalReason;
    }

    @JsonProperty(value="thirdPartyRefusalReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThirdPartyRefusalReason(String thirdPartyRefusalReason) {
        this.thirdPartyRefusalReason = thirdPartyRefusalReason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoredValueStatusChangeResponse storedValueStatusChangeResponse = (StoredValueStatusChangeResponse)o;
        return Objects.equals(this.authCode, storedValueStatusChangeResponse.authCode) && Objects.equals(this.currentBalance, storedValueStatusChangeResponse.currentBalance) && Objects.equals(this.pspReference, storedValueStatusChangeResponse.pspReference) && Objects.equals(this.refusalReason, storedValueStatusChangeResponse.refusalReason) && Objects.equals((Object)this.resultCode, (Object)storedValueStatusChangeResponse.resultCode) && Objects.equals(this.thirdPartyRefusalReason, storedValueStatusChangeResponse.thirdPartyRefusalReason);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authCode, this.currentBalance, this.pspReference, this.refusalReason, this.resultCode, this.thirdPartyRefusalReason});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StoredValueStatusChangeResponse {\n");
        sb.append("    authCode: ").append(this.toIndentedString(this.authCode)).append("\n");
        sb.append("    currentBalance: ").append(this.toIndentedString(this.currentBalance)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    refusalReason: ").append(this.toIndentedString(this.refusalReason)).append("\n");
        sb.append("    resultCode: ").append(this.toIndentedString((Object)this.resultCode)).append("\n");
        sb.append("    thirdPartyRefusalReason: ").append(this.toIndentedString(this.thirdPartyRefusalReason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static StoredValueStatusChangeResponse fromJson(String jsonString) throws JsonProcessingException {
        return (StoredValueStatusChangeResponse)JSON.getMapper().readValue(jsonString, StoredValueStatusChangeResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ResultCodeEnum {
        SUCCESS("Success"),
        REFUSED("Refused"),
        ERROR("Error"),
        NOTENOUGHBALANCE("NotEnoughBalance");

        private String value;

        private ResultCodeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ResultCodeEnum fromValue(String value) {
            for (ResultCodeEnum b : ResultCodeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

