/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transactionwebhooks;

import com.adyen.model.transactionwebhooks.JSON;
import com.adyen.model.transactionwebhooks.Transaction;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonPropertyOrder(value={"data", "environment", "timestamp", "type"})
public class TransactionNotificationRequestV4 {
    public static final String JSON_PROPERTY_DATA = "data";
    private Transaction data;
    public static final String JSON_PROPERTY_ENVIRONMENT = "environment";
    private String environment;
    public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
    private OffsetDateTime timestamp;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public TransactionNotificationRequestV4 data(Transaction data) {
        this.data = data;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Transaction getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setData(Transaction data) {
        this.data = data;
    }

    public TransactionNotificationRequestV4 environment(String environment) {
        this.environment = environment;
        return this;
    }

    @ApiModelProperty(required=true, value="The environment from which the webhook originated.  Possible values: **test**, **live**.")
    @JsonProperty(value="environment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEnvironment() {
        return this.environment;
    }

    @JsonProperty(value="environment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public TransactionNotificationRequestV4 timestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @ApiModelProperty(value="When the event was queued.")
    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public TransactionNotificationRequestV4 type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="Type of the webhook.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionNotificationRequestV4 transactionNotificationRequestV4 = (TransactionNotificationRequestV4)o;
        return Objects.equals(this.data, transactionNotificationRequestV4.data) && Objects.equals(this.environment, transactionNotificationRequestV4.environment) && Objects.equals(this.timestamp, transactionNotificationRequestV4.timestamp) && Objects.equals((Object)this.type, (Object)transactionNotificationRequestV4.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.data, this.environment, this.timestamp, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionNotificationRequestV4 {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString(this.environment)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static TransactionNotificationRequestV4 fromJson(String jsonString) throws JsonProcessingException {
        return (TransactionNotificationRequestV4)JSON.getMapper().readValue(jsonString, TransactionNotificationRequestV4.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        BALANCEPLATFORM_TRANSACTION_CREATED("balancePlatform.transaction.created");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

