/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transferwebhooks;

import com.adyen.model.transferwebhooks.Amount;
import com.adyen.model.transferwebhooks.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"amount", "amountAdjustmentType", "basepoints"})
public class AmountAdjustment {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_AMOUNT_ADJUSTMENT_TYPE = "amountAdjustmentType";
    private AmountAdjustmentTypeEnum amountAdjustmentType;
    public static final String JSON_PROPERTY_BASEPOINTS = "basepoints";
    private Integer basepoints;

    public AmountAdjustment amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public AmountAdjustment amountAdjustmentType(AmountAdjustmentTypeEnum amountAdjustmentType) {
        this.amountAdjustmentType = amountAdjustmentType;
        return this;
    }

    @ApiModelProperty(value="The type of markup that is applied to an authorised payment.  Possible values: **exchange**, **forexMarkup**, **authHoldReserve**, **atmMarkup**.")
    @JsonProperty(value="amountAdjustmentType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AmountAdjustmentTypeEnum getAmountAdjustmentType() {
        return this.amountAdjustmentType;
    }

    @JsonProperty(value="amountAdjustmentType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmountAdjustmentType(AmountAdjustmentTypeEnum amountAdjustmentType) {
        this.amountAdjustmentType = amountAdjustmentType;
    }

    public AmountAdjustment basepoints(Integer basepoints) {
        this.basepoints = basepoints;
        return this;
    }

    @ApiModelProperty(value="The basepoints associated with the applied markup.")
    @JsonProperty(value="basepoints")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getBasepoints() {
        return this.basepoints;
    }

    @JsonProperty(value="basepoints")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBasepoints(Integer basepoints) {
        this.basepoints = basepoints;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AmountAdjustment amountAdjustment = (AmountAdjustment)o;
        return Objects.equals(this.amount, amountAdjustment.amount) && Objects.equals((Object)this.amountAdjustmentType, (Object)amountAdjustment.amountAdjustmentType) && Objects.equals(this.basepoints, amountAdjustment.basepoints);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.amountAdjustmentType, this.basepoints});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AmountAdjustment {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    amountAdjustmentType: ").append(this.toIndentedString((Object)this.amountAdjustmentType)).append("\n");
        sb.append("    basepoints: ").append(this.toIndentedString(this.basepoints)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static AmountAdjustment fromJson(String jsonString) throws JsonProcessingException {
        return (AmountAdjustment)JSON.getMapper().readValue(jsonString, AmountAdjustment.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum AmountAdjustmentTypeEnum {
        ATMMARKUP("atmMarkup"),
        AUTHHOLDRESERVE("authHoldReserve"),
        EXCHANGE("exchange"),
        FOREXMARKUP("forexMarkup");

        private String value;

        private AmountAdjustmentTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AmountAdjustmentTypeEnum fromValue(String value) {
            for (AmountAdjustmentTypeEnum b : AmountAdjustmentTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

