/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.balanceplatform;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.balanceplatform.PaginatedGetCardOrderItemResponse;
import com.adyen.model.balanceplatform.PaginatedGetCardOrderResponse;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashMap;

public class CardOrdersApi
extends Service {
    public static final String API_VERSION = "2";
    protected String baseURL;

    public CardOrdersApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://balanceplatform-api-test.adyen.com/bcl/v2");
    }

    public CardOrdersApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public PaginatedGetCardOrderItemResponse getCardOrderItems(String id) throws ApiException, IOException {
        return this.getCardOrderItems(id, null, null, null);
    }

    public PaginatedGetCardOrderItemResponse getCardOrderItems(String id, Integer offset, Integer limit, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (offset != null) {
            queryParams.put("offset", offset.toString());
        }
        if (limit != null) {
            queryParams.put("limit", limit.toString());
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/cardorders/{id}/items", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return PaginatedGetCardOrderItemResponse.fromJson(jsonResult);
    }

    public PaginatedGetCardOrderResponse listCardOrders() throws ApiException, IOException {
        return this.listCardOrders(null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public PaginatedGetCardOrderResponse listCardOrders(String id, String cardManufacturingProfileId, String status, String txVariantCode, OffsetDateTime createdSince, OffsetDateTime createdUntil, OffsetDateTime lockedSince, OffsetDateTime lockedUntil, String serviceCenter, Integer offset, Integer limit, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (id != null) {
            queryParams.put("id", id);
        }
        if (cardManufacturingProfileId != null) {
            queryParams.put("cardManufacturingProfileId", cardManufacturingProfileId);
        }
        if (status != null) {
            queryParams.put("status", status);
        }
        if (txVariantCode != null) {
            queryParams.put("txVariantCode", txVariantCode);
        }
        if (createdSince != null) {
            queryParams.put("createdSince", createdSince.toString());
        }
        if (createdUntil != null) {
            queryParams.put("createdUntil", createdUntil.toString());
        }
        if (lockedSince != null) {
            queryParams.put("lockedSince", lockedSince.toString());
        }
        if (lockedUntil != null) {
            queryParams.put("lockedUntil", lockedUntil.toString());
        }
        if (serviceCenter != null) {
            queryParams.put("serviceCenter", serviceCenter);
        }
        if (offset != null) {
            queryParams.put("offset", offset.toString());
        }
        if (limit != null) {
            queryParams.put("limit", limit.toString());
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/cardorders", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, null, queryParams);
        return PaginatedGetCardOrderResponse.fromJson(jsonResult);
    }
}

