/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.balanceplatform;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.balanceplatform.PaymentInstrumentGroup;
import com.adyen.model.balanceplatform.PaymentInstrumentGroupInfo;
import com.adyen.model.balanceplatform.TransactionRulesResponse;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class PaymentInstrumentGroupsApi
extends Service {
    public static final String API_VERSION = "2";
    protected String baseURL;

    public PaymentInstrumentGroupsApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://balanceplatform-api-test.adyen.com/bcl/v2");
    }

    public PaymentInstrumentGroupsApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public PaymentInstrumentGroup createPaymentInstrumentGroup(PaymentInstrumentGroupInfo paymentInstrumentGroupInfo) throws ApiException, IOException {
        return this.createPaymentInstrumentGroup(paymentInstrumentGroupInfo, null);
    }

    public PaymentInstrumentGroup createPaymentInstrumentGroup(PaymentInstrumentGroupInfo paymentInstrumentGroupInfo, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = paymentInstrumentGroupInfo.toJson();
        Resource resource = new Resource(this, this.baseURL + "/paymentInstrumentGroups", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return PaymentInstrumentGroup.fromJson(jsonResult);
    }

    public TransactionRulesResponse getAllTransactionRulesForPaymentInstrumentGroup(String id) throws ApiException, IOException {
        return this.getAllTransactionRulesForPaymentInstrumentGroup(id, null);
    }

    public TransactionRulesResponse getAllTransactionRulesForPaymentInstrumentGroup(String id, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/paymentInstrumentGroups/{id}/transactionRules", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return TransactionRulesResponse.fromJson(jsonResult);
    }

    public PaymentInstrumentGroup getPaymentInstrumentGroup(String id) throws ApiException, IOException {
        return this.getPaymentInstrumentGroup(id, null);
    }

    public PaymentInstrumentGroup getPaymentInstrumentGroup(String id, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/paymentInstrumentGroups/{id}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return PaymentInstrumentGroup.fromJson(jsonResult);
    }
}

