/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.client;

import com.alibaba.hbase.client.ThriftUtilities;
import com.alibaba.hbase.thrift2.generated.TColumnFamilyDescriptor;
import com.alibaba.hbase.thrift2.generated.THBaseService;
import com.alibaba.hbase.thrift2.generated.TNamespaceDescriptor;
import com.alibaba.hbase.thrift2.generated.TTableDescriptor;
import com.alibaba.hbase.thrift2.generated.TTableName;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.ProcedureInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hadoop.hbase.quotas.QuotaRetriever;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.security.SecurityCapability;
import org.apache.hadoop.hbase.snapshot.HBaseSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.snapshot.UnknownSnapshotException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransport;

public class ThriftAdmin
implements Admin {
    private THBaseService.Client client;
    private TTransport transport;
    private int operationTimeout;
    private Configuration conf;

    public ThriftAdmin(THBaseService.Client client, TTransport tTransport, Configuration conf) {
        this.client = client;
        this.transport = tTransport;
        this.operationTimeout = conf.getInt("hbase.client.operation.timeout", 1200000);
        this.conf = conf;
    }

    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    public void abort(String why, Throwable e) {
    }

    public boolean isAborted() {
        return false;
    }

    public void close() throws IOException {
        this.transport.close();
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public boolean tableExists(TableName tableName) throws IOException {
        TTableName tTableName = ThriftUtilities.tableNameFromHBase(tableName);
        try {
            return this.client.tableExists(tTableName);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public Connection getConnection() {
        throw new UnsupportedOperationException("getConnection not supported in ThriftAdmin");
    }

    public HTableDescriptor[] listTables() throws IOException {
        return this.listTables((String)null);
    }

    public HTableDescriptor[] listTables(Pattern pattern) throws IOException {
        String regex = pattern == null ? null : pattern.toString();
        return this.listTables(regex);
    }

    public HTableDescriptor[] listTables(String regex) throws IOException {
        return this.listTables(regex, false);
    }

    public HTableDescriptor[] listTables(Pattern pattern, boolean includeSysTables) throws IOException {
        String regex = pattern == null ? null : pattern.toString();
        return this.listTables(regex, includeSysTables);
    }

    public HTableDescriptor[] listTables(String regex, boolean includeSysTables) throws IOException {
        try {
            List<TTableDescriptor> tTableDescriptors = this.client.getTableDescriptorsByPattern(regex, includeSysTables);
            return ThriftUtilities.hTableDescriptorsFromThrift(tTableDescriptors);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public TableName[] listTableNames() throws IOException {
        return this.listTableNames((String)null);
    }

    public TableName[] listTableNames(Pattern pattern) throws IOException {
        return this.listTableNames(pattern, false);
    }

    public TableName[] listTableNames(String regex) throws IOException {
        return this.listTableNames(regex, false);
    }

    public TableName[] listTableNames(Pattern pattern, boolean includeSysTables) throws IOException {
        String regex = pattern == null ? null : pattern.toString();
        return this.listTableNames(regex, includeSysTables);
    }

    public TableName[] listTableNames(String regex, boolean includeSysTables) throws IOException {
        try {
            List<TTableName> tTableNames = this.client.getTableNamesByPattern(regex, includeSysTables);
            return ThriftUtilities.tableNamesArrayFromThrift(tTableNames);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public HTableDescriptor getTableDescriptor(TableName tableName) throws TableNotFoundException, IOException {
        TTableName tTableName = ThriftUtilities.tableNameFromHBase(tableName);
        try {
            TTableDescriptor tTableDescriptor = this.client.getTableDescriptor(tTableName);
            return ThriftUtilities.tableDescriptorFromThrift(tTableDescriptor);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public HTableDescriptor[] listTableDescriptorsByNamespace(String name) throws IOException {
        try {
            List<TTableDescriptor> tTableDescriptors = this.client.getTableDescriptorsByNamespace(name);
            return ThriftUtilities.hTableDescriptorsFromThrift(tTableDescriptors);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public TableName[] listTableNamesByNamespace(String name) throws IOException {
        try {
            List<TTableName> tTableNames = this.client.getTableNamesByNamespace(name);
            return ThriftUtilities.tableNamesArrayFromThrift(tTableNames);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public void createTable(HTableDescriptor desc) throws IOException {
        this.createTable(desc, null);
    }

    public void createTable(HTableDescriptor desc, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        if (numRegions < 3) {
            throw new IllegalArgumentException("Must create at least three regions");
        }
        if (Bytes.compareTo((byte[])startKey, (byte[])endKey) >= 0) {
            throw new IllegalArgumentException("Start key must be smaller than end key");
        }
        if (numRegions == 3) {
            this.createTable(desc, new byte[][]{startKey, endKey});
            return;
        }
        byte[][] splitKeys = Bytes.split((byte[])startKey, (byte[])endKey, (int)(numRegions - 3));
        if (splitKeys == null || splitKeys.length != numRegions - 1) {
            throw new IllegalArgumentException("Unable to split key range into enough regions");
        }
        this.createTable(desc, splitKeys);
    }

    public void createTable(HTableDescriptor desc, byte[][] splitKeys) throws IOException {
        TTableDescriptor tTableDescriptor = ThriftUtilities.tableDescriptorFromHBase(desc);
        List<ByteBuffer> splitKeyInBuffer = ThriftUtilities.splitKeyFromHBase(splitKeys);
        try {
            this.client.createTable(tTableDescriptor, splitKeyInBuffer);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public void deleteTable(TableName tableName) throws IOException {
        TTableName tTableName = ThriftUtilities.tableNameFromHBase(tableName);
        try {
            this.client.deleteTable(tTableName);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public void truncateTable(TableName tableName, boolean preserveSplits) throws IOException {
        TTableName tTableName = ThriftUtilities.tableNameFromHBase(tableName);
        try {
            this.client.truncateTable(tTableName, preserveSplits);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public void enableTable(TableName tableName) throws IOException {
        TTableName tTableName = ThriftUtilities.tableNameFromHBase(tableName);
        try {
            this.client.enableTable(tTableName);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public void disableTable(TableName tableName) throws IOException {
        TTableName tTableName = ThriftUtilities.tableNameFromHBase(tableName);
        try {
            this.client.disableTable(tTableName);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public boolean isTableEnabled(TableName tableName) throws IOException {
        TTableName tTableName = ThriftUtilities.tableNameFromHBase(tableName);
        try {
            return this.client.isTableEnabled(tTableName);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public boolean isTableDisabled(TableName tableName) throws IOException {
        TTableName tTableName = ThriftUtilities.tableNameFromHBase(tableName);
        try {
            return this.client.isTableDisabled(tTableName);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public boolean isTableAvailable(TableName tableName) throws IOException {
        TTableName tTableName = ThriftUtilities.tableNameFromHBase(tableName);
        try {
            return this.client.isTableAvailable(tTableName);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public boolean isTableAvailable(TableName tableName, byte[][] splitKeys) throws IOException {
        TTableName tTableName = ThriftUtilities.tableNameFromHBase(tableName);
        List<ByteBuffer> splitKeyInBuffer = ThriftUtilities.splitKeyFromHBase(splitKeys);
        try {
            return this.client.isTableAvailableWithSplit(tTableName, splitKeyInBuffer);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public void addColumn(TableName tableName, HColumnDescriptor columnFamily) throws IOException {
        TTableName tTableName = ThriftUtilities.tableNameFromHBase(tableName);
        TColumnFamilyDescriptor tColumnFamilyDescriptor = ThriftUtilities.columnFamilyDescriptorFromHBase(columnFamily);
        try {
            this.client.addColumnFamily(tTableName, tColumnFamilyDescriptor);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public void deleteColumn(TableName tableName, byte[] columnFamily) throws IOException {
        this.deleteColumnFamily(tableName, columnFamily);
    }

    public void deleteColumnFamily(TableName tableName, byte[] columnFamily) throws IOException {
        TTableName tTableName = ThriftUtilities.tableNameFromHBase(tableName);
        try {
            this.client.deleteColumnFamily(tTableName, ByteBuffer.wrap(columnFamily));
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public void modifyColumn(TableName tableName, HColumnDescriptor columnFamily) throws IOException {
        TTableName tTableName = ThriftUtilities.tableNameFromHBase(tableName);
        TColumnFamilyDescriptor tColumnFamilyDescriptor = ThriftUtilities.columnFamilyDescriptorFromHBase(columnFamily);
        try {
            this.client.modifyColumnFamily(tTableName, tColumnFamilyDescriptor);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public void modifyTable(TableName tableName, HTableDescriptor td) throws IOException {
        this.modifyTable(td);
    }

    public void modifyTable(HTableDescriptor td) throws IOException {
        TTableDescriptor tTableDescriptor = ThriftUtilities.tableDescriptorFromHBase(td);
        try {
            this.client.modifyTable(tTableDescriptor);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public void modifyNamespace(NamespaceDescriptor descriptor) throws IOException {
        TNamespaceDescriptor tNamespaceDescriptor = ThriftUtilities.namespaceDescriptorFromHBase(descriptor);
        try {
            this.client.modifyNamespace(tNamespaceDescriptor);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public void deleteNamespace(String name) throws IOException {
        try {
            this.client.deleteNamespace(name);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public NamespaceDescriptor getNamespaceDescriptor(String name) throws NamespaceNotFoundException, IOException {
        try {
            TNamespaceDescriptor tNamespaceDescriptor = this.client.getNamespaceDescriptor(name);
            return ThriftUtilities.namespaceDescriptorFromThrift(tNamespaceDescriptor);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public NamespaceDescriptor[] listNamespaceDescriptors() throws IOException {
        try {
            List<TNamespaceDescriptor> tNamespaceDescriptors = this.client.listNamespaceDescriptors();
            return ThriftUtilities.namespaceDescriptorsFromThrift(tNamespaceDescriptors);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public void createNamespace(NamespaceDescriptor descriptor) throws IOException {
        TNamespaceDescriptor tNamespaceDescriptor = ThriftUtilities.namespaceDescriptorFromHBase(descriptor);
        try {
            this.client.createNamespace(tNamespaceDescriptor);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public boolean switchRpcThrottle(boolean enable) throws IOException {
        throw new UnsupportedOperationException("switchRpcThrottle by pattern not supported in ThriftAdmin");
    }

    public boolean isRpcThrottleEnabled() throws IOException {
        throw new UnsupportedOperationException("isRpcThrottleEnabled by pattern not supported in ThriftAdmin");
    }

    public boolean exceedThrottleQuotaSwitch(boolean enable) throws IOException {
        throw new UnsupportedOperationException("exceedThrottleQuotaSwitch by pattern not supported in ThriftAdmin");
    }

    public HTableDescriptor[] disableTables(String regex) throws IOException {
        throw new UnsupportedOperationException("disableTables by pattern not supported in ThriftAdmin");
    }

    public HTableDescriptor[] disableTables(Pattern pattern) throws IOException {
        throw new UnsupportedOperationException("disableTables by pattern not supported in ThriftAdmin");
    }

    public HTableDescriptor[] enableTables(String regex) throws IOException {
        throw new UnsupportedOperationException("enableTables by pattern not supported in ThriftAdmin");
    }

    public HTableDescriptor[] enableTables(Pattern pattern) throws IOException {
        throw new UnsupportedOperationException("enableTables by pattern not supported in ThriftAdmin");
    }

    public HTableDescriptor[] deleteTables(String regex) throws IOException {
        throw new UnsupportedOperationException("deleteTables by pattern not supported in ThriftAdmin");
    }

    public HTableDescriptor[] deleteTables(Pattern pattern) throws IOException {
        throw new UnsupportedOperationException("deleteTables by pattern not supported in ThriftAdmin");
    }

    public HTableDescriptor[] getTableDescriptorsByTableName(List<TableName> tableNames) throws IOException {
        throw new UnsupportedOperationException("getTableDescriptorsByTableName not supported in ThriftAdmin, use getDescriptor to get descriptors one by one");
    }

    public List<HTableDescriptor> listTableDescriptors(List<TableName> tableNames) throws IOException {
        throw new UnsupportedOperationException("listTableDescriptors not supported in ThriftAdmin, use getDescriptor to get descriptors one by one");
    }

    public HTableDescriptor[] getTableDescriptors(List<String> names) throws IOException {
        throw new UnsupportedOperationException("getTableDescriptors not supported in ThriftAdmin, use getDescriptor to get descriptors one by one");
    }

    public void closeRegion(String regionname, String serverName) {
        throw new UnsupportedOperationException("closeRegion not supported in ThriftAdmin");
    }

    public void closeRegion(byte[] regionname, String serverName) {
        throw new UnsupportedOperationException("closeRegion not supported in ThriftAdmin");
    }

    public boolean closeRegionWithEncodedRegionName(String encodedRegionName, String serverName) {
        throw new UnsupportedOperationException("closeRegionWithEncodedRegionName not supported in ThriftAdmin");
    }

    public void closeRegion(ServerName sn, HRegionInfo hri) {
        throw new UnsupportedOperationException("closeRegion not supported in ThriftAdmin");
    }

    public List<HRegionInfo> getOnlineRegions(ServerName sn) {
        throw new UnsupportedOperationException("getOnlineRegions not supported in ThriftAdmin");
    }

    public List<HRegionInfo> getRegions(ServerName serverName) {
        throw new UnsupportedOperationException("getRegions not supported in ThriftAdmin");
    }

    public void flush(TableName tableName) {
        throw new UnsupportedOperationException("flush not supported in ThriftAdmin");
    }

    public void flushRegion(byte[] regionName) {
        throw new UnsupportedOperationException("flushRegion not supported in ThriftAdmin");
    }

    public void compact(TableName tableName) {
        throw new UnsupportedOperationException("compact not supported in ThriftAdmin");
    }

    public void compactRegion(byte[] regionName) {
        throw new UnsupportedOperationException("compactRegion not supported in ThriftAdmin");
    }

    public void compact(TableName tableName, byte[] columnFamily) {
        throw new UnsupportedOperationException("compact not supported in ThriftAdmin");
    }

    public void compactRegion(byte[] regionName, byte[] columnFamily) {
        throw new UnsupportedOperationException("compactRegion not supported in ThriftAdmin");
    }

    public void majorCompact(TableName tableName) {
        throw new UnsupportedOperationException("majorCompact not supported in ThriftAdmin");
    }

    public void majorCompactRegion(byte[] regionName) {
        throw new UnsupportedOperationException("majorCompactRegion not supported in ThriftAdmin");
    }

    public void majorCompact(TableName tableName, byte[] columnFamily) {
        throw new UnsupportedOperationException("majorCompact not supported in ThriftAdmin");
    }

    public void majorCompactRegion(byte[] regionName, byte[] columnFamily) {
        throw new UnsupportedOperationException("majorCompactRegion not supported in ThriftAdmin");
    }

    public Map<ServerName, Boolean> compactionSwitch(boolean switchState, List<String> serverNamesList) {
        throw new UnsupportedOperationException("compactionSwitch not supported in ThriftAdmin");
    }

    public void move(byte[] encodedRegionName) {
        throw new UnsupportedOperationException("move not supported in ThriftAdmin");
    }

    public void move(byte[] encodedRegionName, ServerName destServerName) {
        throw new UnsupportedOperationException("move not supported in ThriftAdmin");
    }

    public void assign(byte[] regionName) {
        throw new UnsupportedOperationException("assign not supported in ThriftAdmin");
    }

    public void unassign(byte[] regionName, boolean force) {
        throw new UnsupportedOperationException("unassign not supported in ThriftAdmin");
    }

    public void offline(byte[] regionName) {
        throw new UnsupportedOperationException("offline not supported in ThriftAdmin");
    }

    public boolean isBalancerEnabled() {
        throw new UnsupportedOperationException("isBalancerEnabled not supported in ThriftAdmin");
    }

    public boolean normalize() {
        throw new UnsupportedOperationException("normalize not supported in ThriftAdmin");
    }

    public boolean isNormalizerEnabled() {
        throw new UnsupportedOperationException("isNormalizerEnabled not supported in ThriftAdmin");
    }

    public boolean isCatalogJanitorEnabled() {
        throw new UnsupportedOperationException("isCatalogJanitorEnabled not supported in ThriftAdmin");
    }

    public boolean runCleanerChore() {
        throw new UnsupportedOperationException("runCleanerChore not supported in ThriftAdmin");
    }

    public boolean isCleanerChoreEnabled() {
        throw new UnsupportedOperationException("isCleanerChoreEnabled not supported in ThriftAdmin");
    }

    public void mergeRegions(byte[] nameOfRegionA, byte[] nameOfRegionB, boolean forcible) {
        throw new UnsupportedOperationException("mergeRegions not supported in ThriftAdmin");
    }

    public void split(TableName tableName) {
        throw new UnsupportedOperationException("split not supported in ThriftAdmin");
    }

    public void splitRegion(byte[] regionName) {
        throw new UnsupportedOperationException("splitRegion not supported in ThriftAdmin");
    }

    public void split(TableName tableName, byte[] splitPoint) {
        throw new UnsupportedOperationException("split not supported in ThriftAdmin");
    }

    public void splitRegion(byte[] regionName, byte[] splitPoint) {
        throw new UnsupportedOperationException("splitRegion not supported in ThriftAdmin");
    }

    public void shutdown() {
        throw new UnsupportedOperationException("shutdown not supported in ThriftAdmin");
    }

    public void stopMaster() {
        throw new UnsupportedOperationException("stopMaster not supported in ThriftAdmin");
    }

    public boolean isMasterInMaintenanceMode() {
        throw new UnsupportedOperationException("isMasterInMaintenanceMode not supported in ThriftAdmin");
    }

    public void stopRegionServer(String hostnamePort) {
        throw new UnsupportedOperationException("stopRegionServer not supported in ThriftAdmin");
    }

    public List<HRegionInfo> getTableRegions(TableName tableName) {
        throw new UnsupportedOperationException("getTableRegions not supported in ThriftAdmin");
    }

    public boolean abortProcedure(long procId, boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException("abortProcedure not supported in ThriftAdmin");
    }

    public Future<Boolean> abortProcedureAsync(long procId, boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException("abortProcedureAsync not supported in ThriftAdmin");
    }

    public void rollWALWriter(ServerName serverName) {
        throw new UnsupportedOperationException("rollWALWriter not supported in ThriftAdmin");
    }

    public long getLastMajorCompactionTimestamp(TableName tableName) {
        throw new UnsupportedOperationException("getLastMajorCompactionTimestamp not supported in ThriftAdmin");
    }

    public long getLastMajorCompactionTimestampForRegion(byte[] regionName) {
        throw new UnsupportedOperationException("getLastMajorCompactionTimestampForRegion not supported in ThriftAdmin");
    }

    public void snapshot(String snapshotName, TableName tableName) {
        throw new UnsupportedOperationException("snapshot not supported in ThriftAdmin");
    }

    public void snapshot(byte[] snapshotName, TableName tableName) {
        throw new UnsupportedOperationException("snapshot not supported in ThriftAdmin");
    }

    public void restoreSnapshot(byte[] snapshotName) {
        throw new UnsupportedOperationException("restoreSnapshot not supported in ThriftAdmin");
    }

    public void restoreSnapshot(String snapshotName) {
        throw new UnsupportedOperationException("restoreSnapshot not supported in ThriftAdmin");
    }

    public void restoreSnapshot(byte[] snapshotName, boolean takeFailSafeSnapshot) {
        throw new UnsupportedOperationException("restoreSnapshot not supported in ThriftAdmin");
    }

    public void restoreSnapshot(String snapshotName, boolean takeFailSafeSnapshot) {
        throw new UnsupportedOperationException("restoreSnapshot not supported in ThriftAdmin");
    }

    public void restoreSnapshot(String snapshotName, boolean takeFailSafeSnapshot, boolean restoreAcl) {
        throw new UnsupportedOperationException("restoreSnapshot not supported in ThriftAdmin");
    }

    public void cloneSnapshot(byte[] snapshotName, TableName tableName) {
        throw new UnsupportedOperationException("cloneSnapshot not supported in ThriftAdmin");
    }

    public void cloneSnapshot(String snapshotName, TableName tableName, boolean restoreAcl) {
        throw new UnsupportedOperationException("cloneSnapshot not supported in ThriftAdmin");
    }

    public void cloneSnapshot(String snapshotName, TableName tableName) {
        throw new UnsupportedOperationException("cloneSnapshot not supported in ThriftAdmin");
    }

    public void execProcedure(String signature, String instance, Map<String, String> props) {
        throw new UnsupportedOperationException("execProcedure not supported in ThriftAdmin");
    }

    public boolean isProcedureFinished(String signature, String instance, Map<String, String> props) {
        throw new UnsupportedOperationException("isProcedureFinished not supported in ThriftAdmin");
    }

    public void deleteSnapshot(byte[] snapshotName) {
        throw new UnsupportedOperationException("deleteSnapshot not supported in ThriftAdmin");
    }

    public void deleteSnapshot(String snapshotName) {
        throw new UnsupportedOperationException("deleteSnapshot not supported in ThriftAdmin");
    }

    public void deleteSnapshots(String regex) {
        throw new UnsupportedOperationException("deleteSnapshots not supported in ThriftAdmin");
    }

    public void deleteSnapshots(Pattern pattern) {
        throw new UnsupportedOperationException("deleteSnapshots not supported in ThriftAdmin");
    }

    public void deleteTableSnapshots(String tableNameRegex, String snapshotNameRegex) {
        throw new UnsupportedOperationException("deleteTableSnapshots not supported in ThriftAdmin");
    }

    public void deleteTableSnapshots(Pattern tableNamePattern, Pattern snapshotNamePattern) {
        throw new UnsupportedOperationException("deleteTableSnapshots not supported in ThriftAdmin");
    }

    public void setQuota(QuotaSettings quota) {
        throw new UnsupportedOperationException("setQuota not supported in ThriftAdmin");
    }

    public QuotaRetriever getQuotaRetriever(QuotaFilter filter) {
        throw new UnsupportedOperationException("getQuotaRetriever not supported in ThriftAdmin");
    }

    public CoprocessorRpcChannel coprocessorService() {
        throw new UnsupportedOperationException("coprocessorService not supported in ThriftAdmin");
    }

    public CoprocessorRpcChannel coprocessorService(ServerName serverName) {
        throw new UnsupportedOperationException("coprocessorService not supported in ThriftAdmin");
    }

    public void updateConfiguration(ServerName server) {
        throw new UnsupportedOperationException("updateConfiguration not supported in ThriftAdmin");
    }

    public void updateConfiguration() {
        throw new UnsupportedOperationException("updateConfiguration not supported in ThriftAdmin");
    }

    public List<SecurityCapability> getSecurityCapabilities() {
        throw new UnsupportedOperationException("getSecurityCapabilities not supported in ThriftAdmin");
    }

    public List<ServerName> clearDeadServers(List<ServerName> servers) {
        throw new UnsupportedOperationException("clearDeadServers not supported in ThriftAdmin");
    }

    public void move(byte[] bytes, byte[] bytes1) throws IOException {
        throw new UnsupportedOperationException("move not supported in ThriftAdmin");
    }

    public void createTableAsync(HTableDescriptor hTableDescriptor, byte[][] bytes) throws IOException {
        throw new UnsupportedOperationException("createTableAsync not supported in ThriftAdmin");
    }

    public void enableTableAsync(TableName tableName) throws IOException {
        throw new UnsupportedOperationException("enableTableAsync not supported in ThriftAdmin");
    }

    public void disableTableAsync(TableName tableName) throws IOException {
        throw new UnsupportedOperationException("disableTableAsync not supported in ThriftAdmin");
    }

    public Pair<Integer, Integer> getAlterStatus(TableName tableName) throws IOException {
        return new Pair((Object)0, (Object)1);
    }

    public Pair<Integer, Integer> getAlterStatus(byte[] bytes) throws IOException {
        return new Pair((Object)0, (Object)1);
    }

    public void compactRegionServer(ServerName serverName, boolean b) throws IOException, InterruptedException {
        throw new UnsupportedOperationException("compactRegionServer not supported in ThriftAdmin");
    }

    public boolean setBalancerRunning(boolean b, boolean b1) throws IOException {
        throw new UnsupportedOperationException("setBalancerRunning not supported in ThriftAdmin");
    }

    public boolean balancer() throws IOException {
        throw new UnsupportedOperationException("balancer not supported in ThriftAdmin");
    }

    public boolean balancer(boolean b) throws IOException {
        throw new UnsupportedOperationException("balancer not supported in ThriftAdmin");
    }

    public boolean setNormalizerRunning(boolean b) throws IOException {
        throw new UnsupportedOperationException("setNormalizerRunning not supported in ThriftAdmin");
    }

    public boolean enableCatalogJanitor(boolean b) throws IOException {
        throw new UnsupportedOperationException("enableCatalogJanitor not supported in ThriftAdmin");
    }

    public int runCatalogScan() throws IOException {
        throw new UnsupportedOperationException("runCatalogScan not supported in ThriftAdmin");
    }

    public boolean setCleanerChoreRunning(boolean b) throws IOException {
        throw new UnsupportedOperationException("setCleanerChoreRunning not supported in ThriftAdmin");
    }

    public ClusterStatus getClusterStatus() throws IOException {
        throw new UnsupportedOperationException("getClusterStatus not supported in ThriftAdmin");
    }

    public ProcedureInfo[] listProcedures() throws IOException {
        throw new UnsupportedOperationException("listProcedures not supported in ThriftAdmin");
    }

    public String[] getMasterCoprocessors() throws IOException {
        throw new UnsupportedOperationException("getMasterCoprocessors not supported in ThriftAdmin");
    }

    public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionState(TableName tableName) throws IOException {
        throw new UnsupportedOperationException("getCompactionState not supported in ThriftAdmin");
    }

    public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionStateForRegion(byte[] bytes) throws IOException {
        throw new UnsupportedOperationException("getCompactionStateForRegion not supported in ThriftAdmin");
    }

    public void snapshot(String s, TableName tableName, HBaseProtos.SnapshotDescription.Type type) throws IOException, SnapshotCreationException, IllegalArgumentException {
        throw new UnsupportedOperationException("snapshot not supported in ThriftAdmin");
    }

    public void snapshot(HBaseProtos.SnapshotDescription snapshotDescription) throws IOException, SnapshotCreationException, IllegalArgumentException {
        throw new UnsupportedOperationException("snapshot not supported in ThriftAdmin");
    }

    public MasterProtos.SnapshotResponse takeSnapshotAsync(HBaseProtos.SnapshotDescription snapshotDescription) throws IOException, SnapshotCreationException {
        throw new UnsupportedOperationException("takeSnapshotAsync not supported in ThriftAdmin");
    }

    public boolean isSnapshotFinished(HBaseProtos.SnapshotDescription snapshotDescription) throws IOException, HBaseSnapshotException, UnknownSnapshotException {
        throw new UnsupportedOperationException("isSnapshotFinished not supported in ThriftAdmin");
    }

    public byte[] execProcedureWithRet(String s, String s1, Map<String, String> map) throws IOException {
        throw new UnsupportedOperationException("execProcedureWithRet not supported in ThriftAdmin");
    }

    public List<HBaseProtos.SnapshotDescription> listSnapshots() throws IOException {
        throw new UnsupportedOperationException("listSnapshots not supported in ThriftAdmin");
    }

    public List<HBaseProtos.SnapshotDescription> listSnapshots(String s) throws IOException {
        throw new UnsupportedOperationException("listSnapshots not supported in ThriftAdmin");
    }

    public List<HBaseProtos.SnapshotDescription> listSnapshots(Pattern pattern) throws IOException {
        throw new UnsupportedOperationException("listSnapshots not supported in ThriftAdmin");
    }

    public List<HBaseProtos.SnapshotDescription> listTableSnapshots(String s, String s1) throws IOException {
        throw new UnsupportedOperationException("listTableSnapshots not supported in ThriftAdmin");
    }

    public List<HBaseProtos.SnapshotDescription> listTableSnapshots(Pattern pattern, Pattern pattern1) throws IOException {
        throw new UnsupportedOperationException("listTableSnapshots not supported in ThriftAdmin");
    }

    public int getMasterInfoPort() throws IOException {
        throw new UnsupportedOperationException("getMasterInfoPort not supported in ThriftAdmin");
    }

    public List<ServerName> listDeadServers() throws IOException {
        throw new UnsupportedOperationException("listDeadServers not supported in ThriftAdmin");
    }
}

