/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.compile;

import com.alibaba.lindorm.client.core.compile.BaseExpressionVisitor;
import com.alibaba.lindorm.client.core.expression.AndExpression;
import com.alibaba.lindorm.client.core.expression.ComparisonExpression;
import com.alibaba.lindorm.client.core.expression.Expression;
import com.alibaba.lindorm.client.core.expression.OrExpression;
import com.alibaba.lindorm.client.core.expression.RowComparisonExpression;
import com.alibaba.lindorm.client.dml.ColumnValue;
import com.alibaba.lindorm.client.dml.Condition;
import com.alibaba.lindorm.client.dml.ConditionFactory;
import com.alibaba.lindorm.client.dml.ConditionList;
import com.alibaba.lindorm.client.dml.Row;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.exception.LindormException;
import java.util.List;

public class RowComparisonExpressionVisitor
extends BaseExpressionVisitor<Expression> {
    @Override
    public Expression visitLeave(AndExpression node, List<Expression> results) throws LindormException {
        return new AndExpression(results);
    }

    @Override
    public Expression visitLeave(OrExpression node, List<Expression> results) throws LindormException {
        return new OrExpression(results);
    }

    @Override
    public Expression visit(ComparisonExpression node) throws LindormException {
        return node;
    }

    @Override
    public Expression visit(RowComparisonExpression node) throws LindormException {
        this.validateRow(node.getRow());
        ConditionFactory.CompareOp op = node.getOp();
        ConditionList conditionList = ConditionFactory.or();
        switch (op) {
            case LESS_OR_EQUAL: {
                conditionList.add(this.generateSingleCondition(node.getRow().getColumnValues(), ConditionFactory.CompareOp.EQUAL));
            }
            case LESS: {
                conditionList.add(this.generateMultipleConditions(node.getRow().getColumnValues(), ConditionFactory.CompareOp.LESS));
                return conditionList.getConditions().size() == 1 ? conditionList.getConditions().get(0) : conditionList;
            }
            case EQUAL: 
            case NOT_EQUAL: {
                return this.generateSingleCondition(node.getRow().getColumnValues(), op);
            }
            case GREATER_OR_EQUAL: {
                conditionList.add(this.generateSingleCondition(node.getRow().getColumnValues(), ConditionFactory.CompareOp.EQUAL));
            }
            case GREATER: {
                conditionList.add(this.generateMultipleConditions(node.getRow().getColumnValues(), ConditionFactory.CompareOp.GREATER));
                return conditionList.getConditions().size() == 1 ? conditionList.getConditions().get(0) : conditionList;
            }
        }
        return node;
    }

    private void validateRow(Row row) throws IllegalRequestException {
        List<ColumnValue> columnValues = row.getColumnValues();
        if (columnValues.size() <= 0) {
            throw new IllegalRequestException("Found empty columns in row comparison expression, you should add at least one column.");
        }
    }

    private Condition generateSingleCondition(List<ColumnValue> columnValues, ConditionFactory.CompareOp op) throws LindormException {
        if (columnValues.size() == 1) {
            return ConditionFactory.compare(columnValues.get(0), op);
        }
        ConditionList conditionList = ConditionFactory.and();
        for (ColumnValue columnValue : columnValues) {
            conditionList.add(ConditionFactory.compare(columnValue, op));
        }
        return conditionList;
    }

    private Condition generateMultipleConditions(List<ColumnValue> columnValues, ConditionFactory.CompareOp op) throws LindormException {
        int numColumnValues = columnValues.size();
        if (numColumnValues == 1) {
            return ConditionFactory.compare(columnValues.get(0), op);
        }
        ConditionList conditionList = ConditionFactory.or();
        for (int i = 0; i < numColumnValues; ++i) {
            if (i == 0) {
                conditionList.add(ConditionFactory.compare(columnValues.get(i), op));
                continue;
            }
            ConditionList subConditionList = ConditionFactory.and();
            for (int j = 0; j < i; ++j) {
                subConditionList.add(ConditionFactory.compare(columnValues.get(j), ConditionFactory.CompareOp.EQUAL));
            }
            subConditionList.add(ConditionFactory.compare(columnValues.get(i), op));
            conditionList.add(subConditionList);
        }
        return conditionList;
    }
}

