/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.ipc;

import com.alibaba.lindorm.client.LindormClientConfig;
import com.alibaba.lindorm.client.LindormClientConstants;
import com.alibaba.lindorm.client.core.LindormBasicService;
import com.alibaba.lindorm.client.core.ipc.Attributes;
import com.alibaba.lindorm.client.core.ipc.ClientProtocolEngine;
import com.alibaba.lindorm.client.core.ipc.ConfigUpdater;
import com.alibaba.lindorm.client.core.ipc.DefaultIDCRequestSequence;
import com.alibaba.lindorm.client.core.ipc.DefaultLDServerLocator;
import com.alibaba.lindorm.client.core.ipc.IDCRequestSequence;
import com.alibaba.lindorm.client.core.ipc.LConnection;
import com.alibaba.lindorm.client.core.ipc.LConnectionManager;
import com.alibaba.lindorm.client.core.ipc.LDServerAddress;
import com.alibaba.lindorm.client.core.ipc.LDServerLocator;
import com.alibaba.lindorm.client.core.ipc.LindormClientProtocol;
import com.alibaba.lindorm.client.core.ipc.LocationCache;
import com.alibaba.lindorm.client.core.ipc.OnlySeedServerLDServerLocator;
import com.alibaba.lindorm.client.core.ipc.RetryingCaller;
import com.alibaba.lindorm.client.core.ipc.RpcClient;
import com.alibaba.lindorm.client.core.meta.RangeRouter;
import com.alibaba.lindorm.client.core.meta.TableAttributes;
import com.alibaba.lindorm.client.core.meta.TableKey;
import com.alibaba.lindorm.client.core.meta.TableMeta;
import com.alibaba.lindorm.client.core.meta.TableMetaCache;
import com.alibaba.lindorm.client.core.metrics.PassiveMetrics;
import com.alibaba.lindorm.client.core.metrics.TableMetricsManager;
import com.alibaba.lindorm.client.core.tableservice.DmlOperation;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.ClientEnvLogUtil;
import com.alibaba.lindorm.client.core.utils.Threads;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.exception.LindormException;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LConnectionImplementation
implements LConnection {
    private static final Log LOG = LogFactory.getLog((String)LConnectionImplementation.class.getName());
    private static final Class<?> serverInterfaceClass = LindormClientProtocol.class;
    private final Map<String, LindormClientProtocol> servers = new ConcurrentHashMap<String, LindormClientProtocol>();
    private final ConcurrentHashMap<String, String> connectionLock = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, LindormBasicService> serviceMap = new ConcurrentHashMap();
    private final Set<TableKey> preCachedTable = new HashSet<TableKey>();
    private final TableMetaCache tableMetaCache = new TableMetaCache();
    private ScheduledThreadPoolExecutor delayRetryPool;
    private PassiveMetrics passiveMetrics;
    private int refCount;
    private volatile boolean closed = false;
    private final boolean managed;
    private int hashcode = this.generateHashcode();
    private String userName;
    private String password;
    private LindormClientConfig config;
    private volatile int rpcTimeout;
    private volatile int pause;
    private volatile int numRetries;
    private volatile int maxVMPauseDelayInMS;
    private volatile boolean skipConsistencyCheck;
    private LDServerLocator ldServerLocator;
    private ConfigUpdater configUpdater;
    private TableMetricsManager tableMetricsManager;

    public LConnectionImplementation(LindormClientConfig config, boolean managed) throws LindormException {
        this.managed = managed;
        this.userName = config.get("lindorm.client.username");
        this.password = config.get("lindorm.client.password");
        this.onConfigChange(config);
        this.ldServerLocator = config.getBoolean("lindorm.rpc.only.use.seedserver", false) ? new OnlySeedServerLDServerLocator(config, this) : new DefaultLDServerLocator(config, this);
        this.configUpdater = new ConfigUpdater(config, this);
        this.passiveMetrics = new PassiveMetrics(config);
        this.tableMetricsManager = new TableMetricsManager(config);
    }

    @Override
    public void onConfigChange(LindormClientConfig config) throws LindormException {
        this.rpcTimeout = config.getInt("lindorm.rpc.timeout", 60000);
        this.pause = config.getInt("lindorm.rpc.pause.time", 100);
        this.numRetries = config.getInt("lindorm.client.retries.number", 10);
        this.maxVMPauseDelayInMS = config.getInt("lindorm.rpc.max.vmpause.timeout.delay", LindormClientConstants.RPC_MAX_VMPAUSE_TIMEOUT_DELAY_DEFAULT);
        this.skipConsistencyCheck = config.getBoolean("lindorm.client.rpc.skip.consistency.check", false);
        if (this.ldServerLocator != null) {
            this.ldServerLocator.onConfigChange(config);
        }
        if (this.configUpdater != null) {
            this.configUpdater.onConfigChange(config);
        }
        if (this.tableMetricsManager != null) {
            this.tableMetricsManager.onConfigChange(config);
        }
        for (LindormBasicService service : this.serviceMap.values()) {
            service.onConfigChange(config);
        }
        int delayRetryPoolSize = config.getInt("lindorm.client.delay.retry.thread.pool", 20);
        if (this.delayRetryPool == null) {
            this.delayRetryPool = new ScheduledThreadPoolExecutor(delayRetryPoolSize, Threads.getNamedThreadFactory("DELAY_RETRY"));
        } else {
            this.delayRetryPool.setCorePoolSize(delayRetryPoolSize);
        }
        if (this.passiveMetrics != null) {
            this.passiveMetrics.onConfigChange(config);
        }
        this.config = config;
        ClientEnvLogUtil.resetLoggerLevel(config);
        LOG.info((Object)("Connection Configuration, rpcTimeout: " + this.rpcTimeout + ", rpc pause " + this.pause + ", retries " + this.numRetries));
    }

    private String getPriorityIDCForOperation(DmlOperation operation, List<String> idcs) {
        if (operation == null) {
            return null;
        }
        TableMeta tableMeta = this.getTableMetaCache().getTable(operation.getNamespace(), operation.getTableName());
        if (tableMeta == null) {
            return null;
        }
        if (tableMeta.getConsistencyType() == TableAttributes.ConsistencyType.Strong) {
            String leaderIDC = null;
            long ts = 0L;
            for (String idc : idcs) {
                LocationCache.Location location = this.ldServerLocator.getCachedLocation(idc, operation);
                if (location == null || !location.isLeader() || location.getTs() <= ts) continue;
                leaderIDC = idc;
                ts = location.getTs();
            }
            return leaderIDC;
        }
        RangeRouter rangeRouter = tableMeta.getRangeRouter();
        if (rangeRouter == null) {
            return null;
        }
        return rangeRouter.getPriorityIDCOfRow(operation.getKey());
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public ConfigUpdater getConfigUpdater() {
        return this.configUpdater;
    }

    @Override
    public LDServerLocator getLdServerLocator() {
        return this.ldServerLocator;
    }

    @Override
    public List<String> getAvailableIDCs() {
        return this.ldServerLocator.getAvailableIDCs(false);
    }

    @Override
    public String getSingleRequestIDC() {
        return this.ldServerLocator.getSingleRequestIDC();
    }

    @Override
    public IDCRequestSequence getIDCRequestSequence(DmlOperation operation) {
        List<String> idcs = this.ldServerLocator.getAvailableIDCs(true);
        if (operation == null) {
            return new DefaultIDCRequestSequence(idcs);
        }
        String priorityIDCForOperation = this.getPriorityIDCForOperation(operation, idcs);
        if (priorityIDCForOperation == null) {
            return new DefaultIDCRequestSequence(idcs);
        }
        ArrayList<String> newIdcLists = new ArrayList<String>();
        newIdcLists.add(priorityIDCForOperation);
        for (String idc : idcs) {
            if (idc.equals(priorityIDCForOperation)) continue;
            newIdcLists.add(idc);
        }
        return new DefaultIDCRequestSequence(newIdcLists);
    }

    @Override
    public List<String> getAllIDC() {
        return this.ldServerLocator.getAllIDC();
    }

    @Override
    public boolean registerService(String serviceName, LindormBasicService service) {
        LindormBasicService exist = this.serviceMap.putIfAbsent(serviceName, service);
        return exist == null;
    }

    @Override
    public boolean unregisterService(String serviceName) {
        LindormBasicService exist = this.serviceMap.remove(serviceName);
        return exist == null;
    }

    @Override
    public <T> RetryingCaller<T> getDDLRetryingCaller(int callTimeout, String doAsUser) throws LindormException {
        this.checkOpen();
        return new RetryingCaller(this, this.pause, this.numRetries, callTimeout, 0, 0, doAsUser, false);
    }

    @Override
    public <T> RetryingCaller<T> getDMLRetryingCaller(int callTimeout, int glitchTimeout, String doAsUser) throws LindormException {
        this.checkOpen();
        return new RetryingCaller(this, this.pause, this.numRetries, callTimeout, glitchTimeout, this.maxVMPauseDelayInMS, doAsUser, this.skipConsistencyCheck);
    }

    @Override
    public <T> RetryingCaller<T> getExporterRetryingCaller(int callTimeout, String idcSpecified) throws LindormException {
        this.checkOpen();
        RetryingCaller retryingCaller = new RetryingCaller(this, this.pause, this.numRetries, callTimeout);
        retryingCaller.setIdcToRequest(idcSpecified);
        return retryingCaller;
    }

    @Override
    public <T> RetryingCaller<T> getIdcSpecifiedRetryingCaller(int callTimeout, String idc) throws LindormException {
        this.checkOpen();
        RetryingCaller retryingCaller = new RetryingCaller(this, this.pause, this.numRetries, callTimeout);
        retryingCaller.setIdcToRequest(idc);
        return retryingCaller;
    }

    @Override
    public void prefetchRouteCache(String namespace, String table) throws IOException {
        if (table != null && this.preCachedTable.contains(new TableKey(namespace, table))) {
            return;
        }
        List<String> idcs = this.ldServerLocator.getAllIDC();
        for (String idc : idcs) {
            LDServerAddress address = this.ldServerLocator.locateServer(idc, null, false);
            LindormClientProtocol server = this.getLdServerConnection(address);
            List<LocationCache.Location> locations = server.prefetchRouteCache(namespace, table);
            byte[] lastTableName = LindormClientConstants.EMPTY_BYTE_ARRAY;
            for (LocationCache.Location location : locations) {
                this.ldServerLocator.cacheLocation(location);
                if (Bytes.equals(lastTableName, location.getTableName())) continue;
                this.preCachedTable.add(new TableKey(namespace, Bytes.toString(location.getTableName())));
                lastTableName = location.getTableName();
            }
        }
    }

    @Override
    public TableMetaCache getTableMetaCache() {
        return this.tableMetaCache;
    }

    @Override
    public LDServerAddress locateServer(String idc, DmlOperation operation, boolean useCache) throws IOException {
        return this.ldServerLocator.locateServer(idc, operation, useCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LindormClientProtocol getLdServerConnection(LDServerAddress ldServerAddress) throws IOException {
        String rsName = ldServerAddress.toString();
        LindormClientProtocol server = this.servers.get(rsName);
        if (server == null) {
            this.connectionLock.putIfAbsent(rsName, rsName);
            String string = this.connectionLock.get(rsName);
            synchronized (string) {
                server = this.servers.get(rsName);
                if (server == null) {
                    server = (LindormClientProtocol)ClientProtocolEngine.getProxy(serverInterfaceClass, this.config, this.getUserName(), this.getPassword(), ldServerAddress, this.rpcTimeout);
                    this.servers.put(rsName, server);
                }
            }
        }
        return server;
    }

    @Override
    public void handleAttributes(LDServerAddress address, Object o) {
        try {
            this.ldServerLocator.cleanErrorLocation(address);
            if (o instanceof Attributes) {
                List<LocationCache.Location> locations;
                byte[] routeInfo;
                LocationCache.LocationList locationList;
                Attributes attributes = (Attributes)o;
                if (attributes.hasAttribute(Attributes.ROUTECACHEKEY) && (locationList = LocationCache.LocationList.fromBytes(routeInfo = attributes.getAttribute(Attributes.ROUTECACHEKEY))) != null && locationList.getLocations() != null && !(locations = locationList.getLocations()).isEmpty()) {
                    LDServerAddress successLocation = locations.get(0).getAddress();
                    this.ldServerLocator.unbanServer(successLocation);
                    for (LocationCache.Location location : locations) {
                        this.ldServerLocator.cacheLocation(location);
                    }
                }
                if (attributes.hasAttribute(Attributes.SERVERBANLIST)) {
                    byte[] data = attributes.getAttribute(Attributes.SERVERBANLIST);
                    DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
                    int n = WritableUtils.readVInt(in);
                    for (int i = 0; i < n; ++i) {
                        LDServerAddress server = new LDServerAddress();
                        server.readFrom(in);
                        if (this.ldServerLocator.isServerBanned(server)) continue;
                        LOG.info((Object)("Ban server " + server));
                        this.ldServerLocator.banServer(server);
                    }
                }
            }
        }
        catch (Throwable t) {
            LOG.debug((Object)("Error happened when handle attributes from server " + o), t);
        }
    }

    @Override
    public LindormClientConfig getConfig() {
        return this.config;
    }

    @Override
    public void updateConfigNow() {
        this.configUpdater.updateNow();
    }

    void incCount() {
        ++this.refCount;
    }

    void decCount() {
        if (this.refCount > 0) {
            --this.refCount;
        }
    }

    boolean isZeroReference() {
        return this.refCount == 0;
    }

    @Override
    public void close() {
        if (this.managed) {
            LConnectionManager.deleteConnection(this);
        } else {
            this.close(true);
        }
    }

    synchronized void close(boolean stopProxy) {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.configUpdater.close();
        this.ldServerLocator.close();
        this.tableMetricsManager.close();
        this.delayRetryPool.shutdown();
        if (stopProxy) {
            for (LindormClientProtocol i : this.servers.values()) {
                ClientProtocolEngine.stopProxy(i);
            }
        }
        this.servers.clear();
    }

    @Override
    public void closeConnection(LDServerAddress serverAddress) {
        RpcClient rpcClient = ClientProtocolEngine.getCachedRpcClient();
        if (rpcClient != null) {
            RpcClient.ConnectionId connectionId = new RpcClient.ConnectionId(serverAddress, serverInterfaceClass, this.userName, this.password);
            rpcClient.disconnect(connectionId);
        }
    }

    public int hashCode() {
        return this.hashcode;
    }

    private int generateHashcode() {
        Random random = new Random();
        int hashcode = super.hashCode();
        while ((hashcode += random.nextInt()) == 0) {
        }
        return Math.abs(hashcode);
    }

    @Override
    public TableMetricsManager getTableMetricsManager() {
        return this.tableMetricsManager;
    }

    public void checkOpen() throws LindormException {
        if (this.closed) {
            throw new LindormException("Connection already closed");
        }
    }

    @Override
    public ScheduledExecutorService getDelayRetryPool() {
        return this.delayRetryPool;
    }

    @Override
    public PassiveMetrics getPassiveMetrics() {
        return this.passiveMetrics;
    }
}

