/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.ipc;

import com.alibaba.lindorm.client.LindormClientConfig;
import com.alibaba.lindorm.client.core.ipc.LConnection;
import com.alibaba.lindorm.client.core.ipc.LConnectionImplementation;
import com.alibaba.lindorm.client.core.utils.ClientEnvLogUtil;
import com.alibaba.lindorm.client.exception.LindormException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LConnectionManager {
    private static final Log LOG = LogFactory.getLog((String)LConnectionManager.class.getName());
    private static final Map<LConnectionKey, LConnectionImplementation> LCONNECTION_INSTANCES = new HashMap<LConnectionKey, LConnectionImplementation>();

    protected LConnectionManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LConnection getLConnection(LindormClientConfig config) throws LindormException {
        LConnectionKey connectionKey = new LConnectionKey(config);
        Map<LConnectionKey, LConnectionImplementation> map = LCONNECTION_INSTANCES;
        synchronized (map) {
            LConnectionImplementation lConnection = LCONNECTION_INSTANCES.get(connectionKey);
            if (lConnection == null) {
                LindormClientConfig copiedConfig = new LindormClientConfig(config);
                lConnection = new LConnectionImplementation(copiedConfig, true);
                LCONNECTION_INSTANCES.put(connectionKey, lConnection);
            }
            lConnection.incCount();
            return lConnection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteConnection(LConnection client) {
        Map<LConnectionKey, LConnectionImplementation> map = LCONNECTION_INSTANCES;
        synchronized (map) {
            LConnectionImplementation clientToDelete = null;
            LConnectionKey key = null;
            for (Map.Entry<LConnectionKey, LConnectionImplementation> clientEntry : LCONNECTION_INSTANCES.entrySet()) {
                if (clientEntry.getValue() != client) continue;
                clientToDelete = clientEntry.getValue();
                key = clientEntry.getKey();
                break;
            }
            if (clientToDelete != null) {
                clientToDelete.decCount();
                if (clientToDelete.isZeroReference()) {
                    LCONNECTION_INSTANCES.remove(key);
                    clientToDelete.close(true);
                }
            } else {
                LOG.error((Object)("RpcClient not found in the list, can't delete it (RpcClient=" + client + ". May be the key was modified?"));
            }
        }
    }

    static {
        ClientEnvLogUtil.initClientLog();
    }

    static class LConnectionKey {
        public static String[] CLIENT_PROPERTIES = new String[]{"lindorm.client.username", "lindorm.client.password", "lindorm.client.seedserver", "lindorm.client.requestmode", "lindorm.client.priority.idc", "lindorm.rpc.pause.time", "lindorm.client.retries.number", "lindorm.rpc.timeout", "lindorm.rpc.idc.ping.timeout", "lindorm.rpc.idc.ping.number.limit", "lindorm.rpc.idc.nearby.max.ping.delay", "lindorm.rpc.update.config.retry", "lindorm.client.sorter.type", "lindorm.client.rpc.skip.consistency.check", "lindorm.client.connection.magic"};
        private Map<String, String> properties;

        public LConnectionKey(LindormClientConfig conf) {
            HashMap<String, String> m = new HashMap<String, String>();
            if (conf != null) {
                for (String property : CLIENT_PROPERTIES) {
                    String value = conf.get(property);
                    if (value == null) continue;
                    m.put(property, value);
                }
            }
            this.properties = Collections.unmodifiableMap(m);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            for (String property : this.properties.keySet()) {
                String value = this.properties.get(property);
                if (value == null) continue;
                result = 31 * result + value.hashCode();
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LConnectionKey that = (LConnectionKey)obj;
            if (this.properties == null) {
                if (that.properties != null) {
                    return false;
                }
            } else {
                if (that.properties == null) {
                    return false;
                }
                for (String property : this.properties.keySet()) {
                    String thatValue;
                    String thisValue = this.properties.get(property);
                    if (thisValue == (thatValue = that.properties.get(property)) || thisValue != null && thisValue.equals(thatValue)) continue;
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            return "HConnectionKey{properties=" + this.properties;
        }
    }
}

