/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.meta;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.Bytes;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class FamilyAttributes
extends VersionedObjectWithAttributes {
    public static final Set<String> ALL_FAMILY_ATTRIBUTE_KEYS;

    public void setToDefaultIfUnset() {
        if (!this.hasAttribute("BLOOMFILTER")) {
            this.setBloomFilterType("ROW");
        }
        if (!this.hasAttribute("MEMSTORE_FILTER")) {
            this.setMemStoreFilterType("DISABLED");
        }
        if (!this.hasAttribute("COMPRESSION")) {
            this.setCompression("NONE");
        }
        if (!this.hasAttribute("DATA_BLOCK_ENCODING")) {
            this.setDataBlockEncoding("INDEX");
        }
        if (!this.hasAttribute("STORAGETYPE")) {
            this.setStorageType("DEFAULT");
        }
        if (!this.hasAttribute("TTL")) {
            this.setTimeToLive(Integer.MAX_VALUE);
        }
        if (!this.hasAttribute("VERSIONS")) {
            this.setMaxVersions(1);
        }
        if (!this.hasAttribute("MIN_VERSIONS")) {
            this.setMinVersions(0);
        }
        if (!this.hasAttribute("DFS_REPLICATION")) {
            this.setDfsReplication((short)2);
        }
        if (!this.hasAttribute("TIME_TO_PURGE_DELETES")) {
            this.setTimeToPurgeDeletes(259200000L);
        }
        if (!this.hasAttribute("IN_MEMORY")) {
            this.setInMemory(false);
        }
    }

    public void setTimeToLive(int ttl) {
        if (ttl <= 0) {
            throw new RuntimeException("TTL must > 0, but has " + ttl);
        }
        this.setAttribute("TTL", Integer.toString(ttl));
    }

    public int getTimeToLive() {
        byte[] ttl = this.getAttribute("TTL");
        return ttl == null ? Integer.MAX_VALUE : Integer.valueOf(Bytes.toString(ttl));
    }

    public Integer getTimeToLiveNoDefault() {
        byte[] ttl = this.getAttribute("TTL");
        return ttl == null ? null : Integer.valueOf(Bytes.toString(ttl));
    }

    public void setCompression(String compression) {
        this.setAttribute("COMPRESSION", compression);
    }

    public String getCompression() {
        return this.getAttribute("COMPRESSION", "NONE");
    }

    public String getCompressionNoDefault() {
        return this.getAttribute("COMPRESSION", (String)null);
    }

    public void setCompactionCompressionLevel(short level) {
        this.setAttribute("COMPACTION_COMPRESSION_LEVEL", Short.toString(level));
    }

    public short getCompactionCompressionLevel() {
        Short v = this.getCompactionCompressionLevelNoDefault();
        return v != null ? (short)v : (short)-1;
    }

    public Short getCompactionCompressionLevelNoDefault() {
        String n = this.getAttribute("COMPACTION_COMPRESSION_LEVEL", (String)null);
        return n == null ? null : Short.valueOf(n);
    }

    public void setDataBlockEncoding(String encoding) {
        this.setAttribute("DATA_BLOCK_ENCODING", encoding);
    }

    public String getDataBlockEncoding() {
        return this.getAttribute("DATA_BLOCK_ENCODING", "INDEX");
    }

    public String getDataBlockEncodingNoDefault() {
        return this.getAttribute("DATA_BLOCK_ENCODING", (String)null);
    }

    public void setMaxVersions(int maxVersions) {
        this.setAttribute("VERSIONS", Integer.toString(maxVersions));
    }

    public int getMaxVersions() {
        byte[] versions = this.getAttribute("VERSIONS");
        return versions == null ? 1 : Integer.valueOf(Bytes.toString(versions));
    }

    public Integer getMaxVersionsNoDefault() {
        byte[] versions = this.getAttribute("VERSIONS");
        return versions == null ? null : Integer.valueOf(Bytes.toString(versions));
    }

    public void setBloomFilterType(String bloomFilter) {
        this.setAttribute("BLOOMFILTER", bloomFilter);
    }

    public String getBloomFilterType() {
        return this.getAttribute("BLOOMFILTER", "ROW");
    }

    public String getMemstoreFilterTypeNoDefault() {
        return this.getAttribute("MEMSTORE_FILTER", (String)null);
    }

    public void setMemStoreFilterType(String type) {
        this.setAttribute("MEMSTORE_FILTER", type);
    }

    public String getMemstoreFilterType() {
        return this.getAttribute("MEMSTORE_FILTER", "DISABLED");
    }

    public String getBloomFilterTypeNoDefault() {
        return this.getAttribute("BLOOMFILTER", (String)null);
    }

    public void setMinVersions(int minVersions) {
        this.setAttribute("MIN_VERSIONS", Integer.toString(minVersions));
    }

    public int getMinVersions() {
        byte[] minVersions = this.getAttribute("MIN_VERSIONS");
        return minVersions == null ? 0 : Integer.valueOf(Bytes.toString(minVersions));
    }

    public Integer getMinVersionsNoDefault() {
        byte[] minVersions = this.getAttribute("MIN_VERSIONS");
        return minVersions == null ? null : Integer.valueOf(Bytes.toString(minVersions));
    }

    public void setDfsReplication(short dfsReplication) {
        this.setAttribute("DFS_REPLICATION", Short.toString(dfsReplication));
    }

    public short getDfsReplication() {
        byte[] dfsReplication = this.getAttribute("DFS_REPLICATION");
        return dfsReplication == null ? (short)2 : Short.valueOf(Bytes.toString(dfsReplication));
    }

    public Short getDfsReplicationNoDefault() {
        byte[] dfsReplication = this.getAttribute("DFS_REPLICATION");
        return dfsReplication == null ? null : Short.valueOf(Bytes.toString(dfsReplication));
    }

    public void setStorageType(String storageType) {
        this.setAttribute("STORAGETYPE", storageType);
    }

    public String getStorageType() {
        return this.getAttribute("STORAGETYPE", "DEFAULT");
    }

    public String getStorageTypeNoDefault() {
        return this.getAttribute("STORAGETYPE", (String)null);
    }

    public void setTimeToPurgeDeletes(long timeToPurgeDelete) {
        this.setAttribute("TIME_TO_PURGE_DELETES", Long.toString(timeToPurgeDelete));
    }

    public long getTimeToPurgeDeletes() {
        byte[] time = this.getAttribute("TIME_TO_PURGE_DELETES");
        return time == null ? 259200000L : Long.valueOf(Bytes.toString(time));
    }

    public Long getTimeToPurgeDeletesNoDefault() {
        byte[] time = this.getAttribute("TIME_TO_PURGE_DELETES");
        return time == null ? null : Long.valueOf(Bytes.toString(time));
    }

    public void setInMemory(boolean inMemory) {
        this.setAttribute("IN_MEMORY", Boolean.toString(inMemory));
    }

    public boolean isInMemory() {
        byte[] inMemory = this.getAttribute("IN_MEMORY");
        return inMemory == null ? false : Boolean.valueOf(Bytes.toString(inMemory));
    }

    public Boolean isInMemoryNoDefault() {
        byte[] inMemory = this.getAttribute("IN_MEMORY");
        return inMemory == null ? null : Boolean.valueOf(Bytes.toString(inMemory));
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof FamilyAttributes)) {
            return false;
        }
        FamilyAttributes other = (FamilyAttributes)obj;
        return this.equalsAttributes(other);
    }

    static {
        HashSet<String> tmp = new HashSet<String>(64);
        tmp.add("BLOOMFILTER");
        tmp.add("MEMSTORE_FILTER");
        tmp.add("COMPRESSION");
        tmp.add("COMPACTION_COMPRESSION_LEVEL");
        tmp.add("DATA_BLOCK_ENCODING");
        tmp.add("STORAGETYPE");
        tmp.add("TTL");
        tmp.add("VERSIONS");
        tmp.add("MIN_VERSIONS");
        tmp.add("DFS_REPLICATION");
        tmp.add("TIME_TO_PURGE_DELETES");
        tmp.add("IN_MEMORY");
        ALL_FAMILY_ATTRIBUTE_KEYS = Collections.unmodifiableSet(tmp);
    }
}

