/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.meta;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.Bytes;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LDRegionInfo
extends VersionedObjectWithAttributes
implements Comparable<LDRegionInfo> {
    private long regionId = -1L;
    private byte[] regionName = Bytes.EMPTY_BYTE_ARRAY;
    private byte[] tableName = null;
    private String encodedName = "";
    private byte[] encodedNameAsBytes = null;
    private String regionNameStr = "";
    private byte[] startKey = Bytes.EMPTY_BYTE_ARRAY;
    private byte[] endKey = Bytes.EMPTY_BYTE_ARRAY;
    private static final String HASH_ATTRIBUTE_KEY = "HASHTABLE";
    private boolean offLine = false;
    private boolean split = false;
    private int hashCode = -1;

    public LDRegionInfo() {
    }

    public LDRegionInfo(long regionId, byte[] regionName, byte[] tableName, boolean isInHashTable, String encodedName, byte[] startKey, byte[] endKey, boolean offLine, boolean split, int hashCode) {
        this.regionId = regionId;
        this.regionName = regionName;
        this.tableName = tableName;
        this.encodedName = encodedName;
        this.startKey = startKey;
        this.endKey = endKey;
        this.offLine = offLine;
        this.split = split;
        this.hashCode = hashCode;
        if (isInHashTable) {
            this.setAttribute(HASH_ATTRIBUTE_KEY, Bytes.toBytes(true));
        }
    }

    public boolean isInHashTable() {
        byte[] val = this.getAttribute(HASH_ATTRIBUTE_KEY, Bytes.toBytes(false));
        return Bytes.toBoolean(val);
    }

    public boolean containsRange(byte[] rangeStartKey, byte[] rangeEndKey) {
        if (Bytes.compareTo(rangeStartKey, rangeEndKey) > 0) {
            throw new IllegalArgumentException("Invalid range: " + Bytes.toStringBinary(rangeStartKey) + " > " + Bytes.toStringBinary(rangeEndKey));
        }
        boolean firstKeyInRange = Bytes.compareTo(rangeStartKey, this.startKey) >= 0;
        boolean lastKeyInRange = Bytes.compareTo(rangeEndKey, this.endKey) < 0 || Bytes.equals(this.endKey, Bytes.EMPTY_BYTE_ARRAY);
        return firstKeyInRange && lastKeyInRange;
    }

    public boolean containsRegion(byte[] regionStartKey, byte[] regionEndKey) {
        if (!Bytes.equals(regionEndKey, Bytes.EMPTY_BYTE_ARRAY) && Bytes.compareTo(regionStartKey, regionEndKey) > 0) {
            throw new IllegalArgumentException("Invalid range: " + Bytes.toStringBinary(regionStartKey) + " > " + Bytes.toStringBinary(regionEndKey));
        }
        boolean firstKeyInRange = Bytes.compareTo(regionStartKey, this.startKey) >= 0;
        boolean lastKeyInRange = false;
        lastKeyInRange = Bytes.compareTo(regionEndKey, this.endKey) <= 0 && !Bytes.equals(regionEndKey, Bytes.EMPTY_BYTE_ARRAY) || Bytes.equals(this.endKey, Bytes.EMPTY_BYTE_ARRAY);
        return firstKeyInRange && lastKeyInRange;
    }

    public boolean containsRow(byte[] row) {
        return Bytes.compareTo(row, this.startKey) >= 0 && (Bytes.compareTo(row, this.endKey) < 0 || Bytes.equals(this.endKey, Bytes.EMPTY_BYTE_ARRAY));
    }

    @Override
    public String toString() {
        return "{NAME => '" + this.regionNameStr + "', STARTKEY => '" + Bytes.toStringBinary(this.startKey) + "', ENDKEY => '" + Bytes.toStringBinary(this.endKey) + "', ENCODED => " + this.getEncodedName() + "," + (this.isOffLine() ? " OFFLINE => true," : "") + (this.isSplit() ? " SPLIT => true," : "") + "}";
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public int compareTo(LDRegionInfo o) {
        if (o == null) {
            return 1;
        }
        int result = Bytes.compareTo(this.tableName, o.tableName);
        if (result != 0) {
            return result;
        }
        result = Bytes.compareTo(this.startKey, o.startKey);
        if (result != 0) {
            return result;
        }
        result = Bytes.compareTo(this.endKey, o.endKey);
        if (result != 0) {
            if (this.getStartKey().length != 0 && this.getEndKey().length == 0) {
                return 1;
            }
            if (o.getStartKey().length != 0 && o.getEndKey().length == 0) {
                return -1;
            }
            return result;
        }
        if (this.regionId > o.regionId) {
            return 1;
        }
        if (this.regionId < o.regionId) {
            return -1;
        }
        if (this.offLine == o.offLine) {
            return 0;
        }
        if (this.offLine) {
            return -1;
        }
        return 1;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.regionId);
        Bytes.writeByteArray(out, this.regionName);
        Bytes.writeByteArray(out, this.tableName);
        out.writeUTF(this.encodedName);
        Bytes.writeByteArray(out, this.startKey);
        Bytes.writeByteArray(out, this.endKey);
        out.writeBoolean(this.offLine);
        out.writeBoolean(this.split);
        out.writeInt(this.hashCode);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.regionId = in.readLong();
        this.regionName = Bytes.readByteArray(in);
        this.regionNameStr = Bytes.toStringBinary(this.regionName);
        this.tableName = Bytes.readByteArray(in);
        this.encodedName = in.readUTF();
        this.encodedNameAsBytes = Bytes.toBytes(this.encodedName);
        this.startKey = Bytes.readByteArray(in);
        this.endKey = Bytes.readByteArray(in);
        this.offLine = in.readBoolean();
        this.split = in.readBoolean();
        this.hashCode = in.readInt();
    }

    public long getRegionId() {
        return this.regionId;
    }

    public void setRegionId(long regionId) {
        this.regionId = regionId;
    }

    public byte[] getRegionName() {
        return this.regionName;
    }

    public void setRegionName(byte[] regionName) {
        this.regionName = regionName;
    }

    public byte[] getTableName() {
        return this.tableName;
    }

    public void setTableName(byte[] tableName) {
        this.tableName = tableName;
    }

    public String getEncodedName() {
        return this.encodedName;
    }

    public void setEncodedName(String encodedName) {
        this.encodedName = encodedName;
    }

    public byte[] getEncodedNameAsBytes() {
        return this.encodedNameAsBytes;
    }

    public void setEncodedNameAsBytes(byte[] encodedNameAsBytes) {
        this.encodedNameAsBytes = encodedNameAsBytes;
    }

    public String getRegionNameStr() {
        return this.regionNameStr;
    }

    public void setRegionNameStr(String regionNameStr) {
        this.regionNameStr = regionNameStr;
    }

    public byte[] getStartKey() {
        return this.startKey;
    }

    public void setStartKey(byte[] startKey) {
        this.startKey = startKey;
    }

    public byte[] getEndKey() {
        return this.endKey;
    }

    public void setEndKey(byte[] endKey) {
        this.endKey = endKey;
    }

    public boolean isOffLine() {
        return this.offLine;
    }

    public void setOffLine(boolean offLine) {
        this.offLine = offLine;
    }

    public boolean isSplit() {
        return this.split;
    }

    public void setSplit(boolean split) {
        this.split = split;
    }

    public int getHashCode() {
        return this.hashCode;
    }

    public void setHashCode(int hashCode) {
        this.hashCode = hashCode;
    }
}

