/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.meta;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.meta.LDRegionInfo;
import com.alibaba.lindorm.client.core.meta.ServerName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LDRegionLocation
extends VersionedObjectWithAttributes {
    private LDRegionInfo regionInfo;
    private ServerName serverName;

    public LDRegionLocation() {
    }

    public LDRegionLocation(LDRegionInfo regionInfo, ServerName serverName) {
        this.regionInfo = regionInfo;
        this.serverName = serverName;
    }

    public LDRegionInfo getRegionInfo() {
        return this.regionInfo;
    }

    public ServerName getServerName() {
        return this.serverName;
    }

    public String getHostname() {
        if (this.serverName == null) {
            return null;
        }
        return this.serverName.getHostname();
    }

    public int getPort() {
        if (this.serverName == null) {
            return -1;
        }
        return this.serverName.getPort();
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        this.regionInfo.writeTo(out);
        if (this.serverName != null) {
            out.writeBoolean(true);
            this.serverName.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.regionInfo = new LDRegionInfo();
        this.regionInfo.readFrom(in);
        boolean hasServerName = in.readBoolean();
        if (hasServerName) {
            this.serverName = new ServerName();
            this.serverName.readFrom(in);
        }
    }

    @Override
    public String toString() {
        return "LDRegionLocation{regionInfo=" + this.regionInfo + ", serverName=" + this.serverName + "} " + super.toString();
    }
}

