/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.metrics;

import com.alibaba.lindorm.client.LindormClientConfig;
import com.alibaba.lindorm.client.annotions.DefaultAttributes;
import com.alibaba.lindorm.client.annotions.OptionalAttribute;
import com.alibaba.lindorm.client.core.ipc.CompatibleVersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.ipc.ConfigObserver;
import java.util.concurrent.atomic.AtomicLong;

public class PassiveMetrics
implements ConfigObserver {
    private boolean enabled = true;
    private PassiveMetricsSnapshot snapshot = null;
    private AtomicLong silenceRequestTotal = new AtomicLong(0L);
    private AtomicLong silenceRequestSilenced = new AtomicLong(0L);
    private AtomicLong silenceRequestThrown = new AtomicLong(0L);

    public void createSnapshot() {
        if (this.enabled) {
            PassiveMetricsSnapshot newSnapshot = new PassiveMetricsSnapshot();
            newSnapshot.silenceRequestTotal = this.silenceRequestTotal.getAndSet(0L);
            newSnapshot.silenceRequestSilenced = this.silenceRequestSilenced.getAndSet(0L);
            newSnapshot.silenceRequestThrown = this.silenceRequestThrown.getAndSet(0L);
            this.snapshot = newSnapshot;
        } else {
            this.snapshot = null;
        }
    }

    public PassiveMetricsSnapshot getSnapshot() {
        return this.snapshot;
    }

    public void onSilenceRequest(boolean hasError, boolean silenced) {
        if (!this.enabled) {
            return;
        }
        this.silenceRequestTotal.incrementAndGet();
        if (hasError) {
            if (silenced) {
                this.silenceRequestSilenced.incrementAndGet();
            } else {
                this.silenceRequestThrown.incrementAndGet();
            }
        }
    }

    public PassiveMetrics(LindormClientConfig config) {
        this.onConfigChange(config);
    }

    @Override
    public void onConfigChange(LindormClientConfig config) {
        this.enabled = config.getBoolean("lindorm.client.metrics.enabled", true);
    }

    public static class PassiveMetricsSnapshot
    extends CompatibleVersionedObjectWithAttributes {
        @DefaultAttributes.DefaultLong(value=0)
        @OptionalAttribute(attributeName="SRtotal")
        public long silenceRequestTotal;
        @DefaultAttributes.DefaultLong(value=0)
        @OptionalAttribute(attributeName="SRsilenced")
        public long silenceRequestSilenced;
        @DefaultAttributes.DefaultLong(value=0)
        @OptionalAttribute(attributeName="SRthrown")
        public long silenceRequestThrown;

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }
    }
}

