/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.utils;

import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.KeyHashFunction;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MsgDigestWrapper
extends KeyHashFunction {
    static final Log LOG = LogFactory.getLog(MsgDigestWrapper.class);
    final MessageDigest digest;

    public MsgDigestWrapper(String algorithm) throws NoSuchAlgorithmException {
        this.digest = MessageDigest.getInstance(algorithm);
    }

    @Override
    public byte[] computeHash(byte[] in, int inOffset, int inLen) {
        byte[] ret = new byte[8];
        if (in == null || inLen == 0) {
            return ret;
        }
        try {
            this.digest.update(in, inOffset, inLen);
            byte[] dbuffer = this.digest.digest();
            System.arraycopy(dbuffer, 0, ret, 0, ret.length);
            for (int i = ret.length; i < dbuffer.length; ++i) {
                int n = i % ret.length;
                ret[n] = (byte)(ret[n] ^ dbuffer[i]);
            }
            boolean allZero = true;
            for (byte v : ret) {
                if (v == 0) continue;
                allZero = false;
                break;
            }
            if (allZero) {
                return Bytes.toBytes(-1L);
            }
        }
        catch (Exception e) {
            this.digest.reset();
            LOG.error((Object)("Error computing hash key for " + Bytes.toStringBinary(in, inOffset, inLen)), (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }
}

