/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.widecolumnservice;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class WColumn
extends VersionedObjectWithAttributes {
    protected byte[] qualifier;
    protected byte[] value;
    protected long ts;
    protected Type type = Type.Put;
    protected byte[] family;

    public void setTs(long ts) {
        this.ts = ts;
    }

    public WColumn() {
    }

    public WColumn(byte[] family, byte[] qualifier, byte[] value) {
        this(family, qualifier, value, Long.MAX_VALUE, Type.Put);
    }

    public WColumn(byte[] family, byte[] qualifier, byte[] value, long ts) {
        this(family, qualifier, value, ts, Type.Put);
    }

    public WColumn(byte[] family, byte[] qualifier, byte[] value, long ts, Type type) {
        this.family = family;
        this.qualifier = qualifier;
        this.value = value;
        this.ts = ts;
        this.type = type;
    }

    public byte[] getQualifier() {
        return this.qualifier;
    }

    public long getTs() {
        return this.ts;
    }

    public byte[] getValue() {
        return this.value;
    }

    public byte[] getFamily() {
        return this.family;
    }

    public void setFamily(byte[] family) {
        this.family = family;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        Bytes.writeByteArray(out, this.qualifier);
        Bytes.writeByteArray(out, this.value);
        WritableUtils.writeVLong(out, this.ts);
        out.writeByte(this.type.getCode());
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.qualifier = Bytes.readByteArray(in);
        this.value = Bytes.readByteArray(in);
        this.ts = WritableUtils.readVLong(in);
        this.type = Type.codeToType(in.readByte());
    }

    public boolean isMatchingQualifier(byte[] qualifier) {
        return Bytes.equals(qualifier, this.qualifier);
    }

    public long getLength() {
        return (this.qualifier == null ? 0 : this.qualifier.length) + (this.value == null ? 0 : this.value.length) + 8 + 8;
    }

    public long getValueLength() {
        if (this.value == null) {
            return 0L;
        }
        return this.value.length;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(64);
        String familyStr = this.family == null ? "" : Bytes.toStringBinary(this.family);
        String qulifierStr = this.qualifier == null ? "" : Bytes.toStringBinary(this.qualifier);
        int vlen = this.value == null ? 0 : this.value.length;
        String timestampStr = WColumn.humanReadableTimestamp(this.ts);
        buffer.append(familyStr).append(":").append(qulifierStr).append("/").append(timestampStr).append("/").append((Object)this.type).append("/vlen=").append(vlen);
        return buffer.toString();
    }

    public static String humanReadableTimestamp(long timestamp) {
        if (timestamp == Long.MAX_VALUE) {
            return "LATEST_TIMESTAMP";
        }
        if (timestamp == Long.MIN_VALUE) {
            return "OLDEST_TIMESTAMP";
        }
        return String.valueOf(timestamp);
    }

    public boolean isDelete() {
        return Type.Delete.getCode() <= this.type.getCode() && this.type.getCode() <= Type.DeleteFamily.getCode();
    }

    public static enum Type {
        Minimum(0),
        Put(4),
        Delete(8),
        DeleteColumn(12),
        DeleteFamily(14),
        Maximum(-1);

        private final byte code;

        private Type(byte c) {
            this.code = c;
        }

        public byte getCode() {
            return this.code;
        }

        public static Type codeToType(byte b) {
            for (Type t : Type.values()) {
                if (t.getCode() != b) continue;
                return t;
            }
            throw new RuntimeException("Unknown code " + b);
        }
    }
}

