/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.widecolumnservice.filter;

import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WByteArrayComparable;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WCompareFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WFilter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class WDependentColumnFilter
extends WCompareFilter {
    protected byte[] columnFamily;
    protected byte[] columnQualifier;
    protected boolean dropDependentColumn;

    public WDependentColumnFilter() {
    }

    public WDependentColumnFilter(byte[] family, byte[] qualifier, boolean dropDependentColumn, WCompareFilter.CompareOp valueCompareOp, WByteArrayComparable valueComparator) {
        super(valueCompareOp, valueComparator);
        this.columnFamily = family;
        this.columnQualifier = qualifier;
        this.dropDependentColumn = dropDependentColumn;
    }

    public WDependentColumnFilter(byte[] family, byte[] qualifier) {
        this(family, qualifier, false);
    }

    public WDependentColumnFilter(byte[] family, byte[] qualifier, boolean dropDependentColumn) {
        this(family, qualifier, dropDependentColumn, WCompareFilter.CompareOp.NO_OP, null);
    }

    public byte[] getFamily() {
        return this.columnFamily;
    }

    public byte[] getQualifier() {
        return this.columnQualifier;
    }

    public boolean dropDependentColumn() {
        return this.dropDependentColumn;
    }

    public boolean getDropDependentColumn() {
        return this.dropDependentColumn;
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.columnFamily = Bytes.readByteArray(in);
        if (this.columnFamily.length == 0) {
            this.columnFamily = null;
        }
        this.columnQualifier = Bytes.readByteArray(in);
        if (this.columnQualifier.length == 0) {
            this.columnQualifier = null;
        }
        this.dropDependentColumn = in.readBoolean();
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        Bytes.writeByteArray(out, this.columnFamily);
        Bytes.writeByteArray(out, this.columnQualifier);
        out.writeBoolean(this.dropDependentColumn);
    }

    @Override
    public WFilter.Type getType() {
        return WFilter.Type.WDependentColumnFilter;
    }

    @Override
    public String toString() {
        return String.format("%s (%s, %s, %s, %s, %s)", this.getClass().getSimpleName(), Bytes.toStringBinary(this.columnFamily), Bytes.toStringBinary(this.columnQualifier), this.dropDependentColumn, this.compareOp.name(), Bytes.toStringBinary(this.comparator.getValue()));
    }
}

