/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.exporter;

import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public enum ExporterLogState {
    WRITING(1),
    CLOSED(9);

    private int code;

    private ExporterLogState() {
    }

    private ExporterLogState(int c) {
        this.code = c;
    }

    public int getCode() {
        return this.code;
    }

    public byte[] getCodeInBytes() {
        return Bytes.toBytes(this.code);
    }

    public static ExporterLogState codeToState(int b) {
        for (ExporterLogState s : ExporterLogState.values()) {
            if (s.getCode() != b) continue;
            return s;
        }
        throw new RuntimeException("Unknown code " + b);
    }

    public void writeTo(DataOutput out) throws IOException {
        WritableUtils.writeVInt(out, this.code);
    }

    public void readFrom(DataInput in) throws IOException {
        this.code = WritableUtils.readVInt(in);
    }
}

