/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.schema;

import com.alibaba.lindorm.client.core.meta.FamilyAttributes;
import com.alibaba.lindorm.client.core.meta.TableAttributes;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.schema.Mutability;
import java.util.concurrent.TimeUnit;

public abstract class DescriptorAttributes {
    protected FamilyAttributes familyAttributes = new FamilyAttributes();
    protected TableAttributes tableAttributes = new TableAttributes();

    public boolean isDynamicColumnsEnabled() {
        return this.tableAttributes.isDynamicColumnsEnabled();
    }

    public void setDynamicColumnsEnabled(boolean enabled) {
        this.tableAttributes.setDynamicColumnsEnabled(enabled);
    }

    public void setGlitchTimeout(int timeout) {
        this.tableAttributes.setGlitchTimeout(timeout);
    }

    public int getGlitchTimeout() {
        return this.tableAttributes.getGlitchTimeout();
    }

    public void setWriteGlitchTimeout(int timeout) {
        this.tableAttributes.setWriteGlitchTimeout(timeout);
    }

    public int getWriteGlitchTimeout() {
        return this.tableAttributes.getWriteGlitchTimeout();
    }

    public void setReadGlitchTimeout(int timeout) {
        this.tableAttributes.setReadGlitchTimeout(timeout);
    }

    public int getReadGlitchTimeout() {
        return this.tableAttributes.getReadGlitchTimeout();
    }

    public void setMutability(Mutability mutability) {
        this.tableAttributes.setMutability(mutability);
    }

    public Mutability getMutability() {
        return this.tableAttributes.getMutability();
    }

    public void setUsingHashEngine(boolean enableHash) {
        this.tableAttributes.setUsingHashEngine(enableHash);
    }

    public boolean isHashTable() {
        return this.tableAttributes.isHashTable();
    }

    public void setLeaderBalance(boolean enabled) throws IllegalArgumentException {
        if (this.tableAttributes.getConsistencyType() != TableAttributes.ConsistencyType.Strong) {
            throw new IllegalArgumentException("Leader balance attributes should only be set on a strong consistent table, current type: " + (Object)((Object)this.tableAttributes.getConsistencyType()));
        }
        this.tableAttributes.setLeaderBalance(enabled);
    }

    public boolean isLeaderBalanceEnabled() throws IllegalArgumentException {
        if (this.tableAttributes.getConsistencyType() != TableAttributes.ConsistencyType.Strong) {
            throw new IllegalArgumentException("Leader balance attributes should only be checked on a strong consistent table, current type: " + (Object)((Object)this.tableAttributes.getConsistencyType()));
        }
        return this.tableAttributes.isLeaderBalanceEnabled();
    }

    public DescriptorAttributes setBloomFilterType(String bloomFilter) {
        this.familyAttributes.setBloomFilterType(bloomFilter);
        return this;
    }

    public String getBloomFilterType() {
        return this.familyAttributes.getBloomFilterType();
    }

    public DescriptorAttributes setCompression(String compression) {
        this.familyAttributes.setCompression(compression);
        return this;
    }

    public String getCompression() {
        return this.familyAttributes.getCompression();
    }

    public DescriptorAttributes setCompactionCompressionLevel(short level) {
        this.familyAttributes.setCompactionCompressionLevel(level);
        return this;
    }

    public short getCompactionCompressionLevel() {
        return this.familyAttributes.getCompactionCompressionLevel();
    }

    public DescriptorAttributes setDataBlockEncoding(String encoding) {
        this.familyAttributes.setDataBlockEncoding(encoding);
        return this;
    }

    public String getDataBlockEncoding() {
        return this.familyAttributes.getDataBlockEncoding();
    }

    public DescriptorAttributes setDfsReplication(short dfsReplication) {
        this.familyAttributes.setDfsReplication(dfsReplication);
        return this;
    }

    public short getDfsReplication() {
        return this.familyAttributes.getDfsReplication();
    }

    public DescriptorAttributes setStorageType(String storageType) {
        this.familyAttributes.setStorageType(storageType);
        return this;
    }

    public String getStorageType() {
        return this.familyAttributes.getStorageType();
    }

    public DescriptorAttributes setConsistencyType(TableAttributes.ConsistencyType consistencyType) {
        this.tableAttributes.setConsistencyType(consistencyType);
        return this;
    }

    public TableAttributes.ConsistencyType getConsistencyType() {
        return this.tableAttributes.getConsistencyType();
    }

    public DescriptorAttributes setRefSplitAllowed(boolean enable) {
        this.tableAttributes.setRefSplitAllowed(enable);
        return this;
    }

    public boolean isRefSplitAllowed() {
        Boolean allowed = this.tableAttributes.isRefSplitAllowed();
        return allowed == null ? false : allowed;
    }

    public DescriptorAttributes setMaxPkColumnLength(int maxPkColumnLength) {
        this.tableAttributes.setMaxPkColumnLength(maxPkColumnLength);
        return this;
    }

    public int getMaxPkColumnLength() {
        return this.tableAttributes.getMaxPkColumnLength();
    }

    public DescriptorAttributes setMaxNonPkColumnLength(int maxNonPkColumnLength) {
        this.tableAttributes.setMaxNonPkColumnLength(maxNonPkColumnLength);
        return this;
    }

    public int getMaxNonPkColumnLength() {
        return this.tableAttributes.getMaxNonPkColumnLength();
    }

    public DescriptorAttributes setDeferredLogFlush(boolean defer) {
        this.tableAttributes.setDeferredLogFlush(defer);
        return this;
    }

    public boolean isDeferredLogFlush() {
        return this.tableAttributes.isDeferredLogFlush();
    }

    public DescriptorAttributes setTimeToLive(int ttl, TimeUnit unit) {
        int seconds = (int)unit.toSeconds(ttl);
        this.familyAttributes.setTimeToLive(seconds);
        return this;
    }

    public int getTimeToLive() {
        return this.familyAttributes.getTimeToLive();
    }

    public DescriptorAttributes setMaxVersions(int maxVersions) {
        this.familyAttributes.setMaxVersions(maxVersions);
        return this;
    }

    public int getMaxVersions() {
        return this.familyAttributes.getMaxVersions();
    }

    public DescriptorAttributes setMinVersions(int minVersions) {
        this.familyAttributes.setMinVersions(minVersions);
        return this;
    }

    public int getMinVersions() {
        return this.familyAttributes.getMinVersions();
    }

    public DescriptorAttributes setMemstoreFilterType(String type) {
        this.familyAttributes.setMemStoreFilterType(type);
        return this;
    }

    public String getMemstoreFilterType() {
        return this.familyAttributes.getMemstoreFilterType();
    }

    public DescriptorAttributes setTimeToPurgeDeletes(long timeToPurgeDelete, TimeUnit unit) {
        long ms = unit.toMillis(timeToPurgeDelete);
        this.familyAttributes.setTimeToPurgeDeletes(ms);
        return this;
    }

    public long getTimeToPurgeDeletes() {
        return this.familyAttributes.getTimeToPurgeDeletes();
    }

    public DescriptorAttributes setInMemory(boolean inMemory) {
        this.familyAttributes.setInMemory(inMemory);
        return this;
    }

    public boolean isInMemory() {
        return this.familyAttributes.isInMemory();
    }

    public void setTableAttributes(String name, String value) {
        this.tableAttributes.setAttribute(name, value);
    }

    public void setFamilyAttributes(String name, String value) {
        this.familyAttributes.setAttribute(name, value);
    }

    public FamilyAttributes getFamilyAttributes() {
        return this.familyAttributes;
    }

    public abstract void setFamilyAttributes(byte[] var1, String var2, String var3) throws IllegalRequestException;

    public TableAttributes getTableAttributes() {
        return this.tableAttributes;
    }

    public void setFamilyAttributes(FamilyAttributes familyAttributes) {
        this.familyAttributes = familyAttributes;
    }

    public DescriptorAttributes setTableAttributes(TableAttributes tableAttributes) {
        this.tableAttributes = tableAttributes;
        return this;
    }
}

