/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.schema;

import com.alibaba.lindorm.client.core.meta.TableAttributes;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.FeedStreamUtils;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.schema.ColumnFamilyDescriptor;
import com.alibaba.lindorm.client.schema.DescriptorAttributes;
import java.util.concurrent.TimeUnit;

public class LindormPipeDescriptor
extends DescriptorAttributes {
    private String pipeName = null;
    private boolean idempotentEnabled = false;
    private int messageTTL = Integer.MAX_VALUE;
    private int idempotentWindow = 86400;
    private ColumnFamilyDescriptor valueFamilyDescriptor = null;
    private ColumnFamilyDescriptor idempotentFamilyDescriptor = null;
    private ColumnFamilyDescriptor sequenceFamilyDescriptor = null;

    public LindormPipeDescriptor() {
        this.init();
    }

    public LindormPipeDescriptor(String name) {
        this.pipeName = name;
        this.init();
    }

    private void init() {
        this.tableAttributes.setConsistencyType(TableAttributes.ConsistencyType.Strong);
        ColumnFamilyDescriptor cfd = new ColumnFamilyDescriptor(FeedStreamUtils.VALUE_FAMILY_NAME_BYTES);
        this.valueFamilyDescriptor = FeedStreamUtils.updateValueFamilyDescriptor(cfd);
        cfd = new ColumnFamilyDescriptor(FeedStreamUtils.SEQUENCE_FAMILY_NAME_BYTES);
        this.sequenceFamilyDescriptor = FeedStreamUtils.updateSequenceFamilyDescriptor(cfd);
        this.sequenceFamilyDescriptor.setTimeToLive(Integer.MAX_VALUE, TimeUnit.SECONDS);
        cfd = new ColumnFamilyDescriptor(FeedStreamUtils.IDEMPOTENT_FAMILY_NAME_BYTES);
        this.idempotentFamilyDescriptor = FeedStreamUtils.updateIdempotentFamilyDescriptor(cfd);
    }

    public LindormPipeDescriptor setName(String name) {
        this.pipeName = name;
        return this;
    }

    public String getName() {
        return this.pipeName;
    }

    public LindormPipeDescriptor setIdempotentEnabled(boolean enabled) {
        this.idempotentEnabled = enabled;
        return this;
    }

    public boolean isIdempotentEnabled() {
        return this.idempotentEnabled;
    }

    public LindormPipeDescriptor setMessageTTL(int ttl) {
        this.messageTTL = ttl;
        return this;
    }

    public int getMessageTTL() {
        return this.messageTTL;
    }

    public LindormPipeDescriptor setIdempotentWindow(int window) {
        this.idempotentWindow = window;
        return this;
    }

    public int getIdempotentWindow() {
        return this.idempotentWindow;
    }

    public ColumnFamilyDescriptor getValueFamilyDescriptor() {
        return this.valueFamilyDescriptor;
    }

    public LindormPipeDescriptor setValueFamilyDescriptor(ColumnFamilyDescriptor cfd) throws IllegalRequestException {
        FeedStreamUtils.validateFamilyName(cfd.getNameAsString(), this.valueFamilyDescriptor.getNameAsString());
        this.valueFamilyDescriptor = FeedStreamUtils.updateValueFamilyDescriptor(cfd);
        return this;
    }

    public ColumnFamilyDescriptor getIdempotentFamilyDescriptor() {
        return this.idempotentFamilyDescriptor;
    }

    public LindormPipeDescriptor setIdempotentFamilyDescriptor(ColumnFamilyDescriptor cfd) throws IllegalRequestException {
        FeedStreamUtils.validateFamilyName(cfd.getNameAsString(), this.idempotentFamilyDescriptor.getNameAsString());
        this.idempotentFamilyDescriptor = FeedStreamUtils.updateIdempotentFamilyDescriptor(cfd);
        return this;
    }

    public ColumnFamilyDescriptor getSequenceFamilyDescriptor() {
        return this.sequenceFamilyDescriptor;
    }

    public LindormPipeDescriptor setSequenceFamilyDescriptor(ColumnFamilyDescriptor cfd) throws IllegalRequestException {
        FeedStreamUtils.validateFamilyName(cfd.getNameAsString(), this.sequenceFamilyDescriptor.getNameAsString());
        this.sequenceFamilyDescriptor = FeedStreamUtils.updateSequenceFamilyDescriptor(cfd);
        this.sequenceFamilyDescriptor.setTimeToLive(Integer.MAX_VALUE, TimeUnit.SECONDS);
        return this;
    }

    @Override
    public void setFamilyAttributes(byte[] familyName, String name, String value) throws IllegalRequestException {
        ColumnFamilyDescriptor cfd = null;
        if (Bytes.equals(familyName, this.valueFamilyDescriptor.getName())) {
            cfd = this.valueFamilyDescriptor;
        } else if (Bytes.equals(familyName, this.sequenceFamilyDescriptor.getName())) {
            if (name.equals("TTL")) {
                throw new IllegalRequestException("Sequence family TTL is set to forever by default, and should not be modified");
            }
            cfd = this.sequenceFamilyDescriptor;
        } else if (Bytes.equals(familyName, this.idempotentFamilyDescriptor.getName())) {
            if (!this.idempotentEnabled) {
                throw new IllegalRequestException("Idempotent is not set to enabled for pipe " + this.pipeName);
            }
            cfd = this.idempotentFamilyDescriptor;
        }
        if (cfd == null) {
            throw new IllegalRequestException("Unknown family name " + Bytes.toStringBinary(familyName));
        }
        cfd.getFamilyAttributes().setAttribute(name, value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LindormPipeDescriptor)) {
            return false;
        }
        String otherPipeName = ((LindormPipeDescriptor)obj).pipeName;
        return this.pipeName.equals(otherPipeName);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("Pipe [");
        str.append(this.pipeName);
        str.append("], idempotent=");
        str.append(this.idempotentEnabled);
        str.append(", valueFamily=");
        str.append(this.valueFamilyDescriptor.toString());
        str.append(", sequenceFamily=");
        str.append(this.sequenceFamilyDescriptor.toString());
        if (this.idempotentEnabled) {
            str.append(", idempotentFamily=");
            str.append(this.idempotentFamilyDescriptor.toString());
        }
        str.append(", tableAttributes=");
        str.append(this.tableAttributes.toString());
        return str.toString();
    }
}

