/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.com.esri.core.geometry;

import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.AttributeStreamOfInt32;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.BucketSort;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.ClassicSort;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.Envelope2D;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.GeometryException;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.IndexMultiDCList;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.IntervalTreeImpl;
import java.util.ArrayList;

class Envelope2DIntersectorImpl {
    private double m_tolerance = 0.0;
    private int m_sweep_index_red;
    private int m_sweep_index_blue;
    private int m_envelope_handle_a;
    private int m_envelope_handle_b;
    private IntervalTreeImpl m_interval_tree_red;
    private IntervalTreeImpl m_interval_tree_blue;
    private IntervalTreeImpl.IntervalTreeIteratorImpl m_iterator_red;
    private IntervalTreeImpl.IntervalTreeIteratorImpl m_iterator_blue;
    private Envelope2D m_envelope_helper = new Envelope2D();
    private ArrayList<Envelope2D> m_envelopes_red;
    private ArrayList<Envelope2D> m_envelopes_blue;
    private AttributeStreamOfInt32 m_elements_red;
    private AttributeStreamOfInt32 m_elements_blue;
    private AttributeStreamOfInt32 m_sorted_end_indices_red;
    private AttributeStreamOfInt32 m_sorted_end_indices_blue;
    private int m_queued_list_red;
    private int m_queued_list_blue;
    private IndexMultiDCList m_queued_envelopes;
    private AttributeStreamOfInt32 m_queued_indices_red;
    private AttributeStreamOfInt32 m_queued_indices_blue;
    private boolean m_b_add_red;
    private boolean m_b_add_blue;
    private boolean m_b_add_red_red;
    private boolean m_b_done;
    private int m_function = -1;
    private BucketSort m_bucket_sort;

    Envelope2DIntersectorImpl() {
        this.reset_();
    }

    void startConstruction() {
        this.reset_();
        this.m_b_add_red_red = true;
        if (this.m_envelopes_red == null) {
            this.m_elements_red = new AttributeStreamOfInt32(0);
            this.m_envelopes_red = new ArrayList(0);
        } else {
            this.m_elements_red.resizePreserveCapacity(0);
            this.m_envelopes_red.clear();
        }
    }

    void addEnvelope(int element, Envelope2D envelope) {
        if (!this.m_b_add_red_red) {
            throw new GeometryException("invalid call");
        }
        Envelope2D e = new Envelope2D();
        e.setCoords(envelope);
        this.m_elements_red.add(element);
        this.m_envelopes_red.add(e);
    }

    void endConstruction() {
        if (!this.m_b_add_red_red) {
            throw new GeometryException("invalid call");
        }
        this.m_b_add_red_red = false;
        if (this.m_envelopes_red != null && this.m_envelopes_red.size() > 0) {
            this.m_function = 0;
            this.m_b_done = false;
        }
    }

    void startRedConstruction() {
        this.reset_();
        this.m_b_add_red = true;
        if (this.m_envelopes_red == null) {
            this.m_elements_red = new AttributeStreamOfInt32(0);
            this.m_envelopes_red = new ArrayList(0);
        } else {
            this.m_elements_red.resizePreserveCapacity(0);
            this.m_envelopes_red.clear();
        }
    }

    void addRedEnvelope(int element, Envelope2D red_envelope) {
        if (!this.m_b_add_red) {
            throw new GeometryException("invalid call");
        }
        Envelope2D e = new Envelope2D();
        e.setCoords(red_envelope);
        this.m_elements_red.add(element);
        this.m_envelopes_red.add(e);
    }

    void endRedConstruction() {
        if (!this.m_b_add_red) {
            throw new GeometryException("invalid call");
        }
        this.m_b_add_red = false;
        if (this.m_envelopes_red != null && this.m_envelopes_red.size() > 0 && this.m_envelopes_blue != null && this.m_envelopes_blue.size() > 0) {
            if (this.m_function == -1) {
                this.m_function = 3;
            } else if (this.m_function == 2) {
                this.m_function = 3;
            } else if (this.m_function != 3) {
                this.m_function = 1;
            }
            this.m_b_done = false;
        }
    }

    void startBlueConstruction() {
        this.reset_();
        this.m_b_add_blue = true;
        if (this.m_envelopes_blue == null) {
            this.m_elements_blue = new AttributeStreamOfInt32(0);
            this.m_envelopes_blue = new ArrayList(0);
        } else {
            this.m_elements_blue.resizePreserveCapacity(0);
            this.m_envelopes_blue.clear();
        }
    }

    void addBlueEnvelope(int element, Envelope2D blue_envelope) {
        if (!this.m_b_add_blue) {
            throw new GeometryException("invalid call");
        }
        Envelope2D e = new Envelope2D();
        e.setCoords(blue_envelope);
        this.m_elements_blue.add(element);
        this.m_envelopes_blue.add(e);
    }

    void endBlueConstruction() {
        if (!this.m_b_add_blue) {
            throw new GeometryException("invalid call");
        }
        this.m_b_add_blue = false;
        if (this.m_envelopes_red != null && this.m_envelopes_red.size() > 0 && this.m_envelopes_blue != null && this.m_envelopes_blue.size() > 0) {
            if (this.m_function == -1) {
                this.m_function = 3;
            } else if (this.m_function == 1) {
                this.m_function = 3;
            } else if (this.m_function != 3) {
                this.m_function = 2;
            }
            this.m_b_done = false;
        }
    }

    boolean next() {
        if (this.m_b_done) {
            return false;
        }
        boolean b_searching = true;
        block19: while (b_searching) {
            switch (this.m_function) {
                case 0: {
                    b_searching = this.initialize_();
                    continue block19;
                }
                case 1: {
                    b_searching = this.initializeRed_();
                    continue block19;
                }
                case 2: {
                    b_searching = this.initializeBlue_();
                    continue block19;
                }
                case 3: {
                    b_searching = this.initializeRedBlue_();
                    continue block19;
                }
                case 4: {
                    b_searching = this.sweep_();
                    continue block19;
                }
                case 5: {
                    b_searching = this.sweepBruteForce_();
                    continue block19;
                }
                case 6: {
                    b_searching = this.sweepRedBlueBruteForce_();
                    continue block19;
                }
                case 7: {
                    b_searching = this.sweepRedBlue_();
                    continue block19;
                }
                case 8: {
                    b_searching = this.sweepRed_();
                    continue block19;
                }
                case 9: {
                    b_searching = this.sweepBlue_();
                    continue block19;
                }
                case 10: {
                    b_searching = this.iterate_();
                    continue block19;
                }
                case 11: {
                    b_searching = this.iterateRed_();
                    continue block19;
                }
                case 12: {
                    b_searching = this.iterateBlue_();
                    continue block19;
                }
                case 13: {
                    b_searching = this.iterateBruteForce_();
                    continue block19;
                }
                case 14: {
                    b_searching = this.iterateRedBlueBruteForce_();
                    continue block19;
                }
                case 15: {
                    b_searching = this.resetRed_();
                    continue block19;
                }
                case 16: {
                    b_searching = this.resetBlue_();
                    continue block19;
                }
            }
            throw GeometryException.GeometryInternalError();
        }
        return !this.m_b_done;
    }

    int getHandleA() {
        return this.m_envelope_handle_a;
    }

    int getHandleB() {
        return this.m_envelope_handle_b;
    }

    void setTolerance(double tolerance) {
        this.m_tolerance = tolerance;
    }

    Envelope2D getEnvelope(int handle) {
        return this.m_envelopes_red.get(handle);
    }

    int getElement(int handle) {
        return this.m_elements_red.read(handle);
    }

    Envelope2D getRedEnvelope(int handle_a) {
        return this.m_envelopes_red.get(handle_a);
    }

    Envelope2D getBlueEnvelope(int handle_b) {
        return this.m_envelopes_blue.get(handle_b);
    }

    int getRedElement(int handle_a) {
        return this.m_elements_red.read(handle_a);
    }

    int getBlueElement(int handle_b) {
        return this.m_elements_blue.read(handle_b);
    }

    private static boolean isTop_(int y_end_point_handle) {
        return (y_end_point_handle & 1) == 1;
    }

    private static boolean isBottom_(int y_end_point_handle) {
        return (y_end_point_handle & 1) == 0;
    }

    private void reset_() {
        this.m_b_add_red = false;
        this.m_b_add_blue = false;
        this.m_b_add_red_red = false;
        this.m_sweep_index_red = -1;
        this.m_sweep_index_blue = -1;
        this.m_queued_list_red = -1;
        this.m_queued_list_blue = -1;
        this.m_b_done = true;
    }

    private boolean initialize_() {
        this.m_envelope_handle_a = -1;
        this.m_envelope_handle_b = -1;
        if (this.m_envelopes_red.size() < 10) {
            this.m_sweep_index_red = this.m_envelopes_red.size();
            this.m_function = 5;
            return true;
        }
        if (this.m_interval_tree_red == null) {
            this.m_interval_tree_red = new IntervalTreeImpl(true);
            this.m_sorted_end_indices_red = new AttributeStreamOfInt32(0);
        }
        this.m_interval_tree_red.addEnvelopesRef(this.m_envelopes_red);
        if (this.m_iterator_red == null) {
            this.m_iterator_red = this.m_interval_tree_red.getIterator();
        }
        this.m_sorted_end_indices_red.reserve(2 * this.m_envelopes_red.size());
        this.m_sorted_end_indices_red.resize(0);
        for (int i = 0; i < 2 * this.m_envelopes_red.size(); ++i) {
            this.m_sorted_end_indices_red.add(i);
        }
        this.sortYEndIndices_(this.m_sorted_end_indices_red, 0, 2 * this.m_envelopes_red.size(), true);
        this.m_sweep_index_red = 2 * this.m_envelopes_red.size();
        this.m_function = 4;
        return true;
    }

    private boolean initializeRed_() {
        this.m_envelope_handle_a = -1;
        this.m_envelope_handle_b = -1;
        if (this.m_envelopes_red.size() < 10 || this.m_envelopes_blue.size() < 10) {
            this.m_sweep_index_red = this.m_envelopes_red.size();
            this.m_function = 6;
            return true;
        }
        if (this.m_interval_tree_red == null) {
            this.m_interval_tree_red = new IntervalTreeImpl(true);
            this.m_sorted_end_indices_red = new AttributeStreamOfInt32(0);
        }
        this.m_interval_tree_red.addEnvelopesRef(this.m_envelopes_red);
        if (this.m_iterator_red == null) {
            this.m_iterator_red = this.m_interval_tree_red.getIterator();
        }
        this.m_sorted_end_indices_red.reserve(2 * this.m_envelopes_red.size());
        this.m_sorted_end_indices_red.resize(0);
        for (int i = 0; i < 2 * this.m_envelopes_red.size(); ++i) {
            this.m_sorted_end_indices_red.add(i);
        }
        this.sortYEndIndices_(this.m_sorted_end_indices_red, 0, this.m_sorted_end_indices_red.size(), true);
        this.m_sweep_index_red = this.m_sorted_end_indices_red.size();
        if (this.m_queued_list_red != -1) {
            this.m_queued_envelopes.deleteList(this.m_queued_list_red);
            this.m_queued_indices_red.resize(0);
            this.m_queued_list_red = -1;
        }
        this.m_function = 7;
        return this.resetBlue_();
    }

    private boolean initializeBlue_() {
        this.m_envelope_handle_a = -1;
        this.m_envelope_handle_b = -1;
        if (this.m_envelopes_red.size() < 10 || this.m_envelopes_blue.size() < 10) {
            this.m_sweep_index_red = this.m_envelopes_red.size();
            this.m_function = 6;
            return true;
        }
        if (this.m_interval_tree_blue == null) {
            this.m_interval_tree_blue = new IntervalTreeImpl(true);
            this.m_sorted_end_indices_blue = new AttributeStreamOfInt32(0);
        }
        this.m_interval_tree_blue.addEnvelopesRef(this.m_envelopes_blue);
        if (this.m_iterator_blue == null) {
            this.m_iterator_blue = this.m_interval_tree_blue.getIterator();
        }
        this.m_sorted_end_indices_blue.reserve(2 * this.m_envelopes_blue.size());
        this.m_sorted_end_indices_blue.resize(0);
        for (int i = 0; i < 2 * this.m_envelopes_blue.size(); ++i) {
            this.m_sorted_end_indices_blue.add(i);
        }
        this.sortYEndIndices_(this.m_sorted_end_indices_blue, 0, this.m_sorted_end_indices_blue.size(), false);
        this.m_sweep_index_blue = this.m_sorted_end_indices_blue.size();
        if (this.m_queued_list_blue != -1) {
            this.m_queued_envelopes.deleteList(this.m_queued_list_blue);
            this.m_queued_indices_blue.resize(0);
            this.m_queued_list_blue = -1;
        }
        this.m_function = 7;
        return this.resetRed_();
    }

    private boolean initializeRedBlue_() {
        int i;
        this.m_envelope_handle_a = -1;
        this.m_envelope_handle_b = -1;
        if (this.m_envelopes_red.size() < 10 || this.m_envelopes_blue.size() < 10) {
            this.m_sweep_index_red = this.m_envelopes_red.size();
            this.m_function = 6;
            return true;
        }
        if (this.m_interval_tree_red == null) {
            this.m_interval_tree_red = new IntervalTreeImpl(true);
            this.m_sorted_end_indices_red = new AttributeStreamOfInt32(0);
        }
        if (this.m_interval_tree_blue == null) {
            this.m_interval_tree_blue = new IntervalTreeImpl(true);
            this.m_sorted_end_indices_blue = new AttributeStreamOfInt32(0);
        }
        this.m_interval_tree_red.addEnvelopesRef(this.m_envelopes_red);
        this.m_interval_tree_blue.addEnvelopesRef(this.m_envelopes_blue);
        if (this.m_iterator_red == null) {
            this.m_iterator_red = this.m_interval_tree_red.getIterator();
        }
        if (this.m_iterator_blue == null) {
            this.m_iterator_blue = this.m_interval_tree_blue.getIterator();
        }
        this.m_sorted_end_indices_red.reserve(2 * this.m_envelopes_red.size());
        this.m_sorted_end_indices_blue.reserve(2 * this.m_envelopes_blue.size());
        this.m_sorted_end_indices_red.resize(0);
        this.m_sorted_end_indices_blue.resize(0);
        for (i = 0; i < 2 * this.m_envelopes_red.size(); ++i) {
            this.m_sorted_end_indices_red.add(i);
        }
        for (i = 0; i < 2 * this.m_envelopes_blue.size(); ++i) {
            this.m_sorted_end_indices_blue.add(i);
        }
        this.sortYEndIndices_(this.m_sorted_end_indices_red, 0, this.m_sorted_end_indices_red.size(), true);
        this.sortYEndIndices_(this.m_sorted_end_indices_blue, 0, this.m_sorted_end_indices_blue.size(), false);
        this.m_sweep_index_red = this.m_sorted_end_indices_red.size();
        this.m_sweep_index_blue = this.m_sorted_end_indices_blue.size();
        if (this.m_queued_list_red != -1) {
            this.m_queued_envelopes.deleteList(this.m_queued_list_red);
            this.m_queued_indices_red.resize(0);
            this.m_queued_list_red = -1;
        }
        if (this.m_queued_list_blue != -1) {
            this.m_queued_envelopes.deleteList(this.m_queued_list_blue);
            this.m_queued_indices_blue.resize(0);
            this.m_queued_list_blue = -1;
        }
        this.m_function = 7;
        return true;
    }

    private boolean sweep_() {
        int y_end_point_handle = this.m_sorted_end_indices_red.get(--this.m_sweep_index_red);
        int envelope_handle = y_end_point_handle >> 1;
        if (Envelope2DIntersectorImpl.isBottom_(y_end_point_handle)) {
            this.m_interval_tree_red.remove(envelope_handle);
            if (this.m_sweep_index_red == 0) {
                this.m_envelope_handle_a = -1;
                this.m_envelope_handle_b = -1;
                this.m_b_done = true;
                return false;
            }
            return true;
        }
        this.m_iterator_red.resetIterator(this.m_envelopes_red.get((int)envelope_handle).xmin, this.m_envelopes_red.get((int)envelope_handle).xmax, this.m_tolerance);
        this.m_envelope_handle_a = envelope_handle;
        this.m_function = 10;
        return true;
    }

    private boolean sweepBruteForce_() {
        if (--this.m_sweep_index_red == -1) {
            this.m_envelope_handle_a = -1;
            this.m_envelope_handle_b = -1;
            this.m_b_done = true;
            return false;
        }
        this.m_envelope_handle_a = this.m_sweep_index_red;
        this.m_sweep_index_blue = this.m_sweep_index_red;
        this.m_function = 13;
        return true;
    }

    private boolean sweepRedBlueBruteForce_() {
        if (--this.m_sweep_index_red == -1) {
            this.m_envelope_handle_a = -1;
            this.m_envelope_handle_b = -1;
            this.m_b_done = true;
            return false;
        }
        this.m_envelope_handle_a = this.m_sweep_index_red;
        this.m_sweep_index_blue = this.m_envelopes_blue.size();
        this.m_function = 14;
        return true;
    }

    private boolean sweepRedBlue_() {
        double y_blue;
        int y_end_point_handle_red = this.m_sorted_end_indices_red.get(this.m_sweep_index_red - 1);
        int y_end_point_handle_blue = this.m_sorted_end_indices_blue.get(this.m_sweep_index_blue - 1);
        double y_red = this.getAdjustedValue_(y_end_point_handle_red, true);
        if (y_red > (y_blue = this.getAdjustedValue_(y_end_point_handle_blue, false))) {
            return this.sweepRed_();
        }
        if (y_red < y_blue) {
            return this.sweepBlue_();
        }
        if (Envelope2DIntersectorImpl.isTop_(y_end_point_handle_red)) {
            return this.sweepRed_();
        }
        if (Envelope2DIntersectorImpl.isTop_(y_end_point_handle_blue)) {
            return this.sweepBlue_();
        }
        return this.sweepRed_();
    }

    private boolean sweepRed_() {
        int y_end_point_handle_red = this.m_sorted_end_indices_red.get(--this.m_sweep_index_red);
        int envelope_handle_red = y_end_point_handle_red >> 1;
        if (Envelope2DIntersectorImpl.isBottom_(y_end_point_handle_red)) {
            if (this.m_queued_list_red != -1 && this.m_queued_indices_red.get(envelope_handle_red) != -1) {
                this.m_queued_envelopes.deleteElement(this.m_queued_list_red, this.m_queued_indices_red.get(envelope_handle_red));
                this.m_queued_indices_red.set(envelope_handle_red, -1);
            } else {
                this.m_interval_tree_red.remove(envelope_handle_red);
            }
            if (this.m_sweep_index_red == 0) {
                this.m_envelope_handle_a = -1;
                this.m_envelope_handle_b = -1;
                this.m_b_done = true;
                return false;
            }
            return true;
        }
        if (this.m_queued_list_blue != -1 && this.m_queued_envelopes.getListSize(this.m_queued_list_blue) > 0) {
            int node = this.m_queued_envelopes.getFirst(this.m_queued_list_blue);
            while (node != -1) {
                int e = this.m_queued_envelopes.getData(node);
                this.m_interval_tree_blue.insert(e);
                this.m_queued_indices_blue.set(e, -1);
                int next_node = this.m_queued_envelopes.getNext(node);
                this.m_queued_envelopes.deleteElement(this.m_queued_list_blue, node);
                node = next_node;
            }
        }
        if (this.m_interval_tree_blue.size() > 0) {
            this.m_iterator_blue.resetIterator(this.m_envelopes_red.get((int)envelope_handle_red).xmin, this.m_envelopes_red.get((int)envelope_handle_red).xmax, this.m_tolerance);
            this.m_envelope_handle_a = envelope_handle_red;
            this.m_function = 12;
        } else {
            if (this.m_queued_list_red == -1) {
                if (this.m_queued_envelopes == null) {
                    this.m_queued_envelopes = new IndexMultiDCList();
                }
                this.m_queued_indices_red = new AttributeStreamOfInt32(0);
                this.m_queued_indices_red.resize(this.m_envelopes_red.size(), -1.0);
                this.m_queued_indices_red.setRange(-1.0, 0, this.m_envelopes_red.size());
                this.m_queued_list_red = this.m_queued_envelopes.createList(1);
            }
            this.m_queued_indices_red.set(envelope_handle_red, this.m_queued_envelopes.addElement(this.m_queued_list_red, envelope_handle_red));
            this.m_function = 7;
        }
        return true;
    }

    private boolean sweepBlue_() {
        int y_end_point_handle_blue = this.m_sorted_end_indices_blue.get(--this.m_sweep_index_blue);
        int envelope_handle_blue = y_end_point_handle_blue >> 1;
        if (Envelope2DIntersectorImpl.isBottom_(y_end_point_handle_blue)) {
            if (this.m_queued_list_blue != -1 && this.m_queued_indices_blue.get(envelope_handle_blue) != -1) {
                this.m_queued_envelopes.deleteElement(this.m_queued_list_blue, this.m_queued_indices_blue.get(envelope_handle_blue));
                this.m_queued_indices_blue.set(envelope_handle_blue, -1);
            } else {
                this.m_interval_tree_blue.remove(envelope_handle_blue);
            }
            if (this.m_sweep_index_blue == 0) {
                this.m_envelope_handle_a = -1;
                this.m_envelope_handle_b = -1;
                this.m_b_done = true;
                return false;
            }
            return true;
        }
        if (this.m_queued_list_red != -1 && this.m_queued_envelopes.getListSize(this.m_queued_list_red) > 0) {
            int node = this.m_queued_envelopes.getFirst(this.m_queued_list_red);
            while (node != -1) {
                int e = this.m_queued_envelopes.getData(node);
                this.m_interval_tree_red.insert(e);
                this.m_queued_indices_red.set(e, -1);
                int next_node = this.m_queued_envelopes.getNext(node);
                this.m_queued_envelopes.deleteElement(this.m_queued_list_red, node);
                node = next_node;
            }
        }
        if (this.m_interval_tree_red.size() > 0) {
            this.m_iterator_red.resetIterator(this.m_envelopes_blue.get((int)envelope_handle_blue).xmin, this.m_envelopes_blue.get((int)envelope_handle_blue).xmax, this.m_tolerance);
            this.m_envelope_handle_b = envelope_handle_blue;
            this.m_function = 11;
        } else {
            if (this.m_queued_list_blue == -1) {
                if (this.m_queued_envelopes == null) {
                    this.m_queued_envelopes = new IndexMultiDCList();
                }
                this.m_queued_indices_blue = new AttributeStreamOfInt32(0);
                this.m_queued_indices_blue.resize(this.m_envelopes_blue.size(), -1.0);
                this.m_queued_indices_blue.setRange(-1.0, 0, this.m_envelopes_blue.size());
                this.m_queued_list_blue = this.m_queued_envelopes.createList(0);
            }
            this.m_queued_indices_blue.set(envelope_handle_blue, this.m_queued_envelopes.addElement(this.m_queued_list_blue, envelope_handle_blue));
            this.m_function = 7;
        }
        return true;
    }

    private boolean iterate_() {
        this.m_envelope_handle_b = this.m_iterator_red.next();
        if (this.m_envelope_handle_b != -1) {
            return false;
        }
        int envelope_handle = this.m_sorted_end_indices_red.get(this.m_sweep_index_red) >> 1;
        this.m_interval_tree_red.insert(envelope_handle);
        this.m_function = 4;
        return true;
    }

    private boolean iterateRed_() {
        this.m_envelope_handle_a = this.m_iterator_red.next();
        if (this.m_envelope_handle_a != -1) {
            return false;
        }
        this.m_envelope_handle_a = -1;
        this.m_envelope_handle_b = -1;
        int envelope_handle_blue = this.m_sorted_end_indices_blue.get(this.m_sweep_index_blue) >> 1;
        this.m_interval_tree_blue.insert(envelope_handle_blue);
        this.m_function = 7;
        return true;
    }

    private boolean iterateBlue_() {
        this.m_envelope_handle_b = this.m_iterator_blue.next();
        if (this.m_envelope_handle_b != -1) {
            return false;
        }
        int envelope_handle_red = this.m_sorted_end_indices_red.get(this.m_sweep_index_red) >> 1;
        this.m_interval_tree_red.insert(envelope_handle_red);
        this.m_function = 7;
        return true;
    }

    private boolean iterateBruteForce_() {
        if (--this.m_sweep_index_blue == -1) {
            this.m_function = 5;
            return true;
        }
        this.m_envelope_helper.setCoords(this.m_envelopes_red.get(this.m_sweep_index_red));
        Envelope2D envelope_b = this.m_envelopes_red.get(this.m_sweep_index_blue);
        this.m_envelope_helper.inflate(this.m_tolerance, this.m_tolerance);
        if (this.m_envelope_helper.isIntersecting(envelope_b)) {
            this.m_envelope_handle_b = this.m_sweep_index_blue;
            return false;
        }
        return true;
    }

    private boolean iterateRedBlueBruteForce_() {
        if (--this.m_sweep_index_blue == -1) {
            this.m_function = 6;
            return true;
        }
        this.m_envelope_helper.setCoords(this.m_envelopes_red.get(this.m_sweep_index_red));
        Envelope2D envelope_b = this.m_envelopes_blue.get(this.m_sweep_index_blue);
        this.m_envelope_helper.inflate(this.m_tolerance, this.m_tolerance);
        if (this.m_envelope_helper.isIntersecting(envelope_b)) {
            this.m_envelope_handle_b = this.m_sweep_index_blue;
            return false;
        }
        return true;
    }

    private boolean resetRed_() {
        if (this.m_interval_tree_red == null) {
            this.m_b_done = true;
            return false;
        }
        this.m_sweep_index_red = this.m_sorted_end_indices_red.size();
        if (this.m_interval_tree_red.size() > 0) {
            this.m_interval_tree_red.reset();
        }
        if (this.m_queued_list_red != -1) {
            this.m_queued_envelopes.deleteList(this.m_queued_list_red);
            this.m_queued_indices_red.resize(0);
            this.m_queued_list_red = -1;
        }
        this.m_b_done = false;
        return true;
    }

    private boolean resetBlue_() {
        if (this.m_interval_tree_blue == null) {
            this.m_b_done = true;
            return false;
        }
        this.m_sweep_index_blue = this.m_sorted_end_indices_blue.size();
        if (this.m_interval_tree_blue.size() > 0) {
            this.m_interval_tree_blue.reset();
        }
        if (this.m_queued_list_blue != -1) {
            this.m_queued_envelopes.deleteList(this.m_queued_list_blue);
            this.m_queued_indices_blue.resize(0);
            this.m_queued_list_blue = -1;
        }
        this.m_b_done = false;
        return true;
    }

    private void sortYEndIndices_(AttributeStreamOfInt32 end_indices, int begin_, int end_, boolean b_red) {
        if (this.m_bucket_sort == null) {
            this.m_bucket_sort = new BucketSort();
        }
        Envelope2DBucketSortHelper sorter = new Envelope2DBucketSortHelper(this, b_red);
        this.m_bucket_sort.sort(end_indices, begin_, end_, sorter);
    }

    private void sortYEndIndicesHelper_(AttributeStreamOfInt32 end_indices, int begin_, int end_, boolean b_red) {
        end_indices.Sort(begin_, end_, new EndPointsComparer(this, b_red));
    }

    private double getAdjustedValue_(int e, boolean b_red) {
        double dy = 0.5 * this.m_tolerance;
        if (b_red) {
            Envelope2D envelope_red = this.m_envelopes_red.get(e >> 1);
            double y = Envelope2DIntersectorImpl.isBottom_(e) ? envelope_red.ymin - dy : envelope_red.ymax + dy;
            return y;
        }
        Envelope2D envelope_blue = this.m_envelopes_blue.get(e >> 1);
        double y = Envelope2DIntersectorImpl.isBottom_(e) ? envelope_blue.ymin - dy : envelope_blue.ymax + dy;
        return y;
    }

    private static final class Envelope2DBucketSortHelper
    extends ClassicSort {
        private Envelope2DIntersectorImpl m_intersector;
        private boolean m_b_red;

        Envelope2DBucketSortHelper(Envelope2DIntersectorImpl intersector, boolean b_red) {
            this.m_intersector = intersector;
            this.m_b_red = b_red;
        }

        @Override
        public void userSort(int begin, int end, AttributeStreamOfInt32 indices) {
            this.m_intersector.sortYEndIndicesHelper_(indices, begin, end, this.m_b_red);
        }

        @Override
        public double getValue(int index) {
            return this.m_intersector.getAdjustedValue_(index, this.m_b_red);
        }
    }

    private static final class EndPointsComparer
    extends AttributeStreamOfInt32.IntComparator {
        private Envelope2DIntersectorImpl m_intersector;
        private boolean m_b_red;

        EndPointsComparer(Envelope2DIntersectorImpl intersector, boolean b_red) {
            this.m_intersector = intersector;
            this.m_b_red = b_red;
        }

        @Override
        public int compare(int e_1, int e_2) {
            double y2;
            double y1 = this.m_intersector.getAdjustedValue_(e_1, this.m_b_red);
            if (y1 < (y2 = this.m_intersector.getAdjustedValue_(e_2, this.m_b_red)) || y1 == y2 && Envelope2DIntersectorImpl.isBottom_(e_1) && Envelope2DIntersectorImpl.isTop_(e_2)) {
                return -1;
            }
            return 1;
        }
    }

    private static interface State {
        public static final int initialize = 0;
        public static final int initializeRed = 1;
        public static final int initializeBlue = 2;
        public static final int initializeRedBlue = 3;
        public static final int sweep = 4;
        public static final int sweepBruteForce = 5;
        public static final int sweepRedBlueBruteForce = 6;
        public static final int sweepRedBlue = 7;
        public static final int sweepRed = 8;
        public static final int sweepBlue = 9;
        public static final int iterate = 10;
        public static final int iterateRed = 11;
        public static final int iterateBlue = 12;
        public static final int iterateBruteForce = 13;
        public static final int iterateRedBlueBruteForce = 14;
        public static final int resetRed = 15;
        public static final int resetBlue = 16;
    }
}

