/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.com.esri.core.geometry;

class GeoJsonCrsTables {
    GeoJsonCrsTables() {
    }

    static int getWkidFromCrsShortForm(String crs_identifier) {
        int last_colon = crs_identifier.lastIndexOf(58);
        if (last_colon == -1) {
            return -1;
        }
        int code_start = last_colon + 1;
        int wkid = GeoJsonCrsTables.getWkidFromCrsCode_(crs_identifier, code_start);
        return wkid;
    }

    static int getWkidFromCrsName(String crs_identifier) {
        int wkid = -1;
        int last_colon = crs_identifier.lastIndexOf(58);
        if (last_colon == -1) {
            return -1;
        }
        int code_start = last_colon + 1;
        wkid = GeoJsonCrsTables.getWkidFromCrsCode_(crs_identifier, code_start);
        if (wkid != -1) {
            return wkid;
        }
        wkid = GeoJsonCrsTables.getWkidFromCrsOgcUrn(crs_identifier);
        return wkid;
    }

    static int getWkidFromCrsOgcUrn(String crs_identifier) {
        int wkid = -1;
        if (crs_identifier.regionMatches(0, "urn:ogc:def:crs:OGC", 0, 19)) {
            wkid = GeoJsonCrsTables.getWkidFromCrsOgcUrn_(crs_identifier);
        }
        return wkid;
    }

    private static int getWkidFromCrsCode_(String crs_identifier, int code_start) {
        assert (code_start > 0);
        int wkid = -1;
        int code_count = crs_identifier.length() - code_start;
        try {
            wkid = Integer.parseInt(crs_identifier.substring(code_start, code_start + code_count));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return wkid;
    }

    private static int getWkidFromCrsOgcUrn_(String crs_identifier) {
        assert (crs_identifier.regionMatches(0, "urn:ogc:def:crs:OGC", 0, 19));
        int last_colon = crs_identifier.lastIndexOf(58);
        if (last_colon == -1) {
            return -1;
        }
        int ogc_code_start = last_colon + 1;
        int ogc_code_count = crs_identifier.length() - ogc_code_start;
        if (crs_identifier.regionMatches(ogc_code_start, "CRS84", 0, ogc_code_count)) {
            return 4326;
        }
        if (crs_identifier.regionMatches(ogc_code_start, "CRS83", 0, ogc_code_count)) {
            return 4269;
        }
        if (crs_identifier.regionMatches(ogc_code_start, "CRS27", 0, ogc_code_count)) {
            return 4267;
        }
        return -1;
    }

    static int getWkidFromCrsHref(String crs_identifier) {
        int sr_org_code_start = -1;
        if (crs_identifier.regionMatches(0, "http://spatialreference.org/ref/epsg/", 0, 37)) {
            sr_org_code_start = 37;
        } else if (crs_identifier.regionMatches(0, "www.spatialreference.org/ref/epsg/", 0, 34)) {
            sr_org_code_start = 34;
        } else if (crs_identifier.regionMatches(0, "http://www.spatialreference.org/ref/epsg/", 0, 41)) {
            sr_org_code_start = 41;
        }
        if (sr_org_code_start != -1) {
            int sr_org_code_end = crs_identifier.indexOf(47, sr_org_code_start);
            if (sr_org_code_end == -1) {
                return -1;
            }
            int count = sr_org_code_end - sr_org_code_start;
            int wkid = -1;
            try {
                wkid = Integer.parseInt(crs_identifier.substring(sr_org_code_start, sr_org_code_start + count));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return wkid;
        }
        int open_gis_epsg_slash_end = -1;
        if (crs_identifier.regionMatches(0, "http://opengis.net/def/crs/EPSG/", 0, 32)) {
            open_gis_epsg_slash_end = 32;
        } else if (crs_identifier.regionMatches(0, "www.opengis.net/def/crs/EPSG/", 0, 29)) {
            open_gis_epsg_slash_end = 29;
        } else if (crs_identifier.regionMatches(0, "http://www.opengis.net/def/crs/EPSG/", 0, 36)) {
            open_gis_epsg_slash_end = 36;
        }
        if (open_gis_epsg_slash_end != -1) {
            int last_slash = crs_identifier.lastIndexOf(47);
            if (last_slash == -1) {
                return -1;
            }
            int open_gis_code_start = last_slash + 1;
            int count = crs_identifier.length() - open_gis_code_start;
            int wkid = -1;
            try {
                wkid = Integer.parseInt(crs_identifier.substring(open_gis_code_start, open_gis_code_start + count));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return wkid;
        }
        if (crs_identifier.compareToIgnoreCase("http://spatialreference.org/ref/sr-org/6928/ogcwkt/") == 0) {
            return 3857;
        }
        return -1;
    }

    static String getWktFromCrsName(String crs_identifier) {
        int last_colon = crs_identifier.lastIndexOf(58);
        int wkt_start = last_colon + 1;
        int wkt_count = crs_identifier.length() - wkt_start;
        String wkt = crs_identifier.substring(wkt_start, wkt_start + wkt_count);
        return wkt;
    }
}

