/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.com.yahoo.sketches.quantiles;

import com.alibaba.lindorm.thirdparty.com.yahoo.memory.NativeMemory;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.Family;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.quantiles.DoublesSketch;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.quantiles.DoublesSketchAccessor;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.quantiles.PreambleUtil;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.quantiles.Util;
import java.util.Arrays;

final class DoublesByteArrayImpl {
    private DoublesByteArrayImpl() {
    }

    static byte[] toByteArray(DoublesSketch sketch, boolean ordered, boolean compact) {
        boolean empty = sketch.isEmpty();
        int flags = (empty ? 4 : 0) | (ordered ? 16 : 0) | (compact ? 10 : 0);
        if (empty && !sketch.isDirect()) {
            byte[] outByteArr = new byte[8];
            NativeMemory memOut = new NativeMemory(outByteArr);
            Object memObj = memOut.array();
            long memAdd = memOut.getCumulativeOffset(0L);
            boolean preLongs = true;
            DoublesByteArrayImpl.insertPre0(memObj, memAdd, 1, flags, sketch.getK());
            return outByteArr;
        }
        return DoublesByteArrayImpl.convertToByteArray(sketch, flags, ordered, compact);
    }

    private static byte[] convertToByteArray(DoublesSketch sketch, int flags, boolean ordered, boolean compact) {
        int preLongs = 2;
        int extra = 2;
        int prePlusExtraBytes = 32;
        int k = sketch.getK();
        long n = sketch.getN();
        DoublesSketchAccessor dsa = DoublesSketchAccessor.wrap(sketch, !compact);
        int outBytes = compact ? sketch.getCompactStorageBytes() : sketch.getUpdatableStorageBytes();
        byte[] outByteArr = new byte[outBytes];
        NativeMemory memOut = new NativeMemory(outByteArr);
        Object memObj = memOut.array();
        long memAdd = memOut.getCumulativeOffset(0L);
        DoublesByteArrayImpl.insertPre0(memObj, memAdd, 2, flags, k);
        if (sketch.isEmpty()) {
            return outByteArr;
        }
        PreambleUtil.insertN(memObj, memAdd, n);
        PreambleUtil.insertMinDouble(memObj, memAdd, sketch.getMinValue());
        PreambleUtil.insertMaxDouble(memObj, memAdd, sketch.getMaxValue());
        long memOffsetBytes = 32L;
        int bbCnt = Util.computeBaseBufferItems(k, n);
        if (bbCnt > 0) {
            double[] bbItemsArr = dsa.getArray(0, bbCnt);
            if (ordered) {
                Arrays.sort(bbItemsArr);
            }
            memOut.putDoubleArray(memOffsetBytes, bbItemsArr, 0, bbCnt);
        }
        memOffsetBytes += (long)((compact ? bbCnt : 2 * k) << 3);
        int totalLevels = Util.computeTotalLevels(sketch.getBitPattern());
        for (int lvl = 0; lvl < totalLevels; ++lvl) {
            dsa.setLevel(lvl);
            if (dsa.numItems() <= 0) continue;
            assert (dsa.numItems() == k);
            memOut.putDoubleArray(memOffsetBytes, dsa.getArray(0, k), 0, k);
            memOffsetBytes += (long)(k << 3);
        }
        return outByteArr;
    }

    private static void insertPre0(Object memObj, long memAdd, int preLongs, int flags, int k) {
        PreambleUtil.insertPreLongs(memObj, memAdd, preLongs);
        PreambleUtil.insertSerVer(memObj, memAdd, 3);
        PreambleUtil.insertFamilyID(memObj, memAdd, Family.QUANTILES.getID());
        PreambleUtil.insertFlags(memObj, memAdd, flags);
        PreambleUtil.insertK(memObj, memAdd, k);
    }
}

