/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.com.yahoo.sketches.tuple;

import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.BinomialBoundsN;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.tuple.ArrayOfDoublesSketchIterator;

public abstract class ArrayOfDoublesSketch {
    static final int SIZE_OF_KEY_BYTES = 8;
    static final int SIZE_OF_VALUE_BYTES = 8;
    static final int PREAMBLE_LONGS_BYTE = 0;
    static final int SERIAL_VERSION_BYTE = 1;
    static final int FAMILY_ID_BYTE = 2;
    static final int SKETCH_TYPE_BYTE = 3;
    static final int FLAGS_BYTE = 4;
    static final int NUM_VALUES_BYTE = 5;
    static final int SEED_HASH_SHORT = 6;
    static final int THETA_LONG = 8;
    final int numValues_;
    long theta_;
    boolean isEmpty_ = true;

    ArrayOfDoublesSketch(int numValues) {
        this.numValues_ = numValues;
    }

    public double getEstimate() {
        if (!this.isEstimationMode()) {
            return this.getRetainedEntries();
        }
        return (double)this.getRetainedEntries() / this.getTheta();
    }

    public double getUpperBound(int numStdDev) {
        if (!this.isEstimationMode()) {
            return this.getRetainedEntries();
        }
        return BinomialBoundsN.getUpperBound(this.getRetainedEntries(), this.getTheta(), numStdDev, this.isEmpty_);
    }

    public double getLowerBound(int numStdDev) {
        if (!this.isEstimationMode()) {
            return this.getRetainedEntries();
        }
        return BinomialBoundsN.getLowerBound(this.getRetainedEntries(), this.getTheta(), numStdDev, this.isEmpty_);
    }

    public boolean isEmpty() {
        return this.isEmpty_;
    }

    public int getNumValues() {
        return this.numValues_;
    }

    public boolean isEstimationMode() {
        return this.theta_ < Long.MAX_VALUE && !this.isEmpty();
    }

    public double getTheta() {
        return (double)this.theta_ / 9.223372036854776E18;
    }

    public abstract int getRetainedEntries();

    public abstract byte[] toByteArray();

    public abstract double[][] getValues();

    long getThetaLong() {
        return this.theta_;
    }

    abstract short getSeedHash();

    public abstract ArrayOfDoublesSketchIterator iterator();

    static enum Flags {
        IS_BIG_ENDIAN,
        IS_IN_SAMPLING_MODE,
        IS_EMPTY,
        HAS_ENTRIES;

    }
}

