/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.netty.jctools.queues;

import com.alibaba.lindorm.thirdparty.netty.jctools.queues.BaseSpscLinkedArrayQueue;
import com.alibaba.lindorm.thirdparty.netty.jctools.queues.CircularArrayOffsetCalculator;
import com.alibaba.lindorm.thirdparty.netty.jctools.queues.SpscArrayQueue;
import com.alibaba.lindorm.thirdparty.netty.jctools.util.Pow2;
import com.alibaba.lindorm.thirdparty.netty.jctools.util.UnsafeRefArrayAccess;

public class SpscGrowableArrayQueue<E>
extends BaseSpscLinkedArrayQueue<E> {
    private int maxQueueCapacity;
    private long lookAheadStep;

    public SpscGrowableArrayQueue(int capacity) {
        this(Math.max(8, Pow2.roundToPowerOfTwo(capacity / 8)), capacity);
    }

    public SpscGrowableArrayQueue(int chunkSize, int capacity) {
        if (capacity < 16) {
            throw new IllegalArgumentException("Max capacity must be 4 or more");
        }
        if (chunkSize < 8) {
            throw new IllegalArgumentException("Chunk size must be 2 or more");
        }
        this.maxQueueCapacity = Pow2.roundToPowerOfTwo(capacity);
        int chunkCapacity = Pow2.roundToPowerOfTwo(chunkSize);
        if (chunkCapacity >= this.maxQueueCapacity) {
            throw new IllegalArgumentException("Initial capacity cannot exceed maximum capacity(both rounded up to a power of 2)");
        }
        long mask = chunkCapacity - 1;
        E[] buffer = CircularArrayOffsetCalculator.allocate(chunkCapacity + 1);
        this.producerBuffer = buffer;
        this.producerMask = mask;
        this.consumerBuffer = buffer;
        this.consumerMask = mask;
        this.producerBufferLimit = mask - 1L;
        this.adjustLookAheadStep(chunkCapacity);
        this.soProducerIndex(0L);
    }

    @Override
    protected final boolean offerColdPath(E[] buffer, long mask, E e, long index, long offset) {
        int maxCapacity;
        long lookAheadStep = this.lookAheadStep;
        if (lookAheadStep > 0L) {
            long lookAheadElementOffset = CircularArrayOffsetCalculator.calcElementOffset(index + lookAheadStep, mask);
            if (null == UnsafeRefArrayAccess.lvElement(buffer, lookAheadElementOffset)) {
                this.producerBufferLimit = index + lookAheadStep - 1L;
                this.writeToQueue(buffer, e, index, offset);
                return true;
            }
            int maxCapacity2 = this.maxQueueCapacity;
            if (mask + 1L == (long)maxCapacity2) {
                if (null == UnsafeRefArrayAccess.lvElement(buffer, offset)) {
                    this.writeToQueue(buffer, e, index, offset);
                    return true;
                }
                return false;
            }
            if (null == UnsafeRefArrayAccess.lvElement(buffer, CircularArrayOffsetCalculator.calcElementOffset(index + 1L, mask))) {
                this.writeToQueue(buffer, e, index, offset);
            } else {
                E[] newBuffer = CircularArrayOffsetCalculator.allocate((int)(2L * (mask + 1L) + 1L));
                this.producerBuffer = newBuffer;
                this.producerMask = newBuffer.length - 2;
                long offsetInNew = CircularArrayOffsetCalculator.calcElementOffset(index, this.producerMask);
                this.linkOldToNew(index, buffer, offset, newBuffer, offsetInNew, e);
                int newCapacity = (int)(this.producerMask + 1L);
                if (newCapacity == maxCapacity2) {
                    long currConsumerIndex = this.lvConsumerIndex();
                    this.lookAheadStep = -(index - currConsumerIndex);
                    this.producerBufferLimit = currConsumerIndex + (long)maxCapacity2 - 1L;
                } else {
                    this.producerBufferLimit = index + this.producerMask - 1L;
                    this.adjustLookAheadStep(newCapacity);
                }
            }
            return true;
        }
        long prevElementsInOtherBuffers = -lookAheadStep;
        long currConsumerIndex = this.lvConsumerIndex();
        int size = (int)(index - currConsumerIndex);
        if (size == (maxCapacity = (int)mask + 1)) {
            return false;
        }
        long firstIndexInCurrentBuffer = this.producerBufferLimit - (long)maxCapacity + prevElementsInOtherBuffers;
        if (currConsumerIndex >= firstIndexInCurrentBuffer) {
            this.adjustLookAheadStep(maxCapacity);
        } else {
            this.lookAheadStep = (int)(currConsumerIndex - firstIndexInCurrentBuffer);
        }
        this.producerBufferLimit = currConsumerIndex + (long)maxCapacity;
        this.writeToQueue(buffer, e, index, offset);
        return true;
    }

    private void adjustLookAheadStep(int capacity) {
        this.lookAheadStep = Math.min(capacity / 4, SpscArrayQueue.MAX_LOOK_AHEAD_STEP);
    }
}

