/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.enumerable;

import com.alibaba.lindorm.thirdparty.com.google.common.base.Supplier;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.DataContext;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.enumerable.EnumerableRel;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.enumerable.PhysType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.tree.BlockBuilder;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.tree.Expression;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.tree.Expressions;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptCluster;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelTrait;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelTraitSet;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelCollation;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelCollationTraitDef;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelDistribution;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelDistributionTraitDef;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelWriter;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.SingleRel;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.RelMdCollation;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.RelMdDistribution;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexDynamicParam;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexLiteral;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.BuiltInMethod;
import java.util.List;

public class EnumerableLimit
extends SingleRel
implements EnumerableRel {
    public final RexNode offset;
    public final RexNode fetch;

    public EnumerableLimit(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RexNode offset, RexNode fetch) {
        super(cluster, traitSet, input);
        this.offset = offset;
        this.fetch = fetch;
        assert (this.getConvention() instanceof EnumerableConvention);
        assert (this.getConvention() == input.getConvention());
    }

    public static EnumerableLimit create(final RelNode input, RexNode offset, RexNode fetch) {
        RelOptCluster cluster = input.getCluster();
        final RelMetadataQuery mq = cluster.getMetadataQuery();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE).replaceIfs(RelCollationTraitDef.INSTANCE, new Supplier<List<RelCollation>>(){

            @Override
            public List<RelCollation> get() {
                return RelMdCollation.limit(mq, input);
            }
        }).replaceIf(RelDistributionTraitDef.INSTANCE, new Supplier<RelDistribution>(){

            @Override
            public RelDistribution get() {
                return RelMdDistribution.limit(mq, input);
            }
        });
        return new EnumerableLimit(cluster, traitSet, input, offset, fetch);
    }

    @Override
    public EnumerableLimit copy(RelTraitSet traitSet, List<RelNode> newInputs) {
        return new EnumerableLimit(this.getCluster(), traitSet, EnumerableLimit.sole(newInputs), this.offset, this.fetch);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).itemIf("offset", this.offset, this.offset != null).itemIf("fetch", this.fetch, this.fetch != null);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        BlockBuilder builder = new BlockBuilder();
        EnumerableRel child = (EnumerableRel)this.getInput();
        EnumerableRel.Result result = implementor.visitChild(this, 0, child, pref);
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), result.format);
        Expression v = builder.append("child", result.block);
        if (this.offset != null) {
            v = builder.append("offset", Expressions.call(v, BuiltInMethod.SKIP.method, EnumerableLimit.getExpression(this.offset)));
        }
        if (this.fetch != null) {
            v = builder.append("fetch", Expressions.call(v, BuiltInMethod.TAKE.method, EnumerableLimit.getExpression(this.fetch)));
        }
        builder.add(Expressions.return_(null, v));
        return implementor.result(physType, builder.toBlock());
    }

    private static Expression getExpression(RexNode offset) {
        if (offset instanceof RexDynamicParam) {
            RexDynamicParam param = (RexDynamicParam)offset;
            return Expressions.convert_(Expressions.call((Expression)DataContext.ROOT, BuiltInMethod.DATA_CONTEXT_GET.method, Expressions.constant("?" + param.getIndex())), Integer.class);
        }
        return Expressions.constant(RexLiteral.intValue(offset));
    }
}

