/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;

public class AvaticaSqlException
extends SQLException {
    private static final long serialVersionUID = 1L;
    private final String errorMessage;
    private final List<String> stackTraces;
    private final String remoteServer;

    public AvaticaSqlException(String errorMessage, String sqlState, int errorCode, List<String> stackTraces, String remoteServer) {
        super("Error " + errorCode + " (" + sqlState + ") : " + errorMessage, sqlState, errorCode);
        this.errorMessage = errorMessage;
        this.stackTraces = Objects.requireNonNull(stackTraces);
        this.remoteServer = remoteServer;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public List<String> getStackTraces() {
        return this.stackTraces;
    }

    public String getRemoteServer() {
        return this.remoteServer;
    }

    @Override
    public void printStackTrace(PrintStream stream) {
        super.printStackTrace(stream);
        stream.flush();
        this.printServerStackTrace(new PrintStreamOrWriter(stream));
    }

    @Override
    public void printStackTrace(PrintWriter writer) {
        super.printStackTrace(writer);
        writer.flush();
        this.printServerStackTrace(new PrintStreamOrWriter(writer));
    }

    void printServerStackTrace(PrintStreamOrWriter streamOrWriter) {
        for (String serverStackTrace : this.stackTraces) {
            streamOrWriter.println(serverStackTrace);
        }
    }

    private static class PrintStreamOrWriter {
        private PrintStream stream;
        private PrintWriter writer;
        private final Type type;

        public PrintStreamOrWriter(PrintStream stream) {
            this.stream = stream;
            this.type = Type.STREAM;
        }

        public PrintStreamOrWriter(PrintWriter writer) {
            this.writer = writer;
            this.type = Type.WRITER;
        }

        public void println(String string) {
            switch (this.type) {
                case STREAM: {
                    this.stream.println(string);
                    this.stream.flush();
                    return;
                }
                case WRITER: {
                    this.writer.println(string);
                    this.writer.flush();
                    return;
                }
            }
            throw new IllegalStateException();
        }

        private static enum Type {
            STREAM,
            WRITER;

        }
    }
}

