/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.databind.deser.std;

import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.core.JsonParser;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.core.JsonToken;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.databind.BeanProperty;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.databind.DeserializationContext;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.databind.DeserializationFeature;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.databind.JavaType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.databind.JsonDeserializer;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.databind.JsonMappingException;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.databind.util.ObjectBuffer;
import java.io.IOException;

@JacksonStdImpl
public final class StringArrayDeserializer
extends StdDeserializer<String[]>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    public static final StringArrayDeserializer instance = new StringArrayDeserializer();
    protected JsonDeserializer<String> _elementDeserializer;

    public StringArrayDeserializer() {
        super(String[].class);
        this._elementDeserializer = null;
    }

    protected StringArrayDeserializer(JsonDeserializer<?> deser) {
        super(String[].class);
        this._elementDeserializer = deser;
    }

    @Override
    public String[] deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (!jp.isExpectedStartArrayToken()) {
            return this.handleNonArray(jp, ctxt);
        }
        if (this._elementDeserializer != null) {
            return this._deserializeCustom(jp, ctxt);
        }
        ObjectBuffer buffer = ctxt.leaseObjectBuffer();
        Object[] chunk = buffer.resetAndStart();
        int ix = 0;
        try {
            while (true) {
                String value;
                if ((value = jp.nextTextValue()) == null) {
                    JsonToken t = jp.getCurrentToken();
                    if (t == JsonToken.END_ARRAY) break;
                    if (t != JsonToken.VALUE_NULL) {
                        value = this._parseString(jp, ctxt);
                    }
                }
                if (ix >= chunk.length) {
                    chunk = buffer.appendCompletedChunk(chunk);
                    ix = 0;
                }
                chunk[ix++] = value;
            }
        }
        catch (Exception e) {
            throw JsonMappingException.wrapWithPath((Throwable)e, (Object)chunk, buffer.bufferedSize() + ix);
        }
        String[] result = buffer.completeAndClearBuffer(chunk, ix, String.class);
        ctxt.returnObjectBuffer(buffer);
        return result;
    }

    protected final String[] _deserializeCustom(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectBuffer buffer = ctxt.leaseObjectBuffer();
        Object[] chunk = buffer.resetAndStart();
        JsonDeserializer<String> deser = this._elementDeserializer;
        int ix = 0;
        try {
            while (true) {
                String value;
                if (jp.nextTextValue() == null) {
                    JsonToken t = jp.getCurrentToken();
                    if (t == JsonToken.END_ARRAY) break;
                    value = t == JsonToken.VALUE_NULL ? deser.getNullValue(ctxt) : deser.deserialize(jp, ctxt);
                } else {
                    value = deser.deserialize(jp, ctxt);
                }
                if (ix >= chunk.length) {
                    chunk = buffer.appendCompletedChunk(chunk);
                    ix = 0;
                }
                chunk[ix++] = value;
            }
        }
        catch (Exception e) {
            throw JsonMappingException.wrapWithPath((Throwable)e, String.class, ix);
        }
        String[] result = buffer.completeAndClearBuffer(chunk, ix, String.class);
        ctxt.returnObjectBuffer(buffer);
        return result;
    }

    @Override
    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromArray(jp, ctxt);
    }

    private final String[] handleNonArray(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (!ctxt.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY)) {
            String str;
            if (jp.getCurrentToken() == JsonToken.VALUE_STRING && ctxt.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT) && (str = jp.getText()).length() == 0) {
                return null;
            }
            throw ctxt.mappingException(this._valueClass);
        }
        return new String[]{jp.getCurrentToken() == JsonToken.VALUE_NULL ? null : this._parseString(jp, ctxt)};
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JsonDeserializer<Object> deser = this._elementDeserializer;
        deser = this.findConvertingContentDeserializer(ctxt, property, deser);
        JavaType type = ctxt.constructType(String.class);
        if ((deser = deser == null ? ctxt.findContextualValueDeserializer(type, property) : ctxt.handleSecondaryContextualization(deser, property, type)) != null && this.isDefaultDeserializer(deser)) {
            deser = null;
        }
        if (this._elementDeserializer != deser) {
            return new StringArrayDeserializer(deser);
        }
        return this;
    }
}

