/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.remote;

import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.ConnectionConfig;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.remote.AuthenticationType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.remote.AvaticaCommonsHttpClientImpl;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.remote.AvaticaCommonsHttpClientSpnegoImpl;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.remote.AvaticaHttpClient;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.remote.AvaticaHttpClientFactory;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.remote.DoAsAvaticaHttpClient;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.remote.KerberosConnection;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.remote.TrustStoreConfigurable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.remote.UsernamePasswordAuthenticateable;
import com.alibaba.lindorm.thirdparty.org.slf4j.Logger;
import com.alibaba.lindorm.thirdparty.org.slf4j.LoggerFactory;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Objects;

public class AvaticaHttpClientFactoryImpl
implements AvaticaHttpClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AvaticaHttpClientFactoryImpl.class);
    public static final String HTTP_CLIENT_IMPL_DEFAULT = AvaticaCommonsHttpClientImpl.class.getName();
    public static final String SPNEGO_HTTP_CLIENT_IMPL_DEFAULT = AvaticaCommonsHttpClientSpnegoImpl.class.getName();
    public static final AvaticaHttpClientFactoryImpl INSTANCE = new AvaticaHttpClientFactoryImpl();

    public static AvaticaHttpClientFactoryImpl getInstance() {
        return INSTANCE;
    }

    @Override
    public AvaticaHttpClient getClient(URL url, ConnectionConfig config, KerberosConnection kerberosUtil) {
        String className = config.httpClientClass();
        if (null == className) {
            className = "SPNEGO".equalsIgnoreCase(config.authentication()) ? SPNEGO_HTTP_CLIENT_IMPL_DEFAULT : HTTP_CLIENT_IMPL_DEFAULT;
        }
        AvaticaHttpClient client = this.instantiateClient(className, url);
        if (null != kerberosUtil) {
            client = new DoAsAvaticaHttpClient(client, kerberosUtil);
        }
        if (client instanceof TrustStoreConfigurable) {
            File truststore = config.truststore();
            String truststorePassword = config.truststorePassword();
            if (null != truststore && null != truststorePassword) {
                ((TrustStoreConfigurable)((Object)client)).setTrustStore(truststore, truststorePassword);
            }
        } else {
            LOG.debug("{} is not capable of SSL/TLS communication", (Object)client.getClass().getName());
        }
        if (client instanceof UsernamePasswordAuthenticateable) {
            String authString = config.authentication();
            if (null == authString) {
                return client;
            }
            AuthenticationType authType = AuthenticationType.valueOf(authString);
            String username = config.avaticaUser();
            String password = config.avaticaPassword();
            if (this.isUserPasswordAuth(authType)) {
                if (null != username && null != password) {
                    ((UsernamePasswordAuthenticateable)((Object)client)).setUsernamePassword(authType, username, password);
                } else {
                    LOG.debug("Username or password was null");
                }
            } else {
                LOG.debug("{} is not capable of username/password authentication.", (Object)authType);
            }
        }
        return client;
    }

    private AvaticaHttpClient instantiateClient(String className, URL url) {
        try {
            Class<?> clz = Class.forName(className);
            Constructor<?> constructor = clz.getConstructor(URL.class);
            Object instance = constructor.newInstance(Objects.requireNonNull(url));
            return (AvaticaHttpClient)AvaticaHttpClient.class.cast(instance);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to construct AvaticaHttpClient implementation " + className, e);
        }
    }

    private boolean isUserPasswordAuth(AuthenticationType authType) {
        return AuthenticationType.BASIC == authType || AuthenticationType.DIGEST == authType;
    }
}

