/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.jdbc;

import java.io.UnsupportedEncodingException;

public class LindormBytes {
    public static boolean isBinaryEquals(byte[] a, byte[] b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static String toStringBinary(byte[] b) {
        if (b == null) {
            return "null";
        }
        return LindormBytes.toStringBinary(b, 0, b.length);
    }

    public static String toStringBinary(byte[] b, int off, int len) {
        StringBuilder result = new StringBuilder();
        try {
            String first = new String(b, off, len, "ISO-8859-1");
            for (int i = 0; i < first.length(); ++i) {
                int ch = first.charAt(i) & 0xFF;
                if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || " `~!@#$%^&*()-_=+[]{}\\|;:'\",.<>/?".indexOf(ch) >= 0) {
                    result.append(first.charAt(i));
                    continue;
                }
                result.append(String.format("\\x%02X", ch));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("ISO-8859-1 not supported?", e);
        }
        return result.toString();
    }

    public static byte[] toBytesBinary(String in) {
        byte[] b = new byte[in.length()];
        int size = 0;
        for (int i = 0; i < in.length(); ++i) {
            char ch = in.charAt(i);
            if (ch == '\\' && in.length() > i + 3 && in.charAt(i + 1) == 'x') {
                char hd1 = in.charAt(i + 2);
                char hd2 = in.charAt(i + 3);
                if (!LindormBytes.isHexDigit(hd1) || !LindormBytes.isHexDigit(hd2)) {
                    b[size++] = (byte)ch;
                    continue;
                }
                byte d = (byte)((LindormBytes.toBinaryFromHex((byte)hd1) << 4) + LindormBytes.toBinaryFromHex((byte)hd2));
                b[size++] = d;
                i += 3;
                continue;
            }
            b[size++] = (byte)ch;
        }
        byte[] b2 = new byte[size];
        System.arraycopy(b, 0, b2, 0, size);
        return b2;
    }

    private static boolean isHexDigit(char c) {
        return c >= 'A' && c <= 'F' || c >= '0' && c <= '9';
    }

    public static byte toBinaryFromHex(byte ch) {
        if (ch >= 65 && ch <= 70) {
            return (byte)(10 + (byte)(ch - 65));
        }
        return (byte)(ch - 48);
    }
}

