/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.prepare;

import com.alibaba.lindorm.thirdparty.com.google.common.base.Function;
import com.alibaba.lindorm.thirdparty.com.google.common.base.Preconditions;
import com.alibaba.lindorm.thirdparty.com.google.common.base.Predicate;
import com.alibaba.lindorm.thirdparty.com.google.common.base.Predicates;
import com.alibaba.lindorm.thirdparty.com.google.common.collect.Collections2;
import com.alibaba.lindorm.thirdparty.com.google.common.collect.ImmutableList;
import com.alibaba.lindorm.thirdparty.com.google.common.collect.Iterables;
import com.alibaba.lindorm.thirdparty.com.google.common.collect.Lists;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.config.CalciteConnectionConfig;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.jdbc.CalciteSchema;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptPlanner;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptSchema;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.prepare.Prepare;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.prepare.RelOptTableImpl;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataTypeField;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.runtime.PredicateImpl;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.AggregateFunction;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.FunctionParameter;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.ScalarFunction;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.Table;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.TableFunction;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.TableMacro;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.Wrapper;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.impl.ScalarFunctionImpl;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlFunctionCategory;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlIdentifier;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlOperator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlOperatorBinding;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlSyntax;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.FamilyOperandTypeChecker;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.InferTypes;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.OperandTypes;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.ReturnTypes;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.SqlReturnTypeInference;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.SqlTypeFamily;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.SqlTypeName;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.validate.SqlMoniker;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.validate.SqlMonikerImpl;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.validate.SqlMonikerType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.validate.SqlNameMatcher;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.validate.SqlNameMatchers;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.validate.SqlUserDefinedAggFunction;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.validate.SqlUserDefinedFunction;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.validate.SqlUserDefinedTableFunction;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.validate.SqlUserDefinedTableMacro;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.validate.SqlValidatorUtil;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NavigableMap;
import java.util.NavigableSet;

public class CalciteCatalogReader
implements Prepare.CatalogReader {
    protected final CalciteSchema rootSchema;
    protected final RelDataTypeFactory typeFactory;
    private final List<List<String>> schemaPaths;
    protected final SqlNameMatcher nameMatcher;
    protected final CalciteConnectionConfig config;

    public CalciteCatalogReader(CalciteSchema rootSchema, List<String> defaultSchema, RelDataTypeFactory typeFactory, CalciteConnectionConfig config) {
        this(rootSchema, SqlNameMatchers.withCaseSensitive(config != null && config.caseSensitive()), ImmutableList.of(Preconditions.checkNotNull(defaultSchema), ImmutableList.of()), typeFactory, config);
    }

    protected CalciteCatalogReader(CalciteSchema rootSchema, SqlNameMatcher nameMatcher, List<List<String>> schemaPaths, RelDataTypeFactory typeFactory, CalciteConnectionConfig config) {
        this.rootSchema = Preconditions.checkNotNull(rootSchema);
        this.nameMatcher = nameMatcher;
        this.schemaPaths = Util.immutableCopy(Util.isDistinct(schemaPaths) ? schemaPaths : new LinkedHashSet<List<String>>(schemaPaths));
        this.typeFactory = typeFactory;
        this.config = config;
    }

    @Override
    public CalciteCatalogReader withSchemaPath(List<String> schemaPath) {
        return new CalciteCatalogReader(this.rootSchema, this.nameMatcher, ImmutableList.of(schemaPath, ImmutableList.of()), this.typeFactory, this.config);
    }

    @Override
    public Prepare.PreparingTable getTable(List<String> names) {
        for (List<String> schemaPath : this.schemaPaths) {
            Prepare.PreparingTable table = this.getTableFrom(names, schemaPath, this.nameMatcher);
            if (table == null) continue;
            return table;
        }
        return null;
    }

    @Override
    public CalciteConnectionConfig getConfig() {
        return this.config;
    }

    private Prepare.PreparingTable getTableFrom(List<String> names, List<String> schemaNames, SqlNameMatcher nameMatcher) {
        CalciteSchema schema = this.getSchema(Iterables.concat(schemaNames, Util.skipLast(names)), nameMatcher);
        if (schema == null) {
            return null;
        }
        String name = Util.last(names);
        CalciteSchema.TableEntry entry = schema.getTable(name, nameMatcher.isCaseSensitive());
        if (entry == null) {
            entry = schema.getTableBasedOnNullaryFunction(name, nameMatcher.isCaseSensitive());
        }
        if (entry != null) {
            Prepare.PreparingTable relOptTable;
            Table table = entry.getTable();
            if (table instanceof Wrapper && (relOptTable = ((Wrapper)((Object)table)).unwrap(Prepare.PreparingTable.class)) != null) {
                return relOptTable;
            }
            return RelOptTableImpl.create((RelOptSchema)this, table.getRowType(this.typeFactory), entry, null);
        }
        return null;
    }

    private Collection<com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.Function> getFunctionsFrom(List<String> names) {
        CalciteSchema schema;
        ArrayList<com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.Function> functions2 = Lists.newArrayList();
        ArrayList<List<String>> schemaNameList = new ArrayList<List<String>>();
        if (names.size() > 1) {
            if (this.schemaPaths.size() > 1) {
                schemaNameList.addAll(Util.skip(this.schemaPaths));
            } else {
                schemaNameList.addAll(this.schemaPaths);
            }
        } else {
            for (List<String> schemaPath : this.schemaPaths) {
                schema = this.getSchema(schemaPath, this.nameMatcher);
                if (schema == null) continue;
                schemaNameList.addAll(schema.getPath());
            }
        }
        for (List<String> schemaNames : schemaNameList) {
            schema = this.getSchema(Iterables.concat(schemaNames, Util.skipLast(names)), this.nameMatcher);
            if (schema == null) continue;
            String name = Util.last(names);
            functions2.addAll(schema.getFunctions(name, true));
        }
        return functions2;
    }

    private CalciteSchema getSchema(Iterable<String> schemaNames, SqlNameMatcher nameMatcher) {
        CalciteSchema schema = this.rootSchema;
        for (String schemaName : schemaNames) {
            if (schema == this.rootSchema && nameMatcher.matches(schemaName, schema.getName()) || (schema = schema.getSubSchema(schemaName, nameMatcher.isCaseSensitive())) != null) continue;
            return null;
        }
        return schema;
    }

    @Override
    public RelDataType getNamedType(SqlIdentifier typeName) {
        return null;
    }

    @Override
    public List<SqlMoniker> getAllSchemaObjectNames(List<String> names) {
        CalciteSchema schema = this.getSchema(names, this.nameMatcher);
        if (schema == null) {
            return ImmutableList.of();
        }
        ArrayList<SqlMoniker> result = new ArrayList<SqlMoniker>();
        if (!schema.name.equals("")) {
            result.add(this.moniker(schema, null, SqlMonikerType.SCHEMA));
        }
        NavigableMap<String, CalciteSchema> schemaMap = schema.getSubSchemaMap();
        for (String subSchema : schemaMap.keySet()) {
            result.add(this.moniker(schema, subSchema, SqlMonikerType.SCHEMA));
        }
        for (String table : schema.getTableNames()) {
            result.add(this.moniker(schema, table, SqlMonikerType.TABLE));
        }
        NavigableSet<String> functions = schema.getFunctionNames();
        for (String function : functions) {
            result.add(this.moniker(schema, function, SqlMonikerType.FUNCTION));
        }
        return result;
    }

    private SqlMonikerImpl moniker(CalciteSchema schema, String name, SqlMonikerType type) {
        List<String> path = schema.path(name);
        if (path.size() == 1 && !schema.root().name.equals("") && type == SqlMonikerType.SCHEMA) {
            type = SqlMonikerType.CATALOG;
        }
        return new SqlMonikerImpl(path, type);
    }

    @Override
    public List<List<String>> getSchemaPaths() {
        return this.schemaPaths;
    }

    @Override
    public Prepare.PreparingTable getTableForMember(List<String> names) {
        return this.getTable((List)names);
    }

    @Override
    public RelDataTypeField field(RelDataType rowType, String alias) {
        return this.nameMatcher.field(rowType, alias);
    }

    @Override
    public boolean matches(String string, String name) {
        return this.nameMatcher.matches(string, name);
    }

    @Override
    public RelDataType createTypeFromProjection(RelDataType type, List<String> columnNameList) {
        return SqlValidatorUtil.createTypeFromProjection(type, columnNameList, this.typeFactory, this.nameMatcher.isCaseSensitive());
    }

    @Override
    public void lookupOperatorOverloads(final SqlIdentifier opName, SqlFunctionCategory category, SqlSyntax syntax, List<SqlOperator> operatorList) {
        if (syntax != SqlSyntax.FUNCTION) {
            return;
        }
        PredicateImpl<com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.Function> predicate = category == null ? Predicates.alwaysTrue() : (category.isTableFunction() ? new PredicateImpl<com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.Function>(){

            @Override
            public boolean test(com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.Function function) {
                return function instanceof TableMacro || function instanceof TableFunction;
            }
        } : new PredicateImpl<com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.Function>(){

            @Override
            public boolean test(com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.Function function) {
                return !(function instanceof TableMacro) && !(function instanceof TableFunction);
            }
        });
        Collection<com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.Function> functions = Collections2.filter(this.getFunctionsFrom(opName.names), predicate);
        if (functions.isEmpty()) {
            return;
        }
        operatorList.addAll(Collections2.transform(functions, new Function<com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.Function, SqlOperator>(){

            @Override
            public SqlOperator apply(com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.Function function) {
                return CalciteCatalogReader.this.toOp(opName, function);
            }
        }));
    }

    private SqlOperator toOp(SqlIdentifier name, final com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.Function function) {
        ArrayList<RelDataType> argTypes = new ArrayList<RelDataType>();
        ArrayList<SqlTypeFamily> typeFamilies = new ArrayList<SqlTypeFamily>();
        for (FunctionParameter o : function.getParameters()) {
            RelDataType type = o.getType(this.typeFactory);
            argTypes.add(type);
            typeFamilies.add(Util.first(type.getSqlTypeName().getFamily(), SqlTypeFamily.ANY));
        }
        PredicateImpl<Integer> optional = new PredicateImpl<Integer>(){

            @Override
            public boolean test(Integer input) {
                return function.getParameters().get(input).isOptional();
            }
        };
        FamilyOperandTypeChecker typeChecker = OperandTypes.family(typeFamilies, (Predicate<Integer>)optional);
        List<RelDataType> paramTypes = this.toSql(argTypes);
        if (function instanceof ScalarFunction) {
            return new SqlUserDefinedFunction(name, this.infer((ScalarFunction)function), InferTypes.explicit(argTypes), (SqlOperandTypeChecker)typeChecker, paramTypes, function);
        }
        if (function instanceof AggregateFunction) {
            return new SqlUserDefinedAggFunction(name, this.infer((AggregateFunction)function), InferTypes.explicit(argTypes), typeChecker, (AggregateFunction)function, false, false, this.typeFactory);
        }
        if (function instanceof TableMacro) {
            return new SqlUserDefinedTableMacro(name, ReturnTypes.CURSOR, InferTypes.explicit(argTypes), (SqlOperandTypeChecker)typeChecker, paramTypes, (TableMacro)function);
        }
        if (function instanceof TableFunction) {
            return new SqlUserDefinedTableFunction(name, ReturnTypes.CURSOR, InferTypes.explicit(argTypes), (SqlOperandTypeChecker)typeChecker, paramTypes, (TableFunction)function);
        }
        throw new AssertionError((Object)("unknown function type " + function));
    }

    private SqlReturnTypeInference infer(final ScalarFunction function) {
        return new SqlReturnTypeInference(){

            @Override
            public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
                RelDataType type = function instanceof ScalarFunctionImpl ? ((ScalarFunctionImpl)function).getReturnType(CalciteCatalogReader.this.typeFactory, opBinding) : function.getReturnType(CalciteCatalogReader.this.typeFactory);
                return CalciteCatalogReader.this.toSql(type);
            }
        };
    }

    private SqlReturnTypeInference infer(final AggregateFunction function) {
        return new SqlReturnTypeInference(){

            @Override
            public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
                RelDataType type = function.getReturnType(CalciteCatalogReader.this.typeFactory);
                return CalciteCatalogReader.this.toSql(type);
            }
        };
    }

    private List<RelDataType> toSql(List<RelDataType> types) {
        return Lists.transform(types, new Function<RelDataType, RelDataType>(){

            @Override
            public RelDataType apply(RelDataType type) {
                return CalciteCatalogReader.this.toSql(type);
            }
        });
    }

    private RelDataType toSql(RelDataType type) {
        if (type instanceof RelDataTypeFactoryImpl.JavaType && ((RelDataTypeFactoryImpl.JavaType)type).getJavaClass() == Object.class) {
            return this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.ANY), true);
        }
        return JavaTypeFactoryImpl.toSql(this.typeFactory, type);
    }

    @Override
    public List<SqlOperator> getOperatorList() {
        return null;
    }

    @Override
    public CalciteSchema getRootSchema() {
        return this.rootSchema;
    }

    @Override
    public RelDataTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    @Override
    public void registerRules(RelOptPlanner planner) throws Exception {
    }

    @Override
    public boolean isCaseSensitive() {
        return this.nameMatcher.isCaseSensitive();
    }

    @Override
    public SqlNameMatcher nameMatcher() {
        return this.nameMatcher;
    }

    @Override
    public <C> C unwrap(Class<C> aClass) {
        if (aClass.isInstance(this)) {
            return aClass.cast(this);
        }
        return null;
    }
}

