/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata;

import com.alibaba.lindorm.thirdparty.com.google.common.base.Preconditions;
import com.alibaba.lindorm.thirdparty.com.google.common.collect.ImmutableList;
import com.alibaba.lindorm.thirdparty.com.google.common.collect.LinkedListMultimap;
import com.alibaba.lindorm.thirdparty.com.google.common.collect.Lists;
import com.alibaba.lindorm.thirdparty.com.google.common.collect.Ordering;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.enumerable.EnumerableMergeJoin;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.Ord;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.hep.HepRelVertex;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.volcano.RelSubset;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelCollation;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelCollationTraitDef;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelCollations;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelFieldCollation;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.Filter;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.Project;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.Sort;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.SortExchange;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.TableScan;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.Values;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.Window;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.BuiltInMetadata;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.MetadataDef;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.MetadataHandler;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.RelMetadataProvider;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexCall;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexCallBinding;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexInputRef;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexLiteral;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexProgram;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.validate.SqlMonotonicity;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.BuiltInMethod;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.ImmutableIntList;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Pair;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class RelMdCollation
implements MetadataHandler<BuiltInMetadata.Collation> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(BuiltInMethod.COLLATIONS.method, new RelMdCollation());

    private RelMdCollation() {
    }

    @Override
    public MetadataDef<BuiltInMetadata.Collation> getDef() {
        return BuiltInMetadata.Collation.DEF;
    }

    public ImmutableList<RelCollation> collations(RelNode rel, RelMetadataQuery mq) {
        return ImmutableList.of();
    }

    public ImmutableList<RelCollation> collations(Window rel, RelMetadataQuery mq) {
        return ImmutableList.copyOf(RelMdCollation.window(mq, rel.getInput(), rel.groups));
    }

    public ImmutableList<RelCollation> collations(Filter rel, RelMetadataQuery mq) {
        return mq.collations(rel.getInput());
    }

    public ImmutableList<RelCollation> collations(TableScan scan, RelMetadataQuery mq) {
        return ImmutableList.copyOf(RelMdCollation.table(scan.getTable()));
    }

    public ImmutableList<RelCollation> collations(EnumerableMergeJoin join, RelMetadataQuery mq) {
        return ImmutableList.copyOf(RelMdCollation.mergeJoin(mq, join.getLeft(), join.getRight(), join.getLeftKeys(), join.getRightKeys()));
    }

    public ImmutableList<RelCollation> collations(Sort sort, RelMetadataQuery mq) {
        return ImmutableList.copyOf(RelMdCollation.sort(sort.getCollation()));
    }

    public ImmutableList<RelCollation> collations(SortExchange sort, RelMetadataQuery mq) {
        return ImmutableList.copyOf(RelMdCollation.sort(sort.getCollation()));
    }

    public ImmutableList<RelCollation> collations(Project project, RelMetadataQuery mq) {
        return ImmutableList.copyOf(RelMdCollation.project(mq, project.getInput(), project.getProjects()));
    }

    public ImmutableList<RelCollation> collations(Values values, RelMetadataQuery mq) {
        return ImmutableList.copyOf(RelMdCollation.values(mq, values.getRowType(), values.getTuples()));
    }

    public ImmutableList<RelCollation> collations(HepRelVertex rel, RelMetadataQuery mq) {
        return mq.collations(rel.getCurrentRel());
    }

    public ImmutableList<RelCollation> collations(RelSubset rel, RelMetadataQuery mq) {
        return ImmutableList.copyOf((Collection)Preconditions.checkNotNull(rel.getTraitSet().getTraits(RelCollationTraitDef.INSTANCE)));
    }

    public static List<RelCollation> table(RelOptTable table) {
        return table.getCollationList();
    }

    public static List<RelCollation> sort(RelCollation collation) {
        return ImmutableList.of(collation);
    }

    public static List<RelCollation> filter(RelMetadataQuery mq, RelNode input) {
        return mq.collations(input);
    }

    public static List<RelCollation> limit(RelMetadataQuery mq, RelNode input) {
        return mq.collations(input);
    }

    public static List<RelCollation> calc(RelMetadataQuery mq, RelNode input, RexProgram program) {
        return program.getCollations(mq.collations(input));
    }

    public static List<RelCollation> project(RelMetadataQuery mq, RelNode input, List<? extends RexNode> projects) {
        TreeSet<RelCollation> collations = new TreeSet<RelCollation>();
        ImmutableList<RelCollation> inputCollations = mq.collations(input);
        if (inputCollations == null || inputCollations.isEmpty()) {
            return ImmutableList.of();
        }
        LinkedListMultimap<Integer, Integer> targets = LinkedListMultimap.create();
        HashMap<Integer, SqlMonotonicity> targetsWithMonotonicity = new HashMap<Integer, SqlMonotonicity>();
        for (Ord<? extends RexNode> ord : Ord.zip(projects)) {
            if (ord.e instanceof RexInputRef) {
                targets.put(((RexInputRef)ord.e).getIndex(), ord.i);
                continue;
            }
            if (!(ord.e instanceof RexCall)) continue;
            RexCall call = (RexCall)ord.e;
            RexCallBinding binding = RexCallBinding.create(input.getCluster().getTypeFactory(), call, inputCollations);
            targetsWithMonotonicity.put(ord.i, call.getOperator().getMonotonicity(binding));
        }
        ArrayList<RelFieldCollation> fieldCollations = new ArrayList<RelFieldCollation>();
        block4: for (RelCollation ic : inputCollations) {
            if (ic.getFieldCollations().isEmpty()) continue;
            fieldCollations.clear();
            for (RelFieldCollation ifc : ic.getFieldCollations()) {
                Collection integers = targets.get(ifc.getFieldIndex());
                if (integers.isEmpty()) continue block4;
                fieldCollations.add(ifc.copy((Integer)integers.iterator().next()));
            }
            assert (!fieldCollations.isEmpty());
            collations.add(RelCollations.of(fieldCollations));
        }
        ArrayList<RelFieldCollation> arrayList = new ArrayList<RelFieldCollation>();
        block6: for (Map.Entry entry : targetsWithMonotonicity.entrySet()) {
            SqlMonotonicity value = (SqlMonotonicity)((Object)entry.getValue());
            switch (value) {
                case NOT_MONOTONIC: 
                case CONSTANT: {
                    continue block6;
                }
            }
            arrayList.add(new RelFieldCollation((Integer)entry.getKey(), RelFieldCollation.Direction.of(value)));
        }
        if (!arrayList.isEmpty()) {
            collations.add(RelCollations.of(arrayList));
        }
        return ImmutableList.copyOf(collations);
    }

    public static List<RelCollation> window(RelMetadataQuery mq, RelNode input, ImmutableList<Window.Group> groups) {
        return mq.collations(input);
    }

    public static List<RelCollation> values(RelMetadataQuery mq, RelDataType rowType, ImmutableList<ImmutableList<RexLiteral>> tuples) {
        Util.discard(mq);
        ArrayList<RelCollation> list = Lists.newArrayList();
        int n = rowType.getFieldCount();
        ArrayList<Pair<RelFieldCollation, Ordering<List<RexLiteral>>>> pairs = Lists.newArrayList();
        block0: for (int i = 0; i < n; ++i) {
            pairs.clear();
            for (int j = i; j < n; ++j) {
                RelFieldCollation fieldCollation = new RelFieldCollation(j);
                Ordering<List<RexLiteral>> comparator = RelMdCollation.comparator(fieldCollation);
                Ordering<List<RexLiteral>> ordering = pairs.isEmpty() ? comparator : ((Ordering)((Pair)Util.last(pairs)).right).compound(comparator);
                pairs.add(Pair.of(fieldCollation, ordering));
                if (ordering.isOrdered(tuples)) continue;
                if (j == i) continue block0;
                pairs.remove(pairs.size() - 1);
            }
            if (pairs.isEmpty()) continue;
            list.add(RelCollations.of(Pair.left(pairs)));
        }
        return list;
    }

    private static Ordering<List<RexLiteral>> comparator(RelFieldCollation fieldCollation) {
        final int nullComparison = fieldCollation.nullDirection.nullComparison;
        final int x = fieldCollation.getFieldIndex();
        switch (fieldCollation.direction) {
            case ASCENDING: {
                return new Ordering<List<RexLiteral>>(){

                    @Override
                    public int compare(List<RexLiteral> o1, List<RexLiteral> o2) {
                        Comparable c1 = o1.get(x).getValueAs(Comparable.class);
                        Comparable c2 = o2.get(x).getValueAs(Comparable.class);
                        return RelFieldCollation.compare(c1, c2, nullComparison);
                    }
                };
            }
        }
        return new Ordering<List<RexLiteral>>(){

            @Override
            public int compare(List<RexLiteral> o1, List<RexLiteral> o2) {
                Comparable c1 = o1.get(x).getValueAs(Comparable.class);
                Comparable c2 = o2.get(x).getValueAs(Comparable.class);
                return RelFieldCollation.compare(c2, c1, -nullComparison);
            }
        };
    }

    public static List<RelCollation> mergeJoin(RelMetadataQuery mq, RelNode left, RelNode right, ImmutableIntList leftKeys, ImmutableIntList rightKeys) {
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableList<RelCollation> leftCollations = mq.collations(left);
        assert (RelCollations.contains(leftCollations, leftKeys)) : "cannot merge join: left input is not sorted on left keys";
        builder.addAll(leftCollations);
        ImmutableList<RelCollation> rightCollations = mq.collations(right);
        assert (RelCollations.contains(rightCollations, rightKeys)) : "cannot merge join: right input is not sorted on right keys";
        int leftFieldCount = left.getRowType().getFieldCount();
        for (RelCollation collation : rightCollations) {
            builder.add(RelCollations.shift(collation, leftFieldCount));
        }
        return builder.build();
    }
}

