/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata;

import com.alibaba.lindorm.thirdparty.com.google.common.collect.ImmutableSet;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.Aggregate;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.AggregateCall;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.Exchange;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.Filter;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.Join;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.Project;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.SetOp;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.Sort;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.TableFunctionScan;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.BuiltInMetadata;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.MetadataDef;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.MetadataHandler;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.RelColumnMapping;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.RelColumnOrigin;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.RelMetadataProvider;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexInputRef;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexVisitorImpl;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.BuiltInMethod;
import java.util.HashSet;
import java.util.Set;

public class RelMdColumnOrigins
implements MetadataHandler<BuiltInMetadata.ColumnOrigin> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(BuiltInMethod.COLUMN_ORIGIN.method, new RelMdColumnOrigins());

    private RelMdColumnOrigins() {
    }

    @Override
    public MetadataDef<BuiltInMetadata.ColumnOrigin> getDef() {
        return BuiltInMetadata.ColumnOrigin.DEF;
    }

    public Set<RelColumnOrigin> getColumnOrigins(Aggregate rel, RelMetadataQuery mq, int iOutputColumn) {
        if (iOutputColumn < rel.getGroupCount()) {
            return mq.getColumnOrigins(rel.getInput(), iOutputColumn);
        }
        if (rel.indicator && iOutputColumn < rel.getGroupCount() + rel.getIndicatorCount()) {
            return ImmutableSet.of();
        }
        AggregateCall call = rel.getAggCallList().get(iOutputColumn - rel.getGroupCount() - rel.getIndicatorCount());
        HashSet<RelColumnOrigin> set = new HashSet<RelColumnOrigin>();
        for (Integer iInput : call.getArgList()) {
            Set<RelColumnOrigin> inputSet = mq.getColumnOrigins(rel.getInput(), iInput);
            if ((inputSet = this.createDerivedColumnOrigins(inputSet)) == null) continue;
            set.addAll(inputSet);
        }
        return set;
    }

    public Set<RelColumnOrigin> getColumnOrigins(Join rel, RelMetadataQuery mq, int iOutputColumn) {
        Set<RelColumnOrigin> set;
        int nLeftColumns = rel.getLeft().getRowType().getFieldList().size();
        boolean derived = false;
        if (iOutputColumn < nLeftColumns) {
            set = mq.getColumnOrigins(rel.getLeft(), iOutputColumn);
            if (rel.getJoinType().generatesNullsOnLeft()) {
                derived = true;
            }
        } else {
            set = mq.getColumnOrigins(rel.getRight(), iOutputColumn - nLeftColumns);
            if (rel.getJoinType().generatesNullsOnRight()) {
                derived = true;
            }
        }
        if (derived) {
            set = this.createDerivedColumnOrigins(set);
        }
        return set;
    }

    public Set<RelColumnOrigin> getColumnOrigins(SetOp rel, RelMetadataQuery mq, int iOutputColumn) {
        HashSet<RelColumnOrigin> set = new HashSet<RelColumnOrigin>();
        for (RelNode input : rel.getInputs()) {
            Set<RelColumnOrigin> inputSet = mq.getColumnOrigins(input, iOutputColumn);
            if (inputSet == null) {
                return null;
            }
            set.addAll(inputSet);
        }
        return set;
    }

    public Set<RelColumnOrigin> getColumnOrigins(Project rel, final RelMetadataQuery mq, int iOutputColumn) {
        final RelNode input = rel.getInput();
        RexNode rexNode = rel.getProjects().get(iOutputColumn);
        if (rexNode instanceof RexInputRef) {
            RexInputRef inputRef = (RexInputRef)rexNode;
            return mq.getColumnOrigins(input, inputRef.getIndex());
        }
        final HashSet<RelColumnOrigin> set = new HashSet<RelColumnOrigin>();
        RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(true){

            @Override
            public Void visitInputRef(RexInputRef inputRef) {
                Set<RelColumnOrigin> inputSet = mq.getColumnOrigins(input, inputRef.getIndex());
                if (inputSet != null) {
                    set.addAll(inputSet);
                }
                return null;
            }
        };
        rexNode.accept(visitor);
        return this.createDerivedColumnOrigins(set);
    }

    public Set<RelColumnOrigin> getColumnOrigins(Filter rel, RelMetadataQuery mq, int iOutputColumn) {
        return mq.getColumnOrigins(rel.getInput(), iOutputColumn);
    }

    public Set<RelColumnOrigin> getColumnOrigins(Sort rel, RelMetadataQuery mq, int iOutputColumn) {
        return mq.getColumnOrigins(rel.getInput(), iOutputColumn);
    }

    public Set<RelColumnOrigin> getColumnOrigins(Exchange rel, RelMetadataQuery mq, int iOutputColumn) {
        return mq.getColumnOrigins(rel.getInput(), iOutputColumn);
    }

    public Set<RelColumnOrigin> getColumnOrigins(TableFunctionScan rel, RelMetadataQuery mq, int iOutputColumn) {
        HashSet<RelColumnOrigin> set = new HashSet<RelColumnOrigin>();
        Set<RelColumnMapping> mappings = rel.getColumnMappings();
        if (mappings == null) {
            if (rel.getInputs().size() > 0) {
                return null;
            }
            return set;
        }
        for (RelColumnMapping mapping : mappings) {
            int column;
            if (mapping.iOutputColumn != iOutputColumn) continue;
            RelNode input = rel.getInputs().get(mapping.iInputRel);
            Set<RelColumnOrigin> origins = mq.getColumnOrigins(input, column = mapping.iInputColumn);
            if (origins == null) {
                return null;
            }
            if (mapping.derived) {
                origins = this.createDerivedColumnOrigins(origins);
            }
            set.addAll(origins);
        }
        return set;
    }

    public Set<RelColumnOrigin> getColumnOrigins(RelNode rel, RelMetadataQuery mq, int iOutputColumn) {
        if (rel.getInputs().size() > 0) {
            return null;
        }
        HashSet<RelColumnOrigin> set = new HashSet<RelColumnOrigin>();
        RelOptTable table = rel.getTable();
        if (table == null) {
            return set;
        }
        if (table.getRowType() != rel.getRowType()) {
            return null;
        }
        set.add(new RelColumnOrigin(table, iOutputColumn, false));
        return set;
    }

    private Set<RelColumnOrigin> createDerivedColumnOrigins(Set<RelColumnOrigin> inputSet) {
        if (inputSet == null) {
            return null;
        }
        HashSet<RelColumnOrigin> set = new HashSet<RelColumnOrigin>();
        for (RelColumnOrigin rco : inputSet) {
            RelColumnOrigin derived = new RelColumnOrigin(rco.getOriginTable(), rco.getOriginColumnOrdinal(), true);
            set.add(derived);
        }
        return set;
    }
}

