/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.rules;

import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptRule;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptRuleCall;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptRuleOperand;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.Join;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.Project;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.RelFactories;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.SemiJoin;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.rules.PushProjector;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataTypeField;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.tools.RelBuilderFactory;
import java.util.ArrayList;

public class ProjectJoinTransposeRule
extends RelOptRule {
    public static final ProjectJoinTransposeRule INSTANCE = new ProjectJoinTransposeRule(PushProjector.ExprCondition.TRUE, RelFactories.LOGICAL_BUILDER);
    private final PushProjector.ExprCondition preserveExprCondition;

    public ProjectJoinTransposeRule(PushProjector.ExprCondition preserveExprCondition, RelBuilderFactory relFactory) {
        super(ProjectJoinTransposeRule.operand(Project.class, ProjectJoinTransposeRule.operand(Join.class, ProjectJoinTransposeRule.any()), new RelOptRuleOperand[0]), relFactory, null);
        this.preserveExprCondition = preserveExprCondition;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Project origProj = (Project)call.rel(0);
        Join join = (Join)call.rel(1);
        if (join instanceof SemiJoin) {
            return;
        }
        PushProjector pushProject = new PushProjector(origProj, join.getCondition(), join, this.preserveExprCondition, call.builder());
        if (pushProject.locateAllRefs()) {
            return;
        }
        Project leftProjRel = pushProject.createProjectRefsAndExprs(join.getLeft(), true, false);
        Project rightProjRel = pushProject.createProjectRefsAndExprs(join.getRight(), true, true);
        RexNode newJoinFilter = null;
        int[] adjustments = pushProject.getAdjustments();
        if (join.getCondition() != null) {
            ArrayList<RelDataTypeField> projJoinFieldList = new ArrayList<RelDataTypeField>();
            projJoinFieldList.addAll(join.getSystemFieldList());
            projJoinFieldList.addAll(leftProjRel.getRowType().getFieldList());
            projJoinFieldList.addAll(rightProjRel.getRowType().getFieldList());
            newJoinFilter = pushProject.convertRefsAndExprs(join.getCondition(), projJoinFieldList, adjustments);
        }
        Join newJoinRel = join.copy(join.getTraitSet(), newJoinFilter, leftProjRel, rightProjRel, join.getJoinType(), join.isSemiJoinDone());
        RelNode topProject = pushProject.createNewProject(newJoinRel, adjustments);
        call.transformTo(topProject);
    }
}

